/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.frame;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.frame.api.ApplicationExitListener;
import org.exbin.framework.frame.api.ApplicationFrameHandler;

@ParametersAreNonnullByDefault
public class ApplicationExitHandler {
    private final List<ApplicationExitListener> listeners = new ArrayList<ApplicationExitListener>();

    public void addListener(ApplicationExitListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ApplicationExitListener listener) {
        this.listeners.remove(listener);
    }

    public void executeExit(ApplicationFrameHandler frameHandler) {
        for (ApplicationExitListener listener : this.listeners) {
            boolean canContinue = listener.processExit(frameHandler);
            if (canContinue) continue;
            return;
        }
        System.exit(0);
    }

    public boolean canExit(ApplicationFrameHandler frameHandler) {
        for (ApplicationExitListener listener : this.listeners) {
            boolean canContinue = listener.processExit(frameHandler);
            if (canContinue) continue;
            return false;
        }
        return true;
    }
}

