/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.preferences;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.CodeType;
import org.exbin.bined.PositionCodeType;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.extended.theme.ExtendedBackgroundPaintMode;
import org.exbin.framework.api.Preferences;

@ParametersAreNonnullByDefault
public class LegacyPreferences {
    public static final String PREFERENCES_MEMORY_DELTA_MODE = "deltaMode";
    public static final String PREFERENCES_CODE_TYPE = "codeType";
    public static final String PREFERENCES_LINE_WRAPPING = "lineWrapping";
    public static final String PREFERENCES_SHOW_UNPRINTABLES = "showNonpritables";
    public static final String PREFERENCES_ENCODING_SELECTED = "selectedEncoding";
    public static final String PREFERENCES_ENCODING_PREFIX = "textEncoding.";
    public static final String PREFERENCES_BYTES_PER_LINE = "bytesPerLine";
    public static final String PREFERENCES_SHOW_HEADER = "showHeader";
    public static final String PREFERENCES_HEADER_SPACE_TYPE = "headerSpaceType";
    public static final String PREFERENCES_HEADER_SPACE = "headerSpace";
    public static final String PREFERENCES_SHOW_LINE_NUMBERS = "showLineNumbers";
    public static final String PREFERENCES_LINE_NUMBERS_LENGTH_TYPE = "lineNumbersLengthType";
    public static final String PREFERENCES_LINE_NUMBERS_LENGTH = "lineNumbersLength";
    public static final String PREFERENCES_LINE_NUMBERS_SPACE_TYPE = "lineNumbersSpaceType";
    public static final String PREFERENCES_LINE_NUMBERS_SPACE = "lineNumbersSpace";
    public static final String PREFERENCES_VIEW_MODE = "viewMode";
    public static final String PREFERENCES_BACKGROUND_MODE = "backgroundMode";
    public static final String PREFERENCES_PAINT_LINE_NUMBERS_BACKGROUND = "showLineNumbersBackground";
    public static final String PREFERENCES_POSITION_CODE_TYPE = "positionCodeType";
    public static final String PREFERENCES_HEX_CHARACTERS_CASE = "hexCharactersCase";
    public static final String PREFERENCES_DECORATION_HEADER_LINE = "decorationHeaderLine";
    public static final String PREFERENCES_DECORATION_PREVIEW_LINE = "decorationPreviewLine";
    public static final String PREFERENCES_DECORATION_BOX = "decorationBox";
    public static final String PREFERENCES_DECORATION_LINENUM_LINE = "decorationLineNumLine";
    public static final String PREFERENCES_BYTE_GROUP_SIZE = "byteGroupSize";
    public static final String PREFERENCES_SPACE_GROUP_SIZE = "spaceGroupSize";
    public static final String PREFERENCES_CODE_COLORIZATION = "codeColorization";
    public static final String PREFERENCES_SHOW_VALUES_PANEL = "valuesPanel";
    private final Preferences preferences;

    public LegacyPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Nonnull
    public String getSelectedEncoding() {
        return this.preferences.get(PREFERENCES_ENCODING_SELECTED, "UTF-8");
    }

    public void setSelectedEncoding(String encodingName) {
        this.preferences.put(PREFERENCES_ENCODING_SELECTED, encodingName);
    }

    @Nonnull
    public Collection<String> getEncodings() {
        String value;
        ArrayList<String> encodings = new ArrayList<String>();
        int i = 0;
        do {
            if ((value = (String)this.preferences.get(PREFERENCES_ENCODING_PREFIX + Integer.toString(i)).orElse(null)) == null) continue;
            encodings.add(value);
            ++i;
        } while (value != null);
        return encodings;
    }

    public void setEncodings(List<String> encodings) {
        for (int i = 0; i < encodings.size(); ++i) {
            this.preferences.put(PREFERENCES_ENCODING_PREFIX + Integer.toString(i), encodings.get(i));
        }
        this.preferences.remove(PREFERENCES_ENCODING_PREFIX + Integer.toString(encodings.size()));
    }

    @Nonnull
    private ExtendedBackgroundPaintMode convertBackgroundPaintMode(String value) {
        if ("STRIPPED".equals(value)) {
            return ExtendedBackgroundPaintMode.STRIPED;
        }
        return ExtendedBackgroundPaintMode.valueOf((String)value);
    }

    @Nonnull
    public CodeType getCodeType() {
        return CodeType.valueOf((String)this.preferences.get(PREFERENCES_CODE_TYPE, CodeType.HEXADECIMAL.name()));
    }

    public void setCodeType(CodeType codeType) {
        this.preferences.put(PREFERENCES_CODE_TYPE, codeType.name());
    }

    @Nonnull
    public Font getCodeFont(Font initialFont) {
        HashMap<TextAttribute, Object> attribs = new HashMap<TextAttribute, Object>();
        String value = this.preferences.get("textFont.family").orElse(null);
        if (value != null) {
            attribs.put(TextAttribute.FAMILY, value);
        }
        if ((value = (String)this.preferences.get("textFont.size").orElse(null)) != null) {
            attribs.put(TextAttribute.SIZE, Float.valueOf(Integer.valueOf(value).floatValue()));
        }
        if (this.preferences.getBoolean("textFont.underline", false)) {
            attribs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        }
        if (this.preferences.getBoolean("textFont.strikethrough", false)) {
            attribs.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if (this.preferences.getBoolean("textFont.strong", false)) {
            attribs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (this.preferences.getBoolean("textFont.italic", false)) {
            attribs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (this.preferences.getBoolean("textFont.subscript", false)) {
            attribs.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
        }
        if (this.preferences.getBoolean("textFont.superscript", false)) {
            attribs.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
        }
        Font font = initialFont.deriveFont(attribs);
        return font;
    }

    public void setCodeFont(Font font) {
        Map<TextAttribute, ?> attribs = font.getAttributes();
        String value = (String)attribs.get(TextAttribute.FAMILY);
        if (value != null) {
            this.preferences.put("textFont.family", value);
        } else {
            this.preferences.remove("textFont.family");
        }
        Float fontSize = (Float)attribs.get(TextAttribute.SIZE);
        if (fontSize != null) {
            this.preferences.put("textFont.size", Integer.toString((int)fontSize.floatValue()));
        } else {
            this.preferences.remove("textFont.size");
        }
        this.preferences.putBoolean("textFont.underline", TextAttribute.UNDERLINE_LOW_ONE_PIXEL.equals(attribs.get(TextAttribute.UNDERLINE)));
        this.preferences.putBoolean("textFont.strikethrough", TextAttribute.STRIKETHROUGH_ON.equals(attribs.get(TextAttribute.STRIKETHROUGH)));
        this.preferences.putBoolean("textFont.strong", TextAttribute.WEIGHT_BOLD.equals(attribs.get(TextAttribute.WEIGHT)));
        this.preferences.putBoolean("textFont.italic", TextAttribute.POSTURE_OBLIQUE.equals(attribs.get(TextAttribute.POSTURE)));
        this.preferences.putBoolean("textFont.subscript", TextAttribute.SUPERSCRIPT_SUB.equals(attribs.get(TextAttribute.SUPERSCRIPT)));
        this.preferences.putBoolean("textFont.superscript", TextAttribute.SUPERSCRIPT_SUPER.equals(attribs.get(TextAttribute.SUPERSCRIPT)));
    }

    public boolean isDeltaMemoryMode() {
        return this.preferences.getBoolean(PREFERENCES_MEMORY_DELTA_MODE, true);
    }

    public void setDeltaMemoryMode(boolean deltaMemoryMode) {
        this.preferences.putBoolean(PREFERENCES_MEMORY_DELTA_MODE, deltaMemoryMode);
    }

    public boolean isLineWrapping() {
        return this.preferences.getBoolean(PREFERENCES_LINE_WRAPPING, false);
    }

    public void setLineWrapping(boolean lineWrapping) {
        this.preferences.putBoolean(PREFERENCES_LINE_WRAPPING, lineWrapping);
    }

    public boolean isShowNonprintables() {
        return this.preferences.getBoolean(PREFERENCES_SHOW_UNPRINTABLES, false);
    }

    public void setShowUnprintables(boolean showUnprintables) {
        this.preferences.putBoolean(PREFERENCES_SHOW_UNPRINTABLES, showUnprintables);
    }

    public boolean isShowValuesPanel() {
        return this.preferences.getBoolean(PREFERENCES_SHOW_VALUES_PANEL, true);
    }

    public void setShowValuesPanel(boolean showValuesPanel) {
        this.preferences.putBoolean(PREFERENCES_SHOW_VALUES_PANEL, showValuesPanel);
    }

    @Nonnull
    public CodeCharactersCase getCodeCharactersCase() {
        return CodeCharactersCase.valueOf((String)this.preferences.get(PREFERENCES_HEX_CHARACTERS_CASE, CodeCharactersCase.UPPER.name()));
    }

    public void setCodeCharactersCase(CodeCharactersCase codeCharactersCase) {
        this.preferences.put(PREFERENCES_HEX_CHARACTERS_CASE, codeCharactersCase.name());
    }

    @Nonnull
    public PositionCodeType getPositionCodeType() {
        return PositionCodeType.valueOf((String)this.preferences.get(PREFERENCES_POSITION_CODE_TYPE, PositionCodeType.HEXADECIMAL.name()));
    }

    public void setPositionCodeType(PositionCodeType positionCodeType) {
        this.preferences.put(PREFERENCES_POSITION_CODE_TYPE, positionCodeType.name());
    }

    @Nonnull
    public ExtendedBackgroundPaintMode getBackgroundPaintMode() {
        return this.convertBackgroundPaintMode(this.preferences.get(PREFERENCES_BACKGROUND_MODE, ExtendedBackgroundPaintMode.STRIPED.name()));
    }

    @Nonnull
    public CodeAreaViewMode getViewMode() {
        String codeType = this.preferences.get(PREFERENCES_VIEW_MODE, CodeAreaViewMode.DUAL.name());
        if ("HEXADECIMAL".equals(codeType)) {
            return CodeAreaViewMode.CODE_MATRIX;
        }
        if ("PREVIEW".equals(codeType)) {
            return CodeAreaViewMode.TEXT_PREVIEW;
        }
        return CodeAreaViewMode.valueOf((String)codeType);
    }

    public void setViewMode(CodeAreaViewMode viewMode) {
        this.preferences.put(PREFERENCES_VIEW_MODE, viewMode.name());
    }

    public boolean isPaintRowPosBackground() {
        return this.preferences.getBoolean(PREFERENCES_PAINT_LINE_NUMBERS_BACKGROUND, true);
    }

    public boolean isCodeColorization() {
        return this.preferences.getBoolean(PREFERENCES_CODE_COLORIZATION, true);
    }

    public void setCodeColorization(boolean codeColorization) {
        this.preferences.putBoolean(PREFERENCES_CODE_COLORIZATION, codeColorization);
    }

    public boolean isUseDefaultFont() {
        return this.preferences.getBoolean("textFont.default", true);
    }

    public void setUseDefaultFont(boolean useDefaultFont) {
        this.preferences.putBoolean("textFont.default", useDefaultFont);
    }

    public boolean isShowHeader() {
        return this.preferences.getBoolean(PREFERENCES_SHOW_HEADER, true);
    }

    public void setShowHeader(boolean showHeader) {
        this.preferences.putBoolean(PREFERENCES_SHOW_HEADER, showHeader);
    }

    public boolean isShowLineNumbers() {
        return this.preferences.getBoolean(PREFERENCES_SHOW_LINE_NUMBERS, true);
    }

    public void setShowLineNumbers(boolean showLineNumbers) {
        this.preferences.putBoolean(PREFERENCES_SHOW_LINE_NUMBERS, showLineNumbers);
    }

    public boolean isDecorationHeaderLine() {
        return this.preferences.getBoolean(PREFERENCES_DECORATION_HEADER_LINE, true);
    }

    public void setDecorationHeaderLine(boolean decorationHeaderLine) {
        this.preferences.putBoolean(PREFERENCES_DECORATION_HEADER_LINE, decorationHeaderLine);
    }

    public boolean isDecorationLineNumLine() {
        return this.preferences.getBoolean(PREFERENCES_DECORATION_LINENUM_LINE, true);
    }

    public void setDecorationLineNumLine(boolean decorationLineNumLine) {
        this.preferences.putBoolean(PREFERENCES_DECORATION_LINENUM_LINE, decorationLineNumLine);
    }

    public boolean isDecorationPreviewLine() {
        return this.preferences.getBoolean(PREFERENCES_DECORATION_PREVIEW_LINE, true);
    }

    public void setDecorationPreviewLine(boolean decorationPreviewLine) {
        this.preferences.putBoolean(PREFERENCES_DECORATION_PREVIEW_LINE, decorationPreviewLine);
    }

    public boolean isDecorationBox() {
        return this.preferences.getBoolean(PREFERENCES_DECORATION_BOX, false);
    }

    public void setDecorationBox(boolean decorationBox) {
        this.preferences.putBoolean(PREFERENCES_DECORATION_BOX, decorationBox);
    }

    public int getByteGroupSize() {
        return this.preferences.getInt(PREFERENCES_BYTE_GROUP_SIZE, 1);
    }

    public void setByteGroupSize(int byteGroupSize) {
        this.preferences.putInt(PREFERENCES_BYTE_GROUP_SIZE, byteGroupSize);
    }

    public int getSpaceGroupSize() {
        return this.preferences.getInt(PREFERENCES_SPACE_GROUP_SIZE, 0);
    }

    public void setSpaceGroupSize(int spaceGroupSize) {
        this.preferences.putInt(PREFERENCES_SPACE_GROUP_SIZE, spaceGroupSize);
    }
}

