/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.preferences;

import java.awt.Font;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.CodeType;
import org.exbin.bined.PositionCodeType;
import org.exbin.bined.RowWrappingMode;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.bined.options.CodeAreaOptions;

@ParametersAreNonnullByDefault
public class CodeAreaPreferences
implements CodeAreaOptions {
    public static final String PREFERENCES_CODE_TYPE = "codeType";
    public static final String PREFERENCES_SHOW_UNPRINTABLES = "showNonpritables";
    public static final String PREFERENCES_BYTES_PER_LINE = "bytesPerLine";
    public static final String PREFERENCES_LINE_NUMBERS_LENGTH_TYPE = "lineNumbersLengthType";
    public static final String PREFERENCES_LINE_NUMBERS_LENGTH = "lineNumbersLength";
    public static final String PREFERENCES_VIEW_MODE = "viewMode";
    public static final String PREFERENCES_PAINT_LINE_NUMBERS_BACKGROUND = "showLineNumbersBackground";
    public static final String PREFERENCES_POSITION_CODE_TYPE = "positionCodeType";
    public static final String PREFERENCES_HEX_CHARACTERS_CASE = "hexCharactersCase";
    public static final String PREFERENCES_CODE_COLORIZATION = "codeColorization";
    public static final String PREFERENCES_ROW_WRAPPING_MODE = "rowWrappingMode";
    public static final String PREFERENCES_MAX_BYTES_PER_ROW = "maxBytesPerRow";
    public static final String PREFERENCES_MIN_ROW_POSITION_LENGTH = "minRowPositionLength";
    public static final String PREFERENCES_MAX_ROW_POSITION_LENGTH = "maxRowPositionLength";
    public static final Font DEFAULT_FONT = new Font("Monospaced", 0, 12);
    private final Preferences preferences;

    public CodeAreaPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    @Nonnull
    public CodeType getCodeType() {
        CodeType defaultCodeType = CodeType.HEXADECIMAL;
        try {
            return CodeType.valueOf((String)this.preferences.get(PREFERENCES_CODE_TYPE, defaultCodeType.name()));
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(CodeAreaPreferences.class.getName()).log(Level.SEVERE, null, ex);
            return defaultCodeType;
        }
    }

    @Override
    public void setCodeType(CodeType codeType) {
        this.preferences.put(PREFERENCES_CODE_TYPE, codeType.name());
    }

    @Override
    public boolean isShowUnprintables() {
        return this.preferences.getBoolean(PREFERENCES_SHOW_UNPRINTABLES, false);
    }

    @Override
    public void setShowUnprintables(boolean showUnprintables) {
        this.preferences.putBoolean(PREFERENCES_SHOW_UNPRINTABLES, showUnprintables);
    }

    @Override
    @Nonnull
    public CodeCharactersCase getCodeCharactersCase() {
        CodeCharactersCase defaultCharactersCase = CodeCharactersCase.UPPER;
        try {
            return CodeCharactersCase.valueOf((String)this.preferences.get(PREFERENCES_HEX_CHARACTERS_CASE, defaultCharactersCase.name()));
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(CodeAreaPreferences.class.getName()).log(Level.SEVERE, null, ex);
            return defaultCharactersCase;
        }
    }

    @Override
    public void setCodeCharactersCase(CodeCharactersCase codeCharactersCase) {
        this.preferences.put(PREFERENCES_HEX_CHARACTERS_CASE, codeCharactersCase.name());
    }

    @Override
    @Nonnull
    public PositionCodeType getPositionCodeType() {
        PositionCodeType defaultCodeType = PositionCodeType.HEXADECIMAL;
        try {
            return PositionCodeType.valueOf((String)this.preferences.get(PREFERENCES_POSITION_CODE_TYPE, defaultCodeType.name()));
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(CodeAreaPreferences.class.getName()).log(Level.SEVERE, null, ex);
            return defaultCodeType;
        }
    }

    @Override
    public void setPositionCodeType(PositionCodeType positionCodeType) {
        this.preferences.put(PREFERENCES_POSITION_CODE_TYPE, positionCodeType.name());
    }

    @Override
    @Nonnull
    public CodeAreaViewMode getViewMode() {
        CodeAreaViewMode defaultMode = CodeAreaViewMode.DUAL;
        try {
            return CodeAreaViewMode.valueOf((String)this.preferences.get(PREFERENCES_VIEW_MODE, defaultMode.name()));
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(CodeAreaPreferences.class.getName()).log(Level.SEVERE, null, ex);
            return defaultMode;
        }
    }

    @Override
    public void setViewMode(CodeAreaViewMode viewMode) {
        this.preferences.put(PREFERENCES_VIEW_MODE, viewMode.name());
    }

    public boolean isPaintRowPosBackground() {
        return this.preferences.getBoolean(PREFERENCES_PAINT_LINE_NUMBERS_BACKGROUND, true);
    }

    public void setPaintRowPosBackground(boolean paintRowPosBackground) {
        this.preferences.putBoolean(PREFERENCES_PAINT_LINE_NUMBERS_BACKGROUND, paintRowPosBackground);
    }

    @Override
    public boolean isCodeColorization() {
        return this.preferences.getBoolean(PREFERENCES_CODE_COLORIZATION, true);
    }

    @Override
    public void setCodeColorization(boolean codeColorization) {
        this.preferences.putBoolean(PREFERENCES_CODE_COLORIZATION, codeColorization);
    }

    @Override
    @Nonnull
    public RowWrappingMode getRowWrappingMode() {
        RowWrappingMode defaultMode = RowWrappingMode.NO_WRAPPING;
        try {
            return RowWrappingMode.valueOf((String)this.preferences.get(PREFERENCES_ROW_WRAPPING_MODE, defaultMode.name()));
        }
        catch (Exception ex) {
            Logger.getLogger(CodeAreaPreferences.class.getName()).log(Level.SEVERE, null, ex);
            return defaultMode;
        }
    }

    @Override
    public void setRowWrappingMode(RowWrappingMode rowWrappingMode) {
        this.preferences.put(PREFERENCES_ROW_WRAPPING_MODE, rowWrappingMode.name());
    }

    @Override
    public int getMaxBytesPerRow() {
        return this.preferences.getInt(PREFERENCES_MAX_BYTES_PER_ROW, 16);
    }

    @Override
    public void setMaxBytesPerRow(int maxBytesPerRow) {
        this.preferences.putInt(PREFERENCES_MAX_BYTES_PER_ROW, maxBytesPerRow);
    }

    @Override
    public int getMinRowPositionLength() {
        return this.preferences.getInt(PREFERENCES_MIN_ROW_POSITION_LENGTH, 0);
    }

    @Override
    public void setMinRowPositionLength(int minRowPositionLength) {
        this.preferences.putInt(PREFERENCES_MIN_ROW_POSITION_LENGTH, minRowPositionLength);
    }

    @Override
    public int getMaxRowPositionLength() {
        return this.preferences.getInt(PREFERENCES_MAX_ROW_POSITION_LENGTH, 0);
    }

    @Override
    public void setMaxRowPositionLength(int maxRowPositionLength) {
        this.preferences.putInt(PREFERENCES_MAX_ROW_POSITION_LENGTH, maxRowPositionLength);
    }
}

