/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.preferences;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.color.BasicCodeAreaDecorationColorType;
import org.exbin.bined.color.CodeAreaBasicColors;
import org.exbin.bined.color.CodeAreaColorType;
import org.exbin.bined.extended.color.CodeAreaUnprintablesColorType;
import org.exbin.bined.highlight.swing.color.CodeAreaColorizationColorType;
import org.exbin.bined.highlight.swing.color.CodeAreaMatchColorType;
import org.exbin.bined.swing.extended.color.ExtendedCodeAreaColorProfile;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.bined.options.CodeAreaColorOptions;

@ParametersAreNonnullByDefault
public class CodeAreaColorPreferences
implements CodeAreaColorOptions {
    public static final String PREFERENCES_COLOR_PROFILES_COUNT = "colorProfilesCount";
    public static final String PREFERENCES_COLOR_PROFILE_SELECTED = "colorProfileSelected";
    public static final String PREFERENCES_COLOR_PROFILE_NAME_PREFIX = "colorProfileName.";
    public static final String PREFERENCES_COLOR_VALUE_PREFIX = "color.";
    public static final String COLOR_TEXT_COLOR = "textColor";
    public static final String COLOR_TEXT_BACKGROUND = "textBackground";
    public static final String COLOR_SELECTION_COLOR = "selectionColor";
    public static final String COLOR_SELECTION_BACKGROUND = "selectionBackground";
    public static final String COLOR_SELECTION_MIRROR_COLOR = "selectionMirrorColor";
    public static final String COLOR_SELECTION_MIRROR_BACKGROUND = "selectionMirrorBackground";
    public static final String COLOR_ALTERNATE_COLOR = "alternateColor";
    public static final String COLOR_ALTERNATE_BACKGROUND = "alternateBackground";
    public static final String COLOR_CURSOR_COLOR = "cursorColor";
    public static final String COLOR_CURSOR_NEGATIVE_COLOR = "cursorNegativeColor";
    public static final String COLOR_LINE = "decoration.line";
    public static final String COLOR_CONTROL_CODES_COLOR = "controlCodesColor";
    public static final String COLOR_CONTROL_CODES_BACKGROUND = "controlCodesBackground";
    public static final String COLOR_UPPER_CODES_COLOR = "upperCodesColor";
    public static final String COLOR_UPPER_CODES_BACKGROUND = "upperCodesBackground";
    public static final String MATCH_COLOR = "matchColor";
    public static final String MATCH_BACKGROUND = "matchBackground";
    public static final String ACTIVE_MATCH_COLOR = "activeMatchColor";
    public static final String ACTIVE_MATCH_BACKGROUND = "activeMatchBackground";
    public static final String UNPRINTABLES_COLOR = "unprintablesColor";
    public static final String UNPRINTABLES_BACKGROUND = "unprintablesBackground";
    private final Preferences preferences;

    public CodeAreaColorPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Nonnull
    public List<String> getColorProfilesList() {
        ArrayList<String> profilesList = new ArrayList<String>();
        int profilesCount = this.preferences.getInt(PREFERENCES_COLOR_PROFILES_COUNT, 0);
        for (int i = 0; i < profilesCount; ++i) {
            String profileName = this.preferences.get(PREFERENCES_COLOR_PROFILE_NAME_PREFIX + String.valueOf(i), "");
            profilesList.add(profileName);
        }
        return profilesList;
    }

    public void setColorProfilesList(List<String> colorProfilesNames) {
        int themesCount = colorProfilesNames.size();
        this.preferences.putInt(PREFERENCES_COLOR_PROFILES_COUNT, themesCount);
        for (int i = 0; i < themesCount; ++i) {
            this.preferences.put(PREFERENCES_COLOR_PROFILE_NAME_PREFIX + String.valueOf(i), colorProfilesNames.get(i));
        }
    }

    @Override
    public int getSelectedProfile() {
        return this.preferences.getInt(PREFERENCES_COLOR_PROFILE_SELECTED, -1);
    }

    @Override
    public void setSelectedProfile(int profileIndex) {
        this.preferences.putInt(PREFERENCES_COLOR_PROFILE_SELECTED, profileIndex);
    }

    @Override
    @Nonnull
    public ExtendedCodeAreaColorProfile getColorsProfile(int profileIndex) {
        ExtendedCodeAreaColorProfile colorProfile = new ExtendedCodeAreaColorProfile();
        String colorProfilePrefix = PREFERENCES_COLOR_VALUE_PREFIX + String.valueOf(profileIndex) + ".";
        colorProfile.setColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_COLOR, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + COLOR_TEXT_COLOR)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_BACKGROUND, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + COLOR_TEXT_BACKGROUND)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaBasicColors.SELECTION_COLOR, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + COLOR_SELECTION_COLOR)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaBasicColors.SELECTION_BACKGROUND, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + COLOR_SELECTION_BACKGROUND)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaBasicColors.SELECTION_MIRROR_COLOR, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + COLOR_SELECTION_MIRROR_COLOR)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaBasicColors.SELECTION_MIRROR_BACKGROUND, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + COLOR_SELECTION_MIRROR_BACKGROUND)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaBasicColors.ALTERNATE_COLOR, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + COLOR_ALTERNATE_COLOR)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaBasicColors.ALTERNATE_BACKGROUND, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + COLOR_ALTERNATE_BACKGROUND)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaBasicColors.CURSOR_COLOR, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + COLOR_CURSOR_COLOR)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaBasicColors.CURSOR_NEGATIVE_COLOR, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + COLOR_CURSOR_NEGATIVE_COLOR)));
        colorProfile.setColor((CodeAreaColorType)BasicCodeAreaDecorationColorType.LINE, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + COLOR_LINE)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaColorizationColorType.CONTROL_CODES_COLOR, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + COLOR_CONTROL_CODES_COLOR)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaColorizationColorType.CONTROL_CODES_BACKGROUND, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + COLOR_CONTROL_CODES_BACKGROUND)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaColorizationColorType.UPPER_CODES_COLOR, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + COLOR_UPPER_CODES_COLOR)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaColorizationColorType.UPPER_CODES_BACKGROUND, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + COLOR_UPPER_CODES_BACKGROUND)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaMatchColorType.MATCH_COLOR, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + MATCH_COLOR)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaMatchColorType.MATCH_BACKGROUND, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + MATCH_BACKGROUND)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaMatchColorType.ACTIVE_MATCH_COLOR, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + ACTIVE_MATCH_COLOR)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaMatchColorType.ACTIVE_MATCH_BACKGROUND, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + ACTIVE_MATCH_BACKGROUND)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaUnprintablesColorType.UNPRINTABLES_COLOR, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + UNPRINTABLES_COLOR)));
        colorProfile.setColor((CodeAreaColorType)CodeAreaUnprintablesColorType.UNPRINTABLES_BACKGROUND, CodeAreaColorPreferences.textAsColor(this.preferences.get(colorProfilePrefix + UNPRINTABLES_BACKGROUND)));
        return colorProfile;
    }

    @Override
    public void setColorsProfile(int profileIndex, ExtendedCodeAreaColorProfile colorProfile) {
        String colorProfilePrefix = PREFERENCES_COLOR_VALUE_PREFIX + String.valueOf(profileIndex) + ".";
        this.preferences.put(colorProfilePrefix + COLOR_TEXT_COLOR, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_COLOR)));
        this.preferences.put(colorProfilePrefix + COLOR_TEXT_BACKGROUND, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_BACKGROUND)));
        this.preferences.put(colorProfilePrefix + COLOR_SELECTION_COLOR, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.SELECTION_COLOR)));
        this.preferences.put(colorProfilePrefix + COLOR_SELECTION_BACKGROUND, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.SELECTION_BACKGROUND)));
        this.preferences.put(colorProfilePrefix + COLOR_SELECTION_MIRROR_COLOR, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.SELECTION_MIRROR_COLOR)));
        this.preferences.put(colorProfilePrefix + COLOR_SELECTION_MIRROR_BACKGROUND, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.SELECTION_MIRROR_BACKGROUND)));
        this.preferences.put(colorProfilePrefix + COLOR_ALTERNATE_COLOR, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.ALTERNATE_COLOR)));
        this.preferences.put(colorProfilePrefix + COLOR_ALTERNATE_BACKGROUND, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.ALTERNATE_BACKGROUND)));
        this.preferences.put(colorProfilePrefix + COLOR_CURSOR_COLOR, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.CURSOR_COLOR)));
        this.preferences.put(colorProfilePrefix + COLOR_CURSOR_NEGATIVE_COLOR, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.CURSOR_NEGATIVE_COLOR)));
        this.preferences.put(colorProfilePrefix + COLOR_LINE, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)BasicCodeAreaDecorationColorType.LINE)));
        this.preferences.put(colorProfilePrefix + COLOR_CONTROL_CODES_COLOR, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaColorizationColorType.CONTROL_CODES_COLOR)));
        this.preferences.put(colorProfilePrefix + COLOR_CONTROL_CODES_BACKGROUND, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaColorizationColorType.CONTROL_CODES_BACKGROUND)));
        this.preferences.put(colorProfilePrefix + COLOR_UPPER_CODES_COLOR, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaColorizationColorType.UPPER_CODES_COLOR)));
        this.preferences.put(colorProfilePrefix + COLOR_UPPER_CODES_BACKGROUND, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaColorizationColorType.UPPER_CODES_BACKGROUND)));
        this.preferences.put(colorProfilePrefix + MATCH_COLOR, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaMatchColorType.MATCH_COLOR)));
        this.preferences.put(colorProfilePrefix + MATCH_BACKGROUND, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaMatchColorType.MATCH_BACKGROUND)));
        this.preferences.put(colorProfilePrefix + ACTIVE_MATCH_COLOR, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaMatchColorType.ACTIVE_MATCH_COLOR)));
        this.preferences.put(colorProfilePrefix + ACTIVE_MATCH_BACKGROUND, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaMatchColorType.ACTIVE_MATCH_BACKGROUND)));
        this.preferences.put(colorProfilePrefix + UNPRINTABLES_COLOR, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaUnprintablesColorType.UNPRINTABLES_COLOR)));
        this.preferences.put(colorProfilePrefix + UNPRINTABLES_BACKGROUND, CodeAreaColorPreferences.colorAsText(colorProfile.getColor((CodeAreaColorType)CodeAreaUnprintablesColorType.UNPRINTABLES_BACKGROUND)));
    }

    @Override
    public void removeColorsProfile(int profileIndex) {
        String colorProfilePrefix = PREFERENCES_COLOR_VALUE_PREFIX + String.valueOf(profileIndex) + ".";
        this.preferences.remove(colorProfilePrefix + COLOR_TEXT_COLOR);
        this.preferences.remove(colorProfilePrefix + COLOR_TEXT_BACKGROUND);
        this.preferences.remove(colorProfilePrefix + COLOR_SELECTION_COLOR);
        this.preferences.remove(colorProfilePrefix + COLOR_SELECTION_BACKGROUND);
        this.preferences.remove(colorProfilePrefix + COLOR_SELECTION_MIRROR_COLOR);
        this.preferences.remove(colorProfilePrefix + COLOR_SELECTION_MIRROR_BACKGROUND);
        this.preferences.remove(colorProfilePrefix + COLOR_ALTERNATE_COLOR);
        this.preferences.remove(colorProfilePrefix + COLOR_ALTERNATE_BACKGROUND);
        this.preferences.remove(colorProfilePrefix + COLOR_CURSOR_COLOR);
        this.preferences.remove(colorProfilePrefix + COLOR_CURSOR_NEGATIVE_COLOR);
        this.preferences.remove(colorProfilePrefix + COLOR_LINE);
        this.preferences.remove(colorProfilePrefix + COLOR_CONTROL_CODES_COLOR);
        this.preferences.remove(colorProfilePrefix + COLOR_CONTROL_CODES_BACKGROUND);
        this.preferences.remove(colorProfilePrefix + COLOR_UPPER_CODES_COLOR);
        this.preferences.remove(colorProfilePrefix + COLOR_UPPER_CODES_BACKGROUND);
        this.preferences.remove(colorProfilePrefix + MATCH_COLOR);
        this.preferences.remove(colorProfilePrefix + MATCH_BACKGROUND);
        this.preferences.remove(colorProfilePrefix + ACTIVE_MATCH_COLOR);
        this.preferences.remove(colorProfilePrefix + ACTIVE_MATCH_BACKGROUND);
        this.preferences.remove(colorProfilePrefix + UNPRINTABLES_COLOR);
        this.preferences.remove(colorProfilePrefix + UNPRINTABLES_BACKGROUND);
    }

    @Nullable
    private static String colorAsText(@Nullable Color color) {
        if (color == null) {
            return null;
        }
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return String.format("#%02x%02x%02x", red, green, blue);
    }

    @Nullable
    private static Color textAsColor(Optional<String> colorStr) {
        if (!colorStr.isPresent()) {
            return null;
        }
        return Color.decode(colorStr.get());
    }
}

