/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.exbin.bined.swing.extended.color.ExtendedCodeAreaColorProfile;
import org.exbin.framework.bined.options.CodeAreaColorOptions;
import org.exbin.framework.bined.preferences.CodeAreaColorPreferences;
import org.exbin.framework.options.api.OptionsData;

@ParametersAreNonnullByDefault
public class CodeAreaColorOptionsImpl
implements OptionsData,
CodeAreaColorOptions {
    private CodeAreaColorPreferences preferences;
    private final List<ProfileRecord> profileRecords = new ArrayList<ProfileRecord>();
    private int selectedProfile = -1;

    @Nonnull
    public List<String> getProfileNames() {
        ArrayList<String> profilesNames = new ArrayList<String>();
        this.profileRecords.forEach(profile -> profilesNames.add(profile.getName()));
        return profilesNames;
    }

    @Override
    @Nonnull
    public ExtendedCodeAreaColorProfile getColorsProfile(int index) {
        ProfileRecord record = this.profileRecords.get(index);
        if (record.profile == null) {
            record = new ProfileRecord(record.name, this.preferences.getColorsProfile(index));
            this.profileRecords.set(index, record);
        }
        return record.profile;
    }

    @Override
    public void setColorsProfile(int index, ExtendedCodeAreaColorProfile colorProfile) {
        ProfileRecord record = this.profileRecords.get(index);
        record = new ProfileRecord(record.name, colorProfile);
        this.profileRecords.set(index, record);
    }

    @Override
    public void removeColorsProfile(int index) {
        for (int i = index + 1; i < this.profileRecords.size(); ++i) {
            ProfileRecord record = this.profileRecords.get(i);
            if (record.profile != null) continue;
            record = new ProfileRecord(record.name, this.preferences.getColorsProfile(i));
            this.profileRecords.set(i, record);
        }
        if (this.selectedProfile == index) {
            this.selectedProfile = -1;
        } else if (this.selectedProfile > index) {
            --this.selectedProfile;
        }
        this.profileRecords.remove(index);
    }

    public void fullyLoad() {
        for (int i = 0; i < this.profileRecords.size(); ++i) {
            ProfileRecord record = this.profileRecords.get(i);
            if (record.profile != null) continue;
            record = new ProfileRecord(record.name, this.preferences.getColorsProfile(i));
            this.profileRecords.set(i, record);
        }
    }

    @Override
    public int getSelectedProfile() {
        return this.selectedProfile;
    }

    @Override
    public void setSelectedProfile(int profileIndex) {
        this.selectedProfile = profileIndex;
    }

    public void clearProfiles() {
        this.profileRecords.clear();
    }

    public void addProfile(String profileName, ExtendedCodeAreaColorProfile colorProfile) {
        this.profileRecords.add(new ProfileRecord(profileName, colorProfile));
    }

    public void loadFromPreferences(CodeAreaColorPreferences preferences) {
        this.preferences = preferences;
        this.profileRecords.clear();
        List<String> colorProfilesList = preferences.getColorProfilesList();
        colorProfilesList.forEach(name -> this.profileRecords.add(new ProfileRecord((String)name, null)));
        this.selectedProfile = preferences.getSelectedProfile();
    }

    public void saveToPreferences(CodeAreaColorPreferences preferences) {
        preferences.setSelectedProfile(this.selectedProfile);
        preferences.setColorProfilesList(this.getProfileNames());
        for (int i = 0; i < this.profileRecords.size(); ++i) {
            ProfileRecord record = this.profileRecords.get(i);
            ExtendedCodeAreaColorProfile profile = record.profile;
            if (profile == null) continue;
            preferences.setColorsProfile(i, record.profile);
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static class ProfileRecord {
        private final String name;
        private final ExtendedCodeAreaColorProfile profile;

        public ProfileRecord(String name, ExtendedCodeAreaColorProfile profile) {
            this.name = name;
            this.profile = profile;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public ExtendedCodeAreaColorProfile getProfile() {
            return this.profile;
        }
    }
}

