/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.gui;

import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.exbin.bined.PositionCodeType;
import org.exbin.framework.bined.StatusCursorPositionFormat;
import org.exbin.framework.bined.StatusDocumentSizeFormat;
import org.exbin.framework.bined.options.impl.StatusOptionsImpl;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class StatusOptionsPanel
extends JPanel
implements OptionsComponent<StatusOptionsImpl> {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(StatusOptionsPanel.class);
    private JComboBox<String> cursorPositionCodeTypeComboBox;
    private JLabel cursorPositionCodeTypeLabel;
    private JCheckBox cursorPositionShowOffsetCheckBox;
    private JLabel decimalGroupSizeLabel;
    private JSpinner decimalGroupSizeSpinner;
    private JComboBox<String> documentSizeCodeTypeComboBox;
    private JLabel documentSizeCodeTypeLabel;
    private JCheckBox documentSizeShowRelativeCheckBox;
    private JLabel hexadecimalGroupSizeLabel;
    private JSpinner hexadecimalGroupSizeSpinner;
    private JLabel octalGroupSizeLabel;
    private JSpinner octalGroupSizeSpinner;

    public StatusOptionsPanel() {
        this.initComponents();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setCursorPositionCodeTypes(List<String> cursorPositionCodeTypes) {
        for (String cursorPositionCodeType : cursorPositionCodeTypes) {
            this.cursorPositionCodeTypeComboBox.addItem(cursorPositionCodeType);
        }
    }

    public void setDocumentSizeCodeTypes(List<String> documentSizeCodeTypes) {
        for (String documentSizeCodeType : documentSizeCodeTypes) {
            this.documentSizeCodeTypeComboBox.addItem(documentSizeCodeType);
        }
    }

    public void saveToOptions(StatusOptionsImpl options) {
        StatusCursorPositionFormat cursorPositionFormat = new StatusCursorPositionFormat();
        cursorPositionFormat.setCodeType(PositionCodeType.values()[this.cursorPositionCodeTypeComboBox.getSelectedIndex()]);
        cursorPositionFormat.setShowOffset(this.cursorPositionShowOffsetCheckBox.isSelected());
        options.setCursorPositionFormat(cursorPositionFormat);
        StatusDocumentSizeFormat documentSizeFormat = new StatusDocumentSizeFormat();
        documentSizeFormat.setCodeType(PositionCodeType.values()[this.documentSizeCodeTypeComboBox.getSelectedIndex()]);
        documentSizeFormat.setShowRelative(this.cursorPositionShowOffsetCheckBox.isSelected());
        options.setDocumentSizeFormat(documentSizeFormat);
        options.setOctalSpaceGroupSize((Integer)this.octalGroupSizeSpinner.getValue());
        options.setDecimalSpaceGroupSize((Integer)this.decimalGroupSizeSpinner.getValue());
        options.setHexadecimalSpaceGroupSize((Integer)this.hexadecimalGroupSizeSpinner.getValue());
    }

    public void loadFromOptions(StatusOptionsImpl options) {
        StatusCursorPositionFormat cursorPositionFormat = options.getCursorPositionFormat();
        this.cursorPositionCodeTypeComboBox.setSelectedIndex(cursorPositionFormat.getCodeType().ordinal());
        this.cursorPositionShowOffsetCheckBox.setSelected(cursorPositionFormat.isShowOffset());
        StatusDocumentSizeFormat documentSizeFormat = options.getDocumentSizeFormat();
        this.documentSizeCodeTypeComboBox.setSelectedIndex(documentSizeFormat.getCodeType().ordinal());
        this.cursorPositionShowOffsetCheckBox.setSelected(documentSizeFormat.isShowRelative());
        this.octalGroupSizeSpinner.setValue(options.getOctalSpaceGroupSize());
        this.decimalGroupSizeSpinner.setValue(options.getDecimalSpaceGroupSize());
        this.hexadecimalGroupSizeSpinner.setValue(options.getHexadecimalSpaceGroupSize());
    }

    private void initComponents() {
        this.cursorPositionCodeTypeLabel = new JLabel();
        this.cursorPositionCodeTypeComboBox = new JComboBox();
        this.cursorPositionShowOffsetCheckBox = new JCheckBox();
        this.documentSizeCodeTypeLabel = new JLabel();
        this.documentSizeCodeTypeComboBox = new JComboBox();
        this.documentSizeShowRelativeCheckBox = new JCheckBox();
        this.octalGroupSizeLabel = new JLabel();
        this.octalGroupSizeSpinner = new JSpinner();
        this.decimalGroupSizeLabel = new JLabel();
        this.decimalGroupSizeSpinner = new JSpinner();
        this.hexadecimalGroupSizeLabel = new JLabel();
        this.hexadecimalGroupSizeSpinner = new JSpinner();
        this.cursorPositionCodeTypeLabel.setText(this.resourceBundle.getString("cursorPositionCodeTypeLabel.text"));
        this.cursorPositionShowOffsetCheckBox.setSelected(true);
        this.cursorPositionShowOffsetCheckBox.setText(this.resourceBundle.getString("cursorPositionShowOffsetCheckBox.text"));
        this.documentSizeCodeTypeLabel.setText(this.resourceBundle.getString("documentSizeCodeTypeLabel.text"));
        this.documentSizeShowRelativeCheckBox.setSelected(true);
        this.documentSizeShowRelativeCheckBox.setText(this.resourceBundle.getString("documentSizeShowRelativeCheckBox.text"));
        this.octalGroupSizeLabel.setText(this.resourceBundle.getString("octalGroupSizeLabel.text"));
        this.octalGroupSizeSpinner.setModel(new SpinnerNumberModel((Number)4, Integer.valueOf(0), null, (Number)1));
        this.decimalGroupSizeLabel.setText(this.resourceBundle.getString("decimalGroupSizeLabel.text"));
        this.decimalGroupSizeSpinner.setModel(new SpinnerNumberModel((Number)3, Integer.valueOf(0), null, (Number)1));
        this.hexadecimalGroupSizeLabel.setText(this.resourceBundle.getString("hexadecimalGroupSizeLabel.text"));
        this.hexadecimalGroupSizeSpinner.setModel(new SpinnerNumberModel((Number)4, Integer.valueOf(0), null, (Number)1));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cursorPositionCodeTypeComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.documentSizeCodeTypeComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.cursorPositionCodeTypeLabel).addComponent(this.cursorPositionShowOffsetCheckBox).addComponent(this.documentSizeCodeTypeLabel).addComponent(this.documentSizeShowRelativeCheckBox).addComponent(this.decimalGroupSizeSpinner, -2, 0, Short.MAX_VALUE).addComponent(this.octalGroupSizeSpinner, -2, 0, Short.MAX_VALUE).addComponent(this.hexadecimalGroupSizeSpinner, -2, 0, Short.MAX_VALUE).addComponent(this.decimalGroupSizeLabel).addComponent(this.octalGroupSizeLabel).addComponent(this.hexadecimalGroupSizeLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.cursorPositionCodeTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cursorPositionCodeTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cursorPositionShowOffsetCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.documentSizeCodeTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.documentSizeCodeTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.documentSizeShowRelativeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.octalGroupSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.octalGroupSizeSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decimalGroupSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decimalGroupSizeSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hexadecimalGroupSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hexadecimalGroupSizeSpinner, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new StatusOptionsPanel());
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
    }
}

