/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.gui;

import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.CodeType;
import org.exbin.bined.PositionCodeType;
import org.exbin.bined.RowWrappingMode;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.framework.bined.options.impl.CodeAreaOptionsImpl;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class CodeAreaOptionsPanel
extends JPanel
implements OptionsComponent<CodeAreaOptionsImpl> {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CodeAreaOptionsPanel.class);
    private JComboBox<String> codeCharactersModeComboBox;
    private JCheckBox codeColorizationCheckBox;
    private JComboBox<String> codeTypeComboBox;
    private JLabel codeTypeScrollModeLabel;
    private JLabel hexCharactersModeLabel;
    private JLabel maxBytesPerRowLabel;
    private JSpinner maxBytesPerRowSpinner;
    private JLabel maxRowPositionLengthLabel;
    private JSpinner maxRowPositionLengthSpinner;
    private JLabel minRowPositionLengthLabel;
    private JSpinner minRowPositionLengthSpinner;
    private JComboBox<String> positionCodeTypeComboBox;
    private JLabel positionCodeTypeLabel;
    private JCheckBox rowWrappingModeCheckBox;
    private JCheckBox showNonprintableCharactersCheckBox;
    private JComboBox<String> viewModeComboBox;
    private JLabel viewModeScrollModeLabel;

    public CodeAreaOptionsPanel() {
        this.initComponents();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setViewModes(List<String> viewModes) {
        for (String viewMode : viewModes) {
            this.viewModeComboBox.addItem(viewMode);
        }
    }

    public void setCodeTypes(List<String> codeTypes) {
        for (String codeType : codeTypes) {
            this.codeTypeComboBox.addItem(codeType);
        }
    }

    public void setPositionCodeTypes(List<String> positionCodeTypes) {
        for (String positionCodeType : positionCodeTypes) {
            this.positionCodeTypeComboBox.addItem(positionCodeType);
        }
    }

    public void setCharactersCases(List<String> charactersCases) {
        for (String charactersCase : charactersCases) {
            this.codeCharactersModeComboBox.addItem(charactersCase);
        }
    }

    public void saveToOptions(CodeAreaOptionsImpl options) {
        options.setCodeType(CodeType.values()[this.codeTypeComboBox.getSelectedIndex()]);
        options.setShowUnprintables(this.showNonprintableCharactersCheckBox.isSelected());
        options.setCodeCharactersCase(CodeCharactersCase.values()[this.codeCharactersModeComboBox.getSelectedIndex()]);
        options.setPositionCodeType(PositionCodeType.values()[this.positionCodeTypeComboBox.getSelectedIndex()]);
        options.setViewMode(CodeAreaViewMode.values()[this.viewModeComboBox.getSelectedIndex()]);
        options.setCodeColorization(this.codeColorizationCheckBox.isSelected());
        options.setRowWrappingMode(this.rowWrappingModeCheckBox.isSelected() ? RowWrappingMode.WRAPPING : RowWrappingMode.NO_WRAPPING);
        options.setMaxBytesPerRow((Integer)this.maxBytesPerRowSpinner.getValue());
        options.setMinRowPositionLength((Integer)this.minRowPositionLengthSpinner.getValue());
        options.setMaxRowPositionLength((Integer)this.maxRowPositionLengthSpinner.getValue());
    }

    public void loadFromOptions(CodeAreaOptionsImpl options) {
        this.codeTypeComboBox.setSelectedIndex(options.getCodeType().ordinal());
        this.showNonprintableCharactersCheckBox.setSelected(options.isShowUnprintables());
        this.codeCharactersModeComboBox.setSelectedIndex(options.getCodeCharactersCase().ordinal());
        this.positionCodeTypeComboBox.setSelectedIndex(options.getPositionCodeType().ordinal());
        this.viewModeComboBox.setSelectedIndex(options.getViewMode().ordinal());
        this.codeColorizationCheckBox.setSelected(options.isCodeColorization());
        this.rowWrappingModeCheckBox.setSelected(options.getRowWrappingMode() == RowWrappingMode.WRAPPING);
        this.maxBytesPerRowSpinner.setValue(options.getMaxBytesPerRow());
        this.minRowPositionLengthSpinner.setValue(options.getMinRowPositionLength());
        this.maxRowPositionLengthSpinner.setValue(options.getMaxRowPositionLength());
    }

    private void initComponents() {
        this.codeCharactersModeComboBox = new JComboBox();
        this.viewModeComboBox = new JComboBox();
        this.showNonprintableCharactersCheckBox = new JCheckBox();
        this.viewModeScrollModeLabel = new JLabel();
        this.codeColorizationCheckBox = new JCheckBox();
        this.positionCodeTypeLabel = new JLabel();
        this.positionCodeTypeComboBox = new JComboBox();
        this.codeTypeScrollModeLabel = new JLabel();
        this.hexCharactersModeLabel = new JLabel();
        this.codeTypeComboBox = new JComboBox();
        this.maxBytesPerRowLabel = new JLabel();
        this.maxBytesPerRowSpinner = new JSpinner();
        this.minRowPositionLengthLabel = new JLabel();
        this.minRowPositionLengthSpinner = new JSpinner();
        this.maxRowPositionLengthLabel = new JLabel();
        this.maxRowPositionLengthSpinner = new JSpinner();
        this.rowWrappingModeCheckBox = new JCheckBox();
        this.showNonprintableCharactersCheckBox.setText(this.resourceBundle.getString("showNonprintableCharactersCheckBox.text"));
        this.viewModeScrollModeLabel.setText(this.resourceBundle.getString("viewModeScrollModeLabel.text"));
        this.codeColorizationCheckBox.setText(this.resourceBundle.getString("codeColorizationCheckBox.text"));
        this.positionCodeTypeLabel.setText(this.resourceBundle.getString("positionCodeTypeLabel.text"));
        this.codeTypeScrollModeLabel.setText(this.resourceBundle.getString("codeTypeScrollModeLabel.text"));
        this.hexCharactersModeLabel.setText(this.resourceBundle.getString("hexCharactersModeLabel.text"));
        this.maxBytesPerRowLabel.setText(this.resourceBundle.getString("maxBytesPerRowLabel.text"));
        this.maxBytesPerRowSpinner.setModel(new SpinnerNumberModel((Number)16, Integer.valueOf(0), null, (Number)1));
        this.minRowPositionLengthLabel.setText(this.resourceBundle.getString("minRowPositionLengthLabel.text"));
        this.minRowPositionLengthSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.minRowPositionLengthSpinner.setValue(8);
        this.maxRowPositionLengthLabel.setText(this.resourceBundle.getString("maxRowPositionLengthLabel.text"));
        this.maxRowPositionLengthSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.maxRowPositionLengthSpinner.setValue(8);
        this.rowWrappingModeCheckBox.setText(this.resourceBundle.getString("wrapLineModeCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.codeCharactersModeComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.positionCodeTypeComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.viewModeComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.codeTypeComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.codeColorizationCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.showNonprintableCharactersCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.maxBytesPerRowSpinner, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent(this.minRowPositionLengthSpinner, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent(this.maxRowPositionLengthSpinner, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hexCharactersModeLabel).addComponent(this.positionCodeTypeLabel).addComponent(this.viewModeScrollModeLabel).addComponent(this.codeTypeScrollModeLabel).addComponent(this.rowWrappingModeCheckBox).addComponent(this.maxBytesPerRowLabel).addComponent(this.minRowPositionLengthLabel).addComponent(this.maxRowPositionLengthLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.viewModeScrollModeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.viewModeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeTypeScrollModeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.positionCodeTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.positionCodeTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hexCharactersModeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeCharactersModeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showNonprintableCharactersCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeColorizationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowWrappingModeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxBytesPerRowLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxBytesPerRowSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minRowPositionLengthLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minRowPositionLengthSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxRowPositionLengthLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxRowPositionLengthSpinner, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CodeAreaOptionsPanel());
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
    }
}

