/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.service.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.editor.text.TextEncodingStatusApi;
import org.exbin.framework.editor.text.preferences.TextEncodingPreferences;
import org.exbin.framework.editor.text.service.TextEncodingService;

@ParametersAreNonnullByDefault
public class TextEncodingServiceImpl
implements TextEncodingService {
    private List<String> encodings = new ArrayList<String>();
    private String selectedEncoding = "UTF-8";
    private TextEncodingStatusApi textEncodingStatus = null;
    private TextEncodingService.EncodingChangeListener encodingChangeListener = null;

    @Override
    @Nonnull
    public List<String> getEncodings() {
        return this.encodings;
    }

    @Override
    public void setEncodings(List<String> encodings) {
        this.encodings = encodings;
        if (this.encodingChangeListener != null) {
            this.encodingChangeListener.encodingListChanged();
        }
    }

    @Override
    @Nonnull
    public String getSelectedEncoding() {
        return this.selectedEncoding;
    }

    @Override
    public void setSelectedEncoding(String encoding) {
        this.selectedEncoding = encoding;
        if (this.textEncodingStatus != null) {
            this.textEncodingStatus.setEncoding(encoding);
        }
        if (this.encodingChangeListener != null) {
            this.encodingChangeListener.selectedEncodingChanged();
        }
    }

    @Override
    public void setTextEncodingStatus(TextEncodingStatusApi textEncodingStatus) {
        this.textEncodingStatus = textEncodingStatus;
        textEncodingStatus.setEncoding(this.selectedEncoding);
    }

    @Override
    public void loadFromPreferences(TextEncodingPreferences preferences) {
        this.selectedEncoding = preferences.getSelectedEncoding();
        this.encodings.clear();
        this.encodings.addAll(preferences.getEncodings());
        if (this.encodingChangeListener != null) {
            this.encodingChangeListener.selectedEncodingChanged();
            this.encodingChangeListener.encodingListChanged();
        }
    }

    @Override
    public void setEncodingChangeListener(TextEncodingService.EncodingChangeListener listener) {
        this.encodingChangeListener = listener;
    }
}

