/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.preferences;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.editor.text.options.TextFontOptions;

@ParametersAreNonnullByDefault
public class TextFontPreferences
implements TextFontOptions {
    public static final String PREFERENCES_TEXT_FONT_PREFIX = "textFont.";
    public static final String PREFERENCES_TEXT_FONT_DEFAULT = "textFont.default";
    public static final String PREFERENCES_TEXT_FONT_FAMILY = "textFont.family";
    public static final String PREFERENCES_TEXT_FONT_SIZE = "textFont.size";
    public static final String PREFERENCES_TEXT_FONT_UNDERLINE = "textFont.underline";
    public static final String PREFERENCES_TEXT_FONT_STRIKETHROUGH = "textFont.strikethrough";
    public static final String PREFERENCES_TEXT_FONT_STRONG = "textFont.strong";
    public static final String PREFERENCES_TEXT_FONT_ITALIC = "textFont.italic";
    public static final String PREFERENCES_TEXT_FONT_SUBSCRIPT = "textFont.subscript";
    public static final String PREFERENCES_TEXT_FONT_SUPERSCRIPT = "textFont.superscript";
    private final Preferences preferences;

    public TextFontPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public boolean isUseDefaultFont() {
        return this.preferences.getBoolean(PREFERENCES_TEXT_FONT_DEFAULT, true);
    }

    @Override
    public void setUseDefaultFont(boolean defaultFont) {
        this.preferences.putBoolean(PREFERENCES_TEXT_FONT_DEFAULT, defaultFont);
    }

    @Override
    @Nonnull
    public Font getFont(Font initialFont) {
        Map<TextAttribute, Object> attribs = this.getFontAttributes();
        Font font = initialFont.deriveFont(attribs);
        return font;
    }

    @Nonnull
    public Map<TextAttribute, Object> getFontAttributes() {
        Optional fontSize;
        HashMap<TextAttribute, Object> attribs = new HashMap<TextAttribute, Object>();
        Optional fontFamily = this.preferences.get(PREFERENCES_TEXT_FONT_FAMILY);
        if (fontFamily.isPresent()) {
            attribs.put(TextAttribute.FAMILY, fontFamily.get());
        }
        if ((fontSize = this.preferences.get(PREFERENCES_TEXT_FONT_SIZE)).isPresent()) {
            attribs.put(TextAttribute.SIZE, Float.valueOf(Integer.valueOf((String)fontSize.get()).floatValue()));
        }
        if (this.preferences.getBoolean(PREFERENCES_TEXT_FONT_UNDERLINE, false)) {
            attribs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        }
        if (this.preferences.getBoolean(PREFERENCES_TEXT_FONT_STRIKETHROUGH, false)) {
            attribs.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if (this.preferences.getBoolean(PREFERENCES_TEXT_FONT_STRONG, false)) {
            attribs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (this.preferences.getBoolean(PREFERENCES_TEXT_FONT_ITALIC, false)) {
            attribs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (this.preferences.getBoolean(PREFERENCES_TEXT_FONT_SUBSCRIPT, false)) {
            attribs.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
        }
        if (this.preferences.getBoolean(PREFERENCES_TEXT_FONT_SUPERSCRIPT, false)) {
            attribs.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
        }
        return attribs;
    }

    public void setFont(Font font) {
        if (font != null) {
            Map<TextAttribute, ?> attribs = font.getAttributes();
            this.setFontAttributes(attribs);
        } else {
            this.preferences.remove(PREFERENCES_TEXT_FONT_FAMILY);
            this.preferences.remove(PREFERENCES_TEXT_FONT_SIZE);
            this.preferences.remove(PREFERENCES_TEXT_FONT_UNDERLINE);
            this.preferences.remove(PREFERENCES_TEXT_FONT_STRIKETHROUGH);
            this.preferences.remove(PREFERENCES_TEXT_FONT_STRONG);
            this.preferences.remove(PREFERENCES_TEXT_FONT_ITALIC);
            this.preferences.remove(PREFERENCES_TEXT_FONT_SUBSCRIPT);
            this.preferences.remove(PREFERENCES_TEXT_FONT_SUPERSCRIPT);
        }
    }

    @Override
    public void setFontAttributes(Map<TextAttribute, ?> attribs) {
        String value = (String)attribs.get(TextAttribute.FAMILY);
        if (value != null) {
            this.preferences.put(PREFERENCES_TEXT_FONT_FAMILY, value);
        } else {
            this.preferences.remove(PREFERENCES_TEXT_FONT_FAMILY);
        }
        Float fontSize = (Float)attribs.get(TextAttribute.SIZE);
        if (fontSize != null) {
            this.preferences.put(PREFERENCES_TEXT_FONT_SIZE, Integer.toString((int)fontSize.floatValue()));
        } else {
            this.preferences.remove(PREFERENCES_TEXT_FONT_SIZE);
        }
        this.preferences.putBoolean(PREFERENCES_TEXT_FONT_UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL.equals(attribs.get(TextAttribute.UNDERLINE)));
        this.preferences.putBoolean(PREFERENCES_TEXT_FONT_STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON.equals(attribs.get(TextAttribute.STRIKETHROUGH)));
        this.preferences.putBoolean(PREFERENCES_TEXT_FONT_STRONG, TextAttribute.WEIGHT_BOLD.equals(attribs.get(TextAttribute.WEIGHT)));
        this.preferences.putBoolean(PREFERENCES_TEXT_FONT_ITALIC, TextAttribute.POSTURE_OBLIQUE.equals(attribs.get(TextAttribute.POSTURE)));
        this.preferences.putBoolean(PREFERENCES_TEXT_FONT_SUBSCRIPT, TextAttribute.SUPERSCRIPT_SUB.equals(attribs.get(TextAttribute.SUPERSCRIPT)));
        this.preferences.putBoolean(PREFERENCES_TEXT_FONT_SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER.equals(attribs.get(TextAttribute.SUPERSCRIPT)));
    }
}

