/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.options.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.editor.text.options.impl.TextFontOptionsImpl;
import org.exbin.framework.editor.text.service.TextFontService;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class TextFontOptionsPanel
extends JPanel
implements OptionsComponent<TextFontOptionsImpl> {
    private OptionsModifiedListener optionsModifiedListener;
    private FontChangeAction fontChangeAction;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(TextFontOptionsPanel.class);
    private TextFontService textFontService;
    private Font codeFont;
    private JButton changeFontButton;
    private JColorChooser colorChooser;
    private JCheckBox defaultFontCheckBox;
    private JButton fillCurrentFontButton;
    private JButton fillDefaultFontButton;
    private JLabel fontPreviewLabel;
    private JTextField fontTextField;

    public TextFontOptionsPanel() {
        this.initComponents();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setTextFontService(TextFontService textFontService) {
        this.textFontService = textFontService;
    }

    public void saveToOptions(TextFontOptionsImpl options) {
        options.setUseDefaultFont(this.defaultFontCheckBox.isSelected());
        options.setFontAttributes(this.codeFont != null ? this.codeFont.getAttributes() : null);
    }

    public void loadFromOptions(TextFontOptionsImpl options) {
        boolean useDefaultFont = options.isUseDefaultFont();
        this.defaultFontCheckBox.setSelected(useDefaultFont);
        this.setEnabled(!useDefaultFont);
        this.codeFont = this.textFontService == null ? options.getFont(new Font("Monospaced", 0, 12)) : this.textFontService.getDefaultFont().deriveFont(options.getFontAttributes());
        this.updateFontFields();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fontPreviewLabel.setEnabled(enabled);
        this.fillDefaultFontButton.setEnabled(enabled && this.textFontService != null);
        this.fillCurrentFontButton.setEnabled(enabled && this.textFontService != null);
        this.changeFontButton.setEnabled(enabled);
    }

    private void initComponents() {
        this.colorChooser = new JColorChooser();
        this.defaultFontCheckBox = new JCheckBox();
        this.fillDefaultFontButton = new JButton();
        this.changeFontButton = new JButton();
        this.fontPreviewLabel = new JLabel();
        this.fillCurrentFontButton = new JButton();
        this.fontTextField = new JTextField();
        this.colorChooser.setName("colorChooser");
        this.setName("Form");
        this.defaultFontCheckBox.setSelected(true);
        this.defaultFontCheckBox.setText(this.resourceBundle.getString("defaultFontCheckBox.text"));
        this.defaultFontCheckBox.setName("defaultFontCheckBox");
        this.defaultFontCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TextFontOptionsPanel.this.defaultFontCheckBoxItemStateChanged(evt);
            }
        });
        this.fillDefaultFontButton.setText(this.resourceBundle.getString("fillDefaultFontButton.text"));
        this.fillDefaultFontButton.setEnabled(false);
        this.fillDefaultFontButton.setName("fillDefaultFontButton");
        this.fillDefaultFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextFontOptionsPanel.this.fillDefaultFontButtonActionPerformed(evt);
            }
        });
        this.changeFontButton.setText(this.resourceBundle.getString("changeFontButton.text"));
        this.changeFontButton.setEnabled(false);
        this.changeFontButton.setName("changeFontButton");
        this.changeFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextFontOptionsPanel.this.changeFontButtonActionPerformed(evt);
            }
        });
        this.fontPreviewLabel.setBackground(Color.white);
        this.fontPreviewLabel.setHorizontalAlignment(0);
        this.fontPreviewLabel.setText(this.resourceBundle.getString("fontPreviewLabel.text"));
        this.fontPreviewLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.fontPreviewLabel.setEnabled(false);
        this.fontPreviewLabel.setName("fontPreviewLabel");
        this.fontPreviewLabel.setOpaque(true);
        this.fillCurrentFontButton.setText(this.resourceBundle.getString("fillCurrentFontButton.text"));
        this.fillCurrentFontButton.setEnabled(false);
        this.fillCurrentFontButton.setName("fillCurrentFontButton");
        this.fillCurrentFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextFontOptionsPanel.this.fillCurrentFontButtonActionPerformed(evt);
            }
        });
        this.fontTextField.setEditable(false);
        this.fontTextField.setName("fontTextField");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fontPreviewLabel, -1, -1, Short.MAX_VALUE).addComponent(this.fontTextField, GroupLayout.Alignment.LEADING).addComponent(this.defaultFontCheckBox, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.changeFontButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fillDefaultFontButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fillCurrentFontButton).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.defaultFontCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fontTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fontPreviewLabel, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.changeFontButton).addComponent(this.fillDefaultFontButton).addComponent(this.fillCurrentFontButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void defaultFontCheckBoxItemStateChanged(ItemEvent evt) {
        boolean selected = evt.getStateChange() != 1;
        this.fontPreviewLabel.setEnabled(selected);
        this.fillDefaultFontButton.setEnabled(selected);
        this.fillCurrentFontButton.setEnabled(selected);
        this.changeFontButton.setEnabled(selected);
        this.setModified(true);
    }

    private void fillDefaultFontButtonActionPerformed(ActionEvent evt) {
        this.codeFont = this.textFontService.getDefaultFont();
        this.updateFontFields();
        this.setModified(true);
    }

    private void changeFontButtonActionPerformed(ActionEvent evt) {
        Font resultFont;
        if (this.fontChangeAction != null && (resultFont = this.fontChangeAction.changeFont(this.fontPreviewLabel.getFont())) != null) {
            this.codeFont = resultFont;
            this.updateFontFields();
            this.setModified(true);
        }
    }

    private void fillCurrentFontButtonActionPerformed(ActionEvent evt) {
        this.codeFont = this.textFontService.getCurrentFont();
        this.updateFontFields();
        this.setModified(true);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new TextFontOptionsPanel());
    }

    private void updateFontFields() {
        int fontStyle = this.codeFont.getStyle();
        String fontStyleName = (fontStyle & 3) == 3 ? "Bold Italic" : ((fontStyle & 1) > 0 ? "Bold" : ((fontStyle & 2) > 0 ? "Italic" : "Plain"));
        this.fontTextField.setText(this.codeFont.getFamily() + " " + String.valueOf(this.codeFont.getSize()) + " " + fontStyleName);
        this.fontPreviewLabel.setFont(this.codeFont);
    }

    private void setModified(boolean b) {
        if (this.optionsModifiedListener != null) {
            this.optionsModifiedListener.wasModified();
        }
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
        this.optionsModifiedListener = listener;
    }

    public void setFontChangeAction(FontChangeAction fontChangeAction) {
        this.fontChangeAction = fontChangeAction;
    }

    @ParametersAreNonnullByDefault
    public static interface FontChangeAction {
        @Nullable
        public Font changeFont(Font var1);
    }
}

