/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.gui;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.Document;
import org.exbin.framework.editor.text.TextEditor;
import org.exbin.framework.editor.text.gui.TextPanel;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

public class TextPropertiesPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(TextPropertiesPanel.class);
    private JLabel charCountLabel;
    private JTextField charCountTextField;
    private JPanel documentSizePanel;
    private JLabel fileNameLabel;
    private JTextField fileNameTextField;
    private JLabel fileSizeLabel;
    private JTextField fileSizeTextField;
    private JLabel linesCountLabel;
    private JTextField linesCountTextField;
    private JLabel wordsCountLabel;
    private JTextField wordsCountTextField;

    public TextPropertiesPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.fileNameLabel = new JLabel();
        this.fileNameTextField = new JTextField();
        this.documentSizePanel = new JPanel();
        this.linesCountLabel = new JLabel();
        this.linesCountTextField = new JTextField();
        this.charCountLabel = new JLabel();
        this.charCountTextField = new JTextField();
        this.fileSizeLabel = new JLabel();
        this.fileSizeTextField = new JTextField();
        this.wordsCountLabel = new JLabel();
        this.wordsCountTextField = new JTextField();
        this.fileNameLabel.setText(this.resourceBundle.getString("fileNameLabel.text"));
        this.fileNameTextField.setEditable(false);
        this.documentSizePanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("documentSizePanel.border.title")));
        this.linesCountLabel.setText(this.resourceBundle.getString("linesCountLabel.text"));
        this.linesCountTextField.setEditable(false);
        this.charCountLabel.setText(this.resourceBundle.getString("charCountLabel.text"));
        this.charCountTextField.setEditable(false);
        this.fileSizeLabel.setText(this.resourceBundle.getString("fileSizeLabel.text"));
        this.fileSizeTextField.setEditable(false);
        this.wordsCountLabel.setText(this.resourceBundle.getString("wordsCountLabel.text"));
        this.wordsCountTextField.setEditable(false);
        GroupLayout documentSizePanelLayout = new GroupLayout(this.documentSizePanel);
        this.documentSizePanel.setLayout(documentSizePanelLayout);
        documentSizePanelLayout.setHorizontalGroup(documentSizePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(documentSizePanelLayout.createSequentialGroup().addContainerGap().addGroup(documentSizePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.linesCountLabel).addComponent(this.charCountLabel).addComponent(this.fileSizeLabel).addComponent(this.wordsCountLabel).addComponent(this.charCountTextField).addComponent(this.fileSizeTextField).addComponent(this.wordsCountTextField, GroupLayout.Alignment.TRAILING).addComponent(this.linesCountTextField)).addContainerGap()));
        documentSizePanelLayout.setVerticalGroup(documentSizePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(documentSizePanelLayout.createSequentialGroup().addComponent(this.linesCountLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.linesCountTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.charCountLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.charCountTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileSizeTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wordsCountLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wordsCountTextField, -2, -1, -2).addContainerGap(15, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.documentSizePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.fileNameLabel, GroupLayout.Alignment.LEADING).addComponent(this.fileNameTextField, GroupLayout.Alignment.LEADING, -1, 388, Short.MAX_VALUE)).addContainerGap())));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 305, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.fileNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileNameTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.documentSizePanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE))));
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new TextPropertiesPanel());
    }

    public void setDocument(TextEditor textEditor) {
        Optional<FileHandler> activeFile = textEditor.getActiveFile();
        if (!activeFile.isPresent()) {
            throw new IllegalStateException();
        }
        FileHandler fileHandler = activeFile.get();
        Optional fileUri = fileHandler.getFileUri();
        this.fileNameTextField.setText(fileUri.isPresent() ? ((URI)fileUri.get()).toString() : "");
        TextPanel textPanel = (TextPanel)fileHandler.getComponent();
        Document document = textPanel.getDocument();
        this.linesCountTextField.setText(Integer.toString(textPanel.getLineCount()));
        this.charCountTextField.setText(Integer.toString(document.getLength()));
        CharBuffer buffer = CharBuffer.wrap(new StringBuffer(textPanel.getText()));
        try {
            CharsetEncoder encoder = Charset.defaultCharset().newEncoder();
            ByteBuffer result = encoder.encode(buffer);
            int length = 0;
            while (result.hasRemaining()) {
                result.get();
                ++length;
            }
            this.fileSizeTextField.setText(Integer.toString(length));
        }
        catch (UnsupportedOperationException | CharacterCodingException ex) {
            Logger.getLogger(TextPropertiesPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }
}

