/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.audio.swing.renderer;

import java.awt.Graphics;
import org.exbin.xbup.audio.swing.XBWavePanel;
import org.exbin.xbup.audio.swing.renderer.DefaultRenderer;
import org.exbin.xbup.audio.swing.renderer.XBWavePanelRenderer;
import org.exbin.xbup.audio.wave.XBWave;

public class LineRenderer
extends DefaultRenderer {
    @Override
    public void paint(Graphics g, XBWavePanel panel, int begin, int end, XBWavePanelRenderer.RenderType renderType) {
        super.paint(g, panel, begin, end, renderType);
        LineRecord lineRecord = new LineRecord();
        XBWave wave = panel.getWave();
        int stopPos = end;
        if (wave != null) {
            g.setColor(panel.getWaveColor());
            int channelsCount = wave.getAudioFormat().getChannels();
            int[] prevMin = new int[]{-1, -1};
            int[] prevMax = new int[]{-1, -1};
            if ((double)stopPos >= (double)(panel.getWaveLength() - panel.getWindowPosition()) * panel.getScaleRatio()) {
                stopPos = (int)((double)(panel.getWaveLength() - panel.getWindowPosition()) * panel.getScaleRatio()) - 1;
            }
            for (int pos = begin - 1; pos < stopPos; ++pos) {
                for (int channel = 0; channel < channelsCount; ++channel) {
                    int value;
                    int pomPos = pos;
                    if (pomPos < 0) {
                        pomPos = 0;
                    }
                    int linePosition = panel.getWindowPosition() + (int)((double)pomPos / panel.getScaleRatio());
                    lineRecord.min = value = wave.getRatioValue(linePosition, channel, panel.getHeight() / channelsCount) + channel * panel.getHeight() / channelsCount;
                    lineRecord.max = value;
                    if (panel.getScaleRatio() < 1.0) {
                        int lineEndPosition = panel.getWindowPosition() + (int)((double)(pomPos + 1) / panel.getScaleRatio());
                        for (int inLinePosition = linePosition + 1; inLinePosition < lineEndPosition; ++inLinePosition) {
                            int inValue = wave.getRatioValue(inLinePosition, channel, panel.getHeight() / channelsCount) + channel * panel.getHeight() / channelsCount;
                            if (inValue < lineRecord.min) {
                                lineRecord.min = inValue;
                            }
                            if (inValue <= lineRecord.max) continue;
                            lineRecord.max = inValue;
                        }
                    }
                    if (panel.getScaleRatio() < 1.0) {
                        if (prevMax[channel] >= 0) {
                            g.drawLine(pos - 1, prevMax[channel], pos, lineRecord.max);
                            g.drawLine(pos - 1, prevMin[channel], pos, lineRecord.min);
                        }
                        prevMax[channel] = lineRecord.max;
                        prevMin[channel] = lineRecord.min;
                        continue;
                    }
                    if (prevMax[channel] >= 0) {
                        g.drawLine(pos - 1, prevMax[channel], pos, value);
                    }
                    prevMax[channel] = value;
                }
            }
        }
    }

    private class LineRecord {
        int min;
        int max;

        private LineRecord() {
        }
    }
}

