/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.operation.swing.command;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.operation.BinaryDataOperationException;
import org.exbin.bined.operation.BinaryDataOperationListener;
import org.exbin.bined.operation.swing.CodeAreaOperation;
import org.exbin.bined.operation.swing.CodeAreaOperationEvent;
import org.exbin.bined.operation.swing.CodeAreaOperationListener;
import org.exbin.bined.operation.swing.command.CodeAreaCommand;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public abstract class OpCodeAreaCommand
extends CodeAreaCommand {
    @Nullable
    protected CodeAreaOperation operation;
    protected boolean operationPerformed = false;

    public OpCodeAreaCommand(CodeAreaCore codeArea) {
        super(codeArea);
    }

    @Nullable
    public CodeAreaOperation getOperation() {
        return this.operation;
    }

    public void setOperation(CodeAreaOperation operation) {
        if (this.operation != null) {
            try {
                this.operation.dispose();
            }
            catch (Exception ex) {
                Logger.getLogger(OpCodeAreaCommand.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.operation = operation;
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() throws BinaryDataOperationException {
        CodeAreaOperation redoOperation;
        if (this.operationPerformed) {
            redoOperation = ((CodeAreaOperation)CodeAreaUtils.requireNonNull((Object)this.operation)).executeWithUndo();
            this.operation.dispose();
            if (this.codeArea instanceof BinaryDataOperationListener) {
                ((CodeAreaOperationListener)this.codeArea).notifyChange(new CodeAreaOperationEvent(this.operation));
            }
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.operation = redoOperation;
        this.operationPerformed = false;
    }

    public void redo() throws BinaryDataOperationException {
        CodeAreaOperation undoOperation;
        if (!this.operationPerformed) {
            undoOperation = ((CodeAreaOperation)CodeAreaUtils.requireNonNull((Object)this.operation)).executeWithUndo();
            this.operation.dispose();
            if (this.codeArea instanceof BinaryDataOperationListener) {
                ((CodeAreaOperationListener)this.codeArea).notifyChange(new CodeAreaOperationEvent(this.operation));
            }
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.operation = undoOperation;
        this.operationPerformed = true;
    }

    public void dispose() throws BinaryDataOperationException {
        super.dispose();
        if (this.operation != null) {
            this.operation.dispose();
        }
    }
}

