/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.operation.swing;

import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.capability.CaretCapable;
import org.exbin.bined.capability.CharsetCapable;
import org.exbin.bined.capability.SelectionCapable;
import org.exbin.bined.operation.swing.CharEditDataOperation;
import org.exbin.bined.operation.swing.CodeAreaOperation;
import org.exbin.bined.operation.swing.CodeAreaOperationType;
import org.exbin.bined.operation.swing.RemoveDataOperation;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public class InsertCharEditDataOperation
extends CharEditDataOperation {
    private final long startPosition;
    private long length;

    public InsertCharEditDataOperation(CodeAreaCore coreArea, long startPosition) {
        super(coreArea);
        this.startPosition = startPosition;
    }

    @Override
    @Nonnull
    public CodeAreaOperationType getType() {
        return CodeAreaOperationType.EDIT_DATA;
    }

    @Override
    @Nullable
    protected CodeAreaOperation execute(CodeAreaOperation.ExecutionType executionType) {
        throw new IllegalStateException("Cannot be executed");
    }

    @Override
    public void appendEdit(char value) {
        EditableBinaryData data = (EditableBinaryData)this.codeArea.getContentData();
        long editedDataPosition = this.startPosition + this.length;
        Charset charset = ((CharsetCapable)this.codeArea).getCharset();
        byte[] bytes = CodeAreaUtils.characterToBytes((char)value, (Charset)charset);
        data.insert(editedDataPosition, bytes);
        this.length += (long)bytes.length;
        long dataPosition = this.startPosition + this.length;
        ((CaretCapable)this.codeArea).setCaretPosition(dataPosition);
        ((SelectionCapable)this.codeArea).setSelection(dataPosition, dataPosition);
    }

    @Override
    @Nonnull
    public CodeAreaOperation[] generateUndo() {
        return new CodeAreaOperation[]{new RemoveDataOperation(this.codeArea, this.startPosition, 0, this.length)};
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public long getLength() {
        return this.length;
    }
}

