/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.gui.GeneralPropertiesPanel;
import org.exbin.framework.editor.xbup.gui.SimpleMessagePanel;
import org.exbin.framework.editor.xbup.viewer.BlockViewer;
import org.exbin.framework.editor.xbup.viewer.gui.DocumentViewerPanel;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class PropertiesViewer
implements BlockViewer {
    private final JPanel panel = new JPanel();
    private final DocumentViewerPanel viewerPanel = new DocumentViewerPanel();
    private final GeneralPropertiesPanel generalPanel = new GeneralPropertiesPanel();
    private XBACatalog catalog;

    public PropertiesViewer() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.viewerPanel, "Center");
        SimpleMessagePanel messagePanel = new SimpleMessagePanel();
        this.viewerPanel.setBorderComponent(messagePanel);
    }

    @Override
    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.generalPanel.setCatalog(catalog);
    }

    @Override
    public void setApplication(XBApplication application) {
        this.generalPanel.setApplication(application);
    }

    @Override
    public void setPluginRepository(XBPluginRepository pluginRepository) {
    }

    public void setDevMode(boolean devMode) {
        this.generalPanel.setDevMode(devMode);
    }

    @Override
    @Nonnull
    public String getName() {
        return "Properties";
    }

    @Override
    @Nonnull
    public Optional<ImageIcon> getIcon() {
        return Optional.of(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/tooloptions.png")));
    }

    @Override
    public void setBlock(@Nullable XBTBlock block) {
        this.viewerPanel.removeAllViews();
        if (block != null) {
            this.viewerPanel.addView("General", this.generalPanel);
            this.viewerPanel.viewsAdded();
            this.generalPanel.setBlock(block);
        }
        this.viewerPanel.revalidate();
        this.viewerPanel.repaint();
    }

    @Override
    @Nonnull
    public JComponent getComponent() {
        return this.panel;
    }
}

