/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.table.AbstractTableModel;
import org.exbin.framework.editor.xbup.gui.XBPropertyTableItem;
import org.exbin.framework.editor.xbup.gui.XBPropertyTablePanel;
import org.exbin.framework.utils.LanguageUtils;

@ParametersAreNonnullByDefault
public class XBPropertyTableModel
extends AbstractTableModel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(XBPropertyTablePanel.class);
    private List<XBPropertyTableItem> parameters;
    private final String[] columnNames;
    private Class[] columnTypes = new Class[]{String.class, Object.class};
    private final boolean[] columnsEditable = new boolean[]{false, true};

    public XBPropertyTableModel() {
        this.columnNames = new String[]{"Property", "Value"};
        this.parameters = new ArrayList<XBPropertyTableItem>();
    }

    @Override
    public int getRowCount() {
        return this.parameters.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    @Nonnull
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    @Nonnull
    public Class<?> getColumnClass(int columnIndex) {
        return this.getTypes()[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columnsEditable[columnIndex];
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getRow(rowIndex).getValueName();
            }
            case 1: {
                return null;
            }
        }
        return "";
    }

    public XBPropertyTableItem getRow(int rowIndex) {
        return this.parameters.get(rowIndex);
    }

    public void removeRow(int rowIndex) {
        this.parameters.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    public void addRow(XBPropertyTableItem rowData) {
        this.parameters.add(rowData);
        this.fireTableRowsInserted(this.parameters.size() - 1, this.parameters.size() - 1);
    }

    @Nonnull
    public List<XBPropertyTableItem> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<XBPropertyTableItem> attributes) {
        this.parameters = attributes;
    }

    @Nonnull
    public Class[] getTypes() {
        return this.columnTypes;
    }

    public void setTypes(Class[] types) {
        this.columnTypes = types;
    }
}

