/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.def.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActionsUpdateListener;
import org.exbin.framework.component.gui.ToolBarSidePanel;
import org.exbin.framework.editor.xbup.def.model.BlocksTableModel;
import org.exbin.framework.editor.xbup.gui.BlocksTableItem;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.catalog.XBACatalog;

@ParametersAreNonnullByDefault
public class BlocksPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BlocksPanel.class);
    private BlocksTableModel blocksTableModel = new BlocksTableModel();
    private XBApplication application;
    private final ToolBarSidePanel toolBarPanel = new ToolBarSidePanel();
    private JScrollPane blocksScrollPane;
    private JTable blocksTable;

    public BlocksPanel() {
        this.initComponents();
        this.toolBarPanel.setToolBarPosition(ToolBarSidePanel.ToolBarPosition.RIGHT);
        this.toolBarPanel.add((Component)this.blocksScrollPane, (Object)"Center");
        this.add((Component)this.toolBarPanel, "Center");
    }

    public void setBlocksTableModel(BlocksTableModel blocksTableModel) {
        this.blocksTableModel = blocksTableModel;
        this.blocksTable.setModel(blocksTableModel);
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    @Nonnull
    public JTable getBlocksTable() {
        return this.blocksTable;
    }

    private void initComponents() {
        this.blocksScrollPane = new JScrollPane();
        this.blocksTable = new JTable(this.blocksTableModel){

            @Override
            public boolean editCellAt(int row, int column, EventObject e) {
                boolean result = super.editCellAt(row, column, e);
                final Component editor = this.getEditorComponent();
                if (editor == null || !(editor instanceof JTextComponent)) {
                    return result;
                }
                if (e instanceof MouseEvent) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((JTextComponent)editor).selectAll();
                        }
                    });
                } else {
                    ((JTextComponent)editor).selectAll();
                }
                return result;
            }
        };
        this.blocksTable.setModel(this.blocksTableModel);
        this.blocksTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BlocksPanel.this.blocksTablePropertyChange(evt);
            }
        });
        this.blocksScrollPane.setViewportView(this.blocksTable);
        this.setLayout(new BorderLayout());
    }

    private void blocksTablePropertyChange(PropertyChangeEvent evt) {
        this.blocksTable.repaint();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new BlocksPanel());
    }

    public void setCatalog(XBACatalog catalog) {
    }

    public void addActions(ActionsProvider actionsProvider) {
        this.toolBarPanel.addActions(actionsProvider);
    }

    public void setPanelPopup(JPopupMenu popupMenu) {
        this.blocksTable.setComponentPopupMenu(popupMenu);
    }

    public void addSelectionListener(EditItemActionsUpdateListener updateListener) {
        this.blocksTable.getSelectionModel().addListSelectionListener(e -> updateListener.stateChanged());
    }

    @Nullable
    public BlocksTableItem getSelectedRow() {
        int selectedRow = this.blocksTable.getSelectedRow();
        if (selectedRow >= 0) {
            return this.blocksTableModel.getRow(selectedRow);
        }
        return null;
    }
}

