/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.def.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.catalog.XBACatalog;

@ParametersAreNonnullByDefault
public class BlockEditorPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BlockEditorPanel.class);
    private XBApplication application;
    private List<Tab> tabs = new ArrayList<Tab>();
    private JTabbedPane tabbedPane;

    public BlockEditorPanel() {
        this.initComponents();
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new BlockEditorPanel());
    }

    public void setCatalog(XBACatalog catalog) {
    }

    public void addTab(Tab tab) {
        this.tabs.add(tab);
        this.tabbedPane.add(tab.tabName, tab.component);
    }

    public void addTab(String tabName, JComponent component) {
        this.tabs.add(new Tab(tabName, component));
        this.tabbedPane.add(tabName, component);
    }

    @ParametersAreNonnullByDefault
    public static class Tab {
        private String tabName;
        private JComponent component;

        public Tab(String tabName, JComponent component) {
            this.tabName = tabName;
            this.component = component;
        }
    }
}

