/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.operation.BinaryDataCommand;
import org.exbin.bined.operation.BinaryDataOperationException;
import org.exbin.bined.operation.undo.BinaryDataUndoHandler;
import org.exbin.bined.operation.undo.BinaryDataUndoUpdateListener;
import org.exbin.xbup.operation.Command;
import org.exbin.xbup.operation.undo.XBUndoHandler;
import org.exbin.xbup.operation.undo.XBUndoUpdateListener;

@ParametersAreNonnullByDefault
public class BinaryDataWrapperUndoHandler
implements BinaryDataUndoHandler {
    private final XBUndoHandler undoHandler;
    private final List<BinaryDataUndoUpdateListener> listeners = new ArrayList<BinaryDataUndoUpdateListener>();

    public BinaryDataWrapperUndoHandler(XBUndoHandler undoHandler) {
        this.undoHandler = undoHandler;
        undoHandler.addUndoUpdateListener(new XBUndoUpdateListener(){

            public void undoCommandPositionChanged() {
                for (BinaryDataUndoUpdateListener listener : BinaryDataWrapperUndoHandler.this.listeners) {
                    listener.undoCommandPositionChanged();
                }
            }

            public void undoCommandAdded(Command command) {
                if (command instanceof BinaryDataCommandWrapper) {
                    for (BinaryDataUndoUpdateListener listener : BinaryDataWrapperUndoHandler.this.listeners) {
                        listener.undoCommandAdded(((BinaryDataCommandWrapper)command).binaryDataCommand);
                    }
                }
            }
        });
    }

    public boolean canRedo() {
        return this.undoHandler.canRedo();
    }

    public boolean canUndo() {
        return this.undoHandler.canUndo();
    }

    public void clear() {
        this.undoHandler.clear();
    }

    public void doSync() throws BinaryDataOperationException {
        try {
            this.undoHandler.doSync();
        }
        catch (Exception ex) {
            throw new BinaryDataOperationException((Throwable)ex);
        }
    }

    public void execute(BinaryDataCommand command) throws BinaryDataOperationException {
        try {
            this.undoHandler.execute((Command)new BinaryDataCommandWrapper(command));
        }
        catch (Exception ex) {
            throw new BinaryDataOperationException((Throwable)ex);
        }
    }

    public void addCommand(BinaryDataCommand command) {
        this.undoHandler.addCommand((Command)new BinaryDataCommandWrapper(command));
    }

    public List<BinaryDataCommand> getCommandList() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getCommandPosition() {
        return this.undoHandler.getCommandPosition();
    }

    public long getMaximumUndo() {
        return this.undoHandler.getMaximumUndo();
    }

    public long getSyncPoint() {
        return this.undoHandler.getSyncPoint();
    }

    public long getUndoMaximumSize() {
        return this.undoHandler.getUndoMaximumSize();
    }

    public long getUsedSize() {
        return this.undoHandler.getUsedSize();
    }

    public void performUndo() throws BinaryDataOperationException {
        try {
            this.undoHandler.performUndo();
        }
        catch (Exception ex) {
            throw new BinaryDataOperationException((Throwable)ex);
        }
    }

    public void performUndo(int count) throws BinaryDataOperationException {
        try {
            this.undoHandler.performUndo(count);
        }
        catch (Exception ex) {
            throw new BinaryDataOperationException((Throwable)ex);
        }
    }

    public void performRedo() throws BinaryDataOperationException {
        try {
            this.undoHandler.performRedo();
        }
        catch (Exception ex) {
            throw new BinaryDataOperationException((Throwable)ex);
        }
    }

    public void performRedo(int count) throws BinaryDataOperationException {
        try {
            this.undoHandler.performRedo(count);
        }
        catch (Exception ex) {
            throw new BinaryDataOperationException((Throwable)ex);
        }
    }

    public void setCommandPosition(long targetPosition) throws BinaryDataOperationException {
        try {
            this.undoHandler.setCommandPosition(targetPosition);
        }
        catch (Exception ex) {
            throw new BinaryDataOperationException((Throwable)ex);
        }
    }

    public void setSyncPoint(long syncPoint) {
        this.undoHandler.setSyncPoint(syncPoint);
    }

    public void setSyncPoint() {
        this.undoHandler.setSyncPoint();
    }

    public void addUndoUpdateListener(BinaryDataUndoUpdateListener listener) {
        this.listeners.add(listener);
    }

    public void removeUndoUpdateListener(BinaryDataUndoUpdateListener listener) {
        this.listeners.remove(listener);
    }

    @ParametersAreNonnullByDefault
    private static final class BinaryDataCommandWrapper
    implements Command {
        private final BinaryDataCommand binaryDataCommand;

        public BinaryDataCommandWrapper(BinaryDataCommand binaryDataCommand) {
            this.binaryDataCommand = binaryDataCommand;
        }

        public String getCaption() {
            return this.binaryDataCommand.getCaption();
        }

        public void execute() throws Exception {
            this.binaryDataCommand.execute();
        }

        public void use() {
            this.binaryDataCommand.use();
        }

        public void redo() throws Exception {
            this.binaryDataCommand.redo();
        }

        public void undo() throws Exception {
            this.binaryDataCommand.undo();
        }

        public boolean canUndo() {
            return this.binaryDataCommand.canUndo();
        }

        public void dispose() throws Exception {
            this.binaryDataCommand.dispose();
        }

        public Optional<Date> getExecutionTime() {
            return this.binaryDataCommand.getExecutionTime();
        }
    }
}

