/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.picture.action;

import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.picture.gui.ImagePanel;
import org.exbin.framework.editor.picture.gui.ImageResizePanel;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;

@ParametersAreNonnullByDefault
public class PictureOperationActions {
    public static final String IMAGE_RESIZE_ACTION_ID = "imageResizeAction";
    private EditorProvider editorProvider;
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private Action imageResizeAction;

    public void setup(XBApplication application, EditorProvider editorProvider, ResourceBundle resourceBundle) {
        this.application = application;
        this.editorProvider = editorProvider;
        this.resourceBundle = resourceBundle;
    }

    @Nonnull
    public Action getRevertAction() {
        if (this.imageResizeAction == null) {
            this.imageResizeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Optional activeFile = PictureOperationActions.this.editorProvider.getActiveFile();
                    if (!activeFile.isPresent()) {
                        throw new IllegalStateException();
                    }
                    ImagePanel imagePanel = (ImagePanel)((FileHandler)activeFile.get()).getComponent();
                    ImageResizePanel imageResizePanel = new ImageResizePanel();
                    imageResizePanel.setResolution(imagePanel.getImageSize());
                    DefaultControlPanel controlPanel = new DefaultControlPanel(imageResizePanel.getResourceBundle());
                    FrameModuleApi frameModule = (FrameModuleApi)PictureOperationActions.this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
                    WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)imageResizePanel, (JPanel)controlPanel);
                    WindowUtils.addHeaderPanel((Window)dialog.getWindow(), imageResizePanel.getClass(), (ResourceBundle)imageResizePanel.getResourceBundle());
                    frameModule.setDialogTitle(dialog, imageResizePanel.getResourceBundle());
                    controlPanel.setHandler(actionType -> {
                        if (actionType == DefaultControlHandler.ControlActionType.OK) {
                            Point point = imageResizePanel.getResolution();
                            int width = (int)point.getX();
                            int height = (int)point.getY();
                            imagePanel.performResize(width, height);
                        }
                        dialog.close();
                    });
                    dialog.showCentered((Component)e.getSource());
                    dialog.dispose();
                }
            };
            ActionUtils.setupAction((Action)this.imageResizeAction, (ResourceBundle)this.resourceBundle, (String)IMAGE_RESIZE_ACTION_ID);
            this.imageResizeAction.putValue("dialogMode", true);
        }
        return this.imageResizeAction;
    }
}

