/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.spec.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActionsUpdateListener;
import org.exbin.framework.component.gui.ToolBarSidePanel;
import org.exbin.framework.data.model.CatalogDefsTableItem;
import org.exbin.framework.data.model.CatalogDefsTableModel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.xbup.catalog.item.spec.gui.CatalogDefsDetailTableModel;
import org.exbin.xbup.catalog.entity.XBERev;
import org.exbin.xbup.catalog.entity.XBESpecDef;
import org.exbin.xbup.catalog.entity.service.XBEXDescService;
import org.exbin.xbup.catalog.entity.service.XBEXNameService;
import org.exbin.xbup.catalog.entity.service.XBEXStriService;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCSpecDef;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXStriService;

@ParametersAreNonnullByDefault
public class CatalogItemEditDefinitionPanel
extends JPanel {
    private XBApplication application;
    private XBACatalog catalog;
    private XBCItem catalogItem;
    private XBCSpecService specService;
    private CatalogDefsTableModel defsModel = new CatalogDefsTableModel();
    private final CatalogDefsDetailTableModel detailModel = new CatalogDefsDetailTableModel();
    private List<CatalogDefsTableItem> removeList;
    private List<CatalogDefsTableItem> updateList;
    private final ToolBarSidePanel toolBarPanel = new ToolBarSidePanel();
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogItemEditDefinitionPanel.class);
    private JSplitPane definitionControlSplitPane;
    private JScrollPane itemDefinitionPropertyScrollPanel;
    private JTable itemDefinitionPropertyTable;
    private JScrollPane itemDefinitionsScrollPane;
    private JTable itemDefinitionsTable;

    public CatalogItemEditDefinitionPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.itemDefinitionsTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.detailModel.setItem(this.getSelectedDefinition());
                this.itemDefinitionPropertyTable.repaint();
            }
        });
        this.toolBarPanel.add((Component)this.definitionControlSplitPane, (Object)"Center");
        this.add((Component)this.toolBarPanel, "Center");
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public int getSelectedDefinitionIndex() {
        return this.itemDefinitionsTable.getSelectedRow();
    }

    @Nullable
    public CatalogDefsTableItem getSelectedDefinition() {
        int selectedRow = this.itemDefinitionsTable.getSelectedRow();
        if (selectedRow >= 0) {
            return this.defsModel.getRowItem(selectedRow);
        }
        return null;
    }

    public void addToolbarActions(ActionsProvider actionsProvider) {
        this.toolBarPanel.addActions(actionsProvider);
    }

    public void setDefsModel(CatalogDefsTableModel defsTableModel) {
        this.defsModel = defsTableModel;
        this.itemDefinitionsTable.setModel((TableModel)this.defsModel);
    }

    private void initComponents() {
        this.definitionControlSplitPane = new JSplitPane();
        this.itemDefinitionsScrollPane = new JScrollPane();
        this.itemDefinitionsTable = new JTable();
        this.itemDefinitionPropertyScrollPanel = new JScrollPane();
        this.itemDefinitionPropertyTable = new JTable();
        this.definitionControlSplitPane.setDividerLocation(400);
        this.itemDefinitionsTable.setModel((TableModel)this.defsModel);
        this.itemDefinitionsTable.setSelectionMode(0);
        this.itemDefinitionsScrollPane.setViewportView(this.itemDefinitionsTable);
        this.definitionControlSplitPane.setLeftComponent(this.itemDefinitionsScrollPane);
        this.itemDefinitionPropertyTable.setModel(this.detailModel);
        this.itemDefinitionPropertyScrollPanel.setViewportView(this.itemDefinitionPropertyTable);
        this.definitionControlSplitPane.setRightComponent(this.itemDefinitionPropertyScrollPanel);
        this.setToolTipText(this.resourceBundle.getString("toolTipText"));
        this.setLayout(new BorderLayout());
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogItemEditDefinitionPanel());
    }

    public void persist() {
        for (CatalogDefsTableItem defItem : this.updateList) {
            XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
            XBCXDescService descService = (XBCXDescService)this.catalog.getCatalogService(XBCXDescService.class);
            XBCXStriService striService = (XBCXStriService)this.catalog.getCatalogService(XBCXStriService.class);
            XBESpecDef specDef = (XBESpecDef)defItem.getSpecDef();
            if (specDef != null && specDef.getType() != defItem.getDefType()) {
                this.specService.removeSpecDef((XBCSpecDef)specDef);
                specDef = null;
            }
            if (specDef == null) {
                specDef = (XBESpecDef)this.specService.createSpecDef((XBCSpec)this.catalogItem, defItem.getDefType());
            }
            specDef.setXBIndex(defItem.getXbIndex().longValue());
            specDef.setTargetRev((XBCRev)((XBERev)defItem.getTarget()));
            this.specService.persistSpecDef((XBCSpecDef)specDef);
            ((XBEXNameService)nameService).setDefaultText((XBCItem)specDef, defItem.getName());
            ((XBEXDescService)descService).setDefaultText((XBCItem)specDef, defItem.getDescription());
            ((XBEXStriService)striService).setItemStringIdText((XBCItem)specDef, defItem.getStringId());
        }
        for (CatalogDefsTableItem defItem : this.removeList) {
            if (defItem.getSpecDef() == null) continue;
            this.specService.removeItemDepth(defItem.getSpecDef());
        }
    }

    public void setCatalogItem(XBCItem catalogItem) {
        this.catalogItem = catalogItem;
        this.defsModel.setCatalogItem(catalogItem);
        this.updateList = new ArrayList<CatalogDefsTableItem>();
        this.removeList = new ArrayList<CatalogDefsTableItem>();
    }

    public XBCItem getCatalogItem() {
        return this.catalogItem;
    }

    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.specService = (XBCSpecService)catalog.getCatalogService(XBCSpecService.class);
        this.defsModel.setCatalog(catalog);
    }

    public CatalogDefsTableModel getDefsModel() {
        return this.defsModel;
    }

    public void definitionAdded(CatalogDefsTableItem resultDefinition) {
        CatalogDefsTableItem defItem;
        long maxXbIndex = 0L;
        if (this.defsModel.getRowCount() > 0 && (defItem = this.defsModel.getRowItem(this.defsModel.getRowCount() - 1)).getXbIndex() >= maxXbIndex) {
            maxXbIndex = defItem.getXbIndex() + 1L;
        }
        if (resultDefinition == null) {
            JOptionPane.showMessageDialog(this, "Target type is required", "Set is not allowed", 0);
            return;
        }
        resultDefinition.setXbIndex(Long.valueOf(maxXbIndex));
        if (!this.updateList.contains(resultDefinition)) {
            this.updateList.add(resultDefinition);
        }
        this.defsModel.addDefs(resultDefinition);
        this.defsModel.fireTableDataChanged();
    }

    public void definitionEdited(CatalogDefsTableItem resultDefinition) {
        if (resultDefinition == null) {
            JOptionPane.showMessageDialog(this, "Target type is required", "Set is not allowed", 0);
            return;
        }
        if (!this.updateList.contains(resultDefinition)) {
            this.updateList.add(resultDefinition);
        }
    }

    public void definitionRemoved(CatalogDefsTableItem resultDefinition) {
        if (this.updateList.contains(resultDefinition)) {
            this.updateList.remove(resultDefinition);
        }
        this.removeList.add(resultDefinition);
        this.defsModel.getDefs().remove(resultDefinition);
        this.defsModel.fireTableDataChanged();
    }

    public void definitionMovedUp(int selectedRow) {
        CatalogDefsTableItem targetSpecDef;
        CatalogDefsTableItem specDef = this.defsModel.getRowItem(selectedRow);
        if (!this.updateList.contains(specDef)) {
            this.updateList.add(specDef);
        }
        if (!this.updateList.contains(targetSpecDef = this.defsModel.getRowItem(selectedRow - 1))) {
            this.updateList.add(targetSpecDef);
        }
        this.defsModel.moveItemDown(selectedRow - 1);
        this.itemDefinitionsTable.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
    }

    public void definitionMovedDown(int selectedRow) {
        CatalogDefsTableItem targetSpecDef;
        CatalogDefsTableItem specDef = this.defsModel.getRowItem(selectedRow);
        if (!this.updateList.contains(specDef)) {
            this.updateList.add(specDef);
        }
        if (!this.updateList.contains(targetSpecDef = this.defsModel.getRowItem(selectedRow + 1))) {
            this.updateList.add(targetSpecDef);
        }
        this.defsModel.moveItemDown(selectedRow);
        this.itemDefinitionsTable.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
    }

    public void setPanelPopup(JPopupMenu popupMenu) {
        this.itemDefinitionsScrollPane.setComponentPopupMenu(popupMenu);
    }

    public void addSelectionListener(EditItemActionsUpdateListener updateListener) {
        this.itemDefinitionsTable.getSelectionModel().addListSelectionListener(e -> updateListener.stateChanged());
    }
}

