/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.property.gui;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.RemovalControlPanel;
import org.exbin.framework.xbup.catalog.item.property.gui.CatalogEditIconPanel;
import org.exbin.framework.xbup.catalog.item.property.gui.CatalogPropertyTableCellPanel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.service.XBCXIconService;

@ParametersAreNonnullByDefault
public class CatalogBIconPropertyTableCellPanel
extends CatalogPropertyTableCellPanel {
    private XBApplication application;
    private XBACatalog catalog;
    private byte[] icon;

    public CatalogBIconPropertyTableCellPanel(XBACatalog catalog) {
        this.catalog = catalog;
        this.init();
    }

    private void init() {
        this.setEditorAction(e -> this.performEditorAction());
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void performEditorAction() {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        CatalogEditIconPanel iconPanel = new CatalogEditIconPanel(this.catalog, this.icon);
        RemovalControlPanel controlPanel = new RemovalControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)iconPanel, (JPanel)controlPanel);
        frameModule.setDialogTitle(dialog, iconPanel.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            switch (actionType) {
                case OK: {
                    this.icon = iconPanel.getIcon();
                    this.setPropertyLabel();
                    break;
                }
                case CANCEL: {
                    break;
                }
                case REMOVE: {
                    this.icon = new byte[0];
                    this.setPropertyLabel();
                }
            }
            dialog.close();
        });
        dialog.showCentered((Component)((Object)this));
        dialog.dispose();
    }

    public void setCatalogItem(XBCItem catalogItem) {
        XBCXIconService iconService = (XBCXIconService)this.catalog.getCatalogService(XBCXIconService.class);
        this.icon = iconService.getDefaultBigIconData(catalogItem);
        this.setPropertyLabel();
    }

    private void setPropertyLabel() {
        this.setPropertyText(this.icon == null || this.icon.length == 0 ? "" : "[" + this.icon.length + " bytes]");
    }

    @Nullable
    public byte[] getIcon() {
        return this.icon;
    }

    @Nonnull
    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }
}

