/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.service.gui;

import java.awt.GridLayout;
import java.util.ResourceBundle;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.xbup.service.XBDbServiceClient;
import org.exbin.xbup.client.XBCatalogServiceClient;

@ParametersAreNonnullByDefault
public class ServiceInfoPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ServiceInfoPanel.class);
    private JLabel connectionHostLabel;
    private JTextField connectionHostTextField;
    private JPanel connectionInfoBorderPanel;
    private JPanel connectionInfoPanel;
    private JLabel connectionPortLabel;
    private JTextField connectionPortTextField;
    private JLabel connectionProtocolLabel;
    private JTextField connectionProtocolTextField;
    private JLabel managerHardwareLabel;
    private JTextField managerHardwareTextField;
    private JPanel managerInfoBorderPanel;
    private JPanel managerInfoPanel;
    private JLabel managerNameLabel;
    private JTextField managerNameTextField;
    private JLabel managerNetworkIPLabel;
    private JTextField managerNetworkIPTextField;
    private JLabel managerNetworkNameLabel;
    private JTextField managerNetworkNameTextField;
    private JLabel managerSystemLabel;
    private JTextField managerSystemTextField;
    private JLabel managerVersionLabel;
    private JTextField managerVersionTextField;
    private JLabel serviceInfoPanelLabel;
    private JPanel serviceInformationBorderPanel;
    private JPanel serviceInformationPanel;
    private JLabel serviceNameLabel;
    private JTextField serviceNameTextField;
    private JLabel serviceNetworkIPLabel;
    private JTextField serviceNetworkIPTextField;
    private JLabel serviceNetworkNameLabel;
    private JTextField serviceNetworkNameTextField;
    private JLabel serviceVersionLabel;
    private JTextField serviceVersionTextField;

    public ServiceInfoPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.serviceInfoPanelLabel = new JLabel();
        this.connectionInfoBorderPanel = new JPanel();
        this.connectionInfoPanel = new JPanel();
        this.connectionHostLabel = new JLabel();
        this.connectionHostTextField = new JTextField();
        this.connectionPortLabel = new JLabel();
        this.connectionPortTextField = new JTextField();
        this.connectionProtocolLabel = new JLabel();
        this.connectionProtocolTextField = new JTextField();
        this.serviceInformationBorderPanel = new JPanel();
        this.serviceInformationPanel = new JPanel();
        this.serviceNameLabel = new JLabel();
        this.serviceNameTextField = new JTextField();
        this.serviceVersionLabel = new JLabel();
        this.serviceVersionTextField = new JTextField();
        this.serviceNetworkNameLabel = new JLabel();
        this.serviceNetworkNameTextField = new JTextField();
        this.serviceNetworkIPLabel = new JLabel();
        this.serviceNetworkIPTextField = new JTextField();
        this.managerInfoBorderPanel = new JPanel();
        this.managerInfoPanel = new JPanel();
        this.managerNameLabel = new JLabel();
        this.managerNameTextField = new JTextField();
        this.managerVersionLabel = new JLabel();
        this.managerVersionTextField = new JTextField();
        this.managerNetworkNameLabel = new JLabel();
        this.managerNetworkNameTextField = new JTextField();
        this.managerNetworkIPLabel = new JLabel();
        this.managerNetworkIPTextField = new JTextField();
        this.managerSystemLabel = new JLabel();
        this.managerSystemTextField = new JTextField();
        this.managerHardwareLabel = new JLabel();
        this.managerHardwareTextField = new JTextField();
        this.connectionInfoBorderPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("connectionInfoBorderPanel.border.title")));
        this.connectionInfoPanel.setLayout(new GridLayout(3, 2, 5, 5));
        this.connectionHostLabel.setText(this.resourceBundle.getString("hostNameLabel.text"));
        this.connectionInfoPanel.add(this.connectionHostLabel);
        this.connectionHostTextField.setEditable(false);
        this.connectionHostTextField.setText("unknown");
        this.connectionHostTextField.setBorder(null);
        this.connectionInfoPanel.add(this.connectionHostTextField);
        this.connectionPortLabel.setText(this.resourceBundle.getString("connectionPortLabel.text"));
        this.connectionInfoPanel.add(this.connectionPortLabel);
        this.connectionPortTextField.setEditable(false);
        this.connectionPortTextField.setText("unknown");
        this.connectionPortTextField.setBorder(null);
        this.connectionInfoPanel.add(this.connectionPortTextField);
        this.connectionProtocolLabel.setText(this.resourceBundle.getString("connectionProtocolLabel.text"));
        this.connectionInfoPanel.add(this.connectionProtocolLabel);
        this.connectionProtocolTextField.setEditable(false);
        this.connectionProtocolTextField.setText("unknown");
        this.connectionProtocolTextField.setBorder(null);
        this.connectionInfoPanel.add(this.connectionProtocolTextField);
        GroupLayout connectionInfoBorderPanelLayout = new GroupLayout(this.connectionInfoBorderPanel);
        this.connectionInfoBorderPanel.setLayout(connectionInfoBorderPanelLayout);
        connectionInfoBorderPanelLayout.setHorizontalGroup(connectionInfoBorderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(connectionInfoBorderPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.connectionInfoPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        connectionInfoBorderPanelLayout.setVerticalGroup(connectionInfoBorderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(connectionInfoBorderPanelLayout.createSequentialGroup().addComponent(this.connectionInfoPanel, -2, -1, -2).addContainerGap(15, Short.MAX_VALUE)));
        this.serviceInformationBorderPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("serviceInfoBorderPanel.border.title")));
        this.serviceInformationPanel.setLayout(new GridLayout(4, 2, 5, 5));
        this.serviceNameLabel.setText(this.resourceBundle.getString("serviceNameLabel.text"));
        this.serviceInformationPanel.add(this.serviceNameLabel);
        this.serviceNameTextField.setEditable(false);
        this.serviceNameTextField.setText("unknown");
        this.serviceNameTextField.setBorder(null);
        this.serviceInformationPanel.add(this.serviceNameTextField);
        this.serviceVersionLabel.setText(this.resourceBundle.getString("serviceVersionLabel.text"));
        this.serviceInformationPanel.add(this.serviceVersionLabel);
        this.serviceVersionTextField.setEditable(false);
        this.serviceVersionTextField.setText("unknown");
        this.serviceVersionTextField.setBorder(null);
        this.serviceInformationPanel.add(this.serviceVersionTextField);
        this.serviceNetworkNameLabel.setText("Network Name:");
        this.serviceInformationPanel.add(this.serviceNetworkNameLabel);
        this.serviceNetworkNameTextField.setEditable(false);
        this.serviceNetworkNameTextField.setText("unknown");
        this.serviceNetworkNameTextField.setBorder(null);
        this.serviceInformationPanel.add(this.serviceNetworkNameTextField);
        this.serviceNetworkIPLabel.setText("IP Address:");
        this.serviceInformationPanel.add(this.serviceNetworkIPLabel);
        this.serviceNetworkIPTextField.setEditable(false);
        this.serviceNetworkIPTextField.setText("unknown");
        this.serviceNetworkIPTextField.setBorder(null);
        this.serviceInformationPanel.add(this.serviceNetworkIPTextField);
        GroupLayout serviceInformationBorderPanelLayout = new GroupLayout(this.serviceInformationBorderPanel);
        this.serviceInformationBorderPanel.setLayout(serviceInformationBorderPanelLayout);
        serviceInformationBorderPanelLayout.setHorizontalGroup(serviceInformationBorderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(serviceInformationBorderPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.serviceInformationPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        serviceInformationBorderPanelLayout.setVerticalGroup(serviceInformationBorderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(serviceInformationBorderPanelLayout.createSequentialGroup().addComponent(this.serviceInformationPanel, -2, -1, -2).addContainerGap(16, Short.MAX_VALUE)));
        this.managerInfoBorderPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("managerInfoBorderPanel.border.title")));
        this.managerInfoPanel.setLayout(new GridLayout(6, 2, 5, 5));
        this.managerNameLabel.setText(this.resourceBundle.getString("managerNameLabel.text"));
        this.managerInfoPanel.add(this.managerNameLabel);
        this.managerNameTextField.setEditable(false);
        this.managerNameTextField.setText("unknown");
        this.managerNameTextField.setBorder(null);
        this.managerInfoPanel.add(this.managerNameTextField);
        this.managerVersionLabel.setText(this.resourceBundle.getString("managerVersionLabel.text"));
        this.managerInfoPanel.add(this.managerVersionLabel);
        this.managerVersionTextField.setEditable(false);
        this.managerVersionTextField.setText("unknown");
        this.managerVersionTextField.setBorder(null);
        this.managerInfoPanel.add(this.managerVersionTextField);
        this.managerNetworkNameLabel.setText(this.resourceBundle.getString("managerNetworkNameLabel.text"));
        this.managerInfoPanel.add(this.managerNetworkNameLabel);
        this.managerNetworkNameTextField.setEditable(false);
        this.managerNetworkNameTextField.setText("unknown");
        this.managerNetworkNameTextField.setBorder(null);
        this.managerInfoPanel.add(this.managerNetworkNameTextField);
        this.managerNetworkIPLabel.setText(this.resourceBundle.getString("managerNetworkIPLabel.text"));
        this.managerInfoPanel.add(this.managerNetworkIPLabel);
        this.managerNetworkIPTextField.setEditable(false);
        this.managerNetworkIPTextField.setText("unknown");
        this.managerNetworkIPTextField.setBorder(null);
        this.managerInfoPanel.add(this.managerNetworkIPTextField);
        this.managerSystemLabel.setText(this.resourceBundle.getString("managerSystemLabel.text"));
        this.managerInfoPanel.add(this.managerSystemLabel);
        this.managerSystemTextField.setEditable(false);
        this.managerSystemTextField.setText("unknown");
        this.managerSystemTextField.setBorder(null);
        this.managerInfoPanel.add(this.managerSystemTextField);
        this.managerHardwareLabel.setText(this.resourceBundle.getString("managerHardwareLabel.text"));
        this.managerInfoPanel.add(this.managerHardwareLabel);
        this.managerHardwareTextField.setEditable(false);
        this.managerHardwareTextField.setText("unknown");
        this.managerHardwareTextField.setBorder(null);
        this.managerInfoPanel.add(this.managerHardwareTextField);
        GroupLayout managerInfoBorderPanelLayout = new GroupLayout(this.managerInfoBorderPanel);
        this.managerInfoBorderPanel.setLayout(managerInfoBorderPanelLayout);
        managerInfoBorderPanelLayout.setHorizontalGroup(managerInfoBorderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(managerInfoBorderPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.managerInfoPanel, -2, 291, Short.MAX_VALUE).addContainerGap()));
        managerInfoBorderPanelLayout.setVerticalGroup(managerInfoBorderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.managerInfoPanel, -2, -1, -2));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.serviceInfoPanelLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.serviceInformationBorderPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.connectionInfoBorderPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.managerInfoBorderPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.serviceInfoPanelLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connectionInfoBorderPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serviceInformationBorderPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.managerInfoBorderPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ServiceInfoPanel());
    }

    void setService(@Nullable XBCatalogServiceClient service) {
        if (service == null) {
            String unknown = "unknown";
            this.serviceVersionTextField.setText(unknown);
            this.connectionHostTextField.setText(unknown);
            this.connectionPortTextField.setText(unknown);
            this.connectionProtocolTextField.setText(unknown);
            this.serviceNameTextField.setText(unknown);
            this.serviceNetworkIPTextField.setText(unknown);
            this.managerNameTextField.setText(unknown);
            this.managerNetworkIPTextField.setText(unknown);
            this.managerSystemTextField.setText(unknown);
            this.managerHardwareTextField.setText(unknown);
        } else if (service instanceof XBDbServiceClient) {
            this.serviceVersionTextField.setText(service.getVersion());
            this.connectionHostTextField.setText(service.getHost());
            this.connectionPortTextField.setText(Integer.toString(service.getPort()));
            this.connectionProtocolTextField.setText("Dummy (DB)");
            this.serviceNameTextField.setText("XBService");
            this.serviceNetworkIPTextField.setText(service.getHostAddress());
            this.managerNameTextField.setText("XBManager");
            this.managerNetworkIPTextField.setText(service.getLocalAddress());
            this.managerSystemTextField.setText(System.getProperty("os.name") + " (" + System.getProperty("os.version") + ")");
            this.managerHardwareTextField.setText(System.getProperty("os.arch"));
        } else {
            this.serviceVersionTextField.setText(service.getVersion());
            this.connectionHostTextField.setText(service.getHost());
            this.connectionPortTextField.setText(Integer.toString(service.getPort()));
            this.connectionProtocolTextField.setText("UDP (IP)");
            this.serviceNameTextField.setText("XBService");
            this.serviceNetworkIPTextField.setText(service.getHostAddress());
            this.managerNameTextField.setText("XBManager");
            this.managerNetworkIPTextField.setText(service.getLocalAddress());
            this.managerSystemTextField.setText(System.getProperty("os.name") + " (" + System.getProperty("os.version") + ")");
            this.managerHardwareTextField.setText(System.getProperty("os.arch"));
        }
    }
}

