/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.service.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.Persistence;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.xbup.service.XBDbServiceClient;
import org.exbin.framework.xbup.service.gui.ConnectionsManagerPanel;
import org.exbin.xbup.client.XBCatalogNetServiceClient;
import org.exbin.xbup.client.XBCatalogServiceClient;

@ParametersAreNonnullByDefault
public class ConnectionPanel
extends JPanel {
    private XBApplication application;
    private XBCatalogServiceClient service;
    private static final String PREFERENCES_PREFIX = "catalogConnection";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ConnectionPanel.class);
    private ButtonGroup accessTypeButtonGroup;
    private JRadioButton anonymousRadioButton;
    private JProgressBar busyProgressBar;
    private JPanel busyStatusPanel;
    private JButton cancelButton;
    private JComboBox<String> connectionComboBox;
    private JPanel connectionHeaderPanel;
    private JPanel connectionLoginPanel;
    private JButton connectionManageButton;
    private JLabel connectionPointLabel;
    private JPanel connectionStatusPanel;
    private JPanel defaultPanel;
    private JButton devDbCatalogButton;
    private JButton devDbCatalogDevButton;
    private JButton devDbLocalButton;
    private JLayeredPane jLayeredPane1;
    private JLayeredPane jLayeredPane2;
    private JSeparator jSeparator1;
    private JPanel loginPanel;
    private JRadioButton loginRadioButton;
    private JLabel logoImageLabel;
    private JButton okButton;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JLabel prereleaseWarningLabel;
    private JLabel serviceLabel;
    private JPanel statusIndicatorPanel;
    private JLabel statusModeLabel;
    private JPanel statusPanel;
    private JLabel statusTextLabel;
    private JLabel usernameLabel;
    private JTextField usernameTextField;

    public ConnectionPanel() {
        this.initComponents();
        this.service = null;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void setConnectionStatus(Color color, String status, String statusLabel) {
        this.statusTextLabel.setText(status);
        this.statusIndicatorPanel.setBackground(color);
        if (statusLabel == null) {
            ((CardLayout)this.connectionStatusPanel.getLayout()).show(this.connectionStatusPanel, "default");
        } else {
            this.busyProgressBar.setString(statusLabel);
            ((CardLayout)this.connectionStatusPanel.getLayout()).show(this.connectionStatusPanel, "busy");
        }
    }

    public XBCatalogServiceClient getService() {
        return this.service;
    }

    private void initComponents() {
        this.accessTypeButtonGroup = new ButtonGroup();
        this.connectionHeaderPanel = new JPanel();
        this.prereleaseWarningLabel = new JLabel();
        this.jLayeredPane1 = new JLayeredPane();
        this.serviceLabel = new JLabel();
        this.jLayeredPane2 = new JLayeredPane();
        this.logoImageLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.connectionLoginPanel = new JPanel();
        this.loginPanel = new JPanel();
        this.usernameLabel = new JLabel();
        this.usernameTextField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.connectionPointLabel = new JLabel();
        this.connectionComboBox = new JComboBox();
        this.connectionManageButton = new JButton();
        this.anonymousRadioButton = new JRadioButton();
        this.loginRadioButton = new JRadioButton();
        this.devDbLocalButton = new JButton();
        this.devDbCatalogButton = new JButton();
        this.devDbCatalogDevButton = new JButton();
        this.statusPanel = new JPanel();
        this.connectionStatusPanel = new JPanel();
        this.defaultPanel = new JPanel();
        this.statusModeLabel = new JLabel();
        this.busyStatusPanel = new JPanel();
        this.busyProgressBar = new JProgressBar();
        this.statusIndicatorPanel = new JPanel();
        this.statusTextLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.connectionHeaderPanel.setBackground(new Color(255, 255, 255));
        this.prereleaseWarningLabel.setText(this.resourceBundle.getString("prereleaseWarningLabel.text"));
        this.jLayeredPane1.setBackground(new Color(204, 255, 204));
        this.jLayeredPane1.setOpaque(true);
        this.serviceLabel.setFont(new Font("Tahoma", 1, 36));
        this.serviceLabel.setText(this.resourceBundle.getString("serviceLabel.text"));
        this.jLayeredPane1.add(this.serviceLabel);
        this.serviceLabel.setBounds(100, 0, 480, 43);
        this.logoImageLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/xbup/service/resources/images/xbup_maskot4_small.png")));
        this.jLayeredPane2.add(this.logoImageLabel);
        this.logoImageLabel.setBounds(20, 0, 50, 0);
        GroupLayout connectionHeaderPanelLayout = new GroupLayout(this.connectionHeaderPanel);
        this.connectionHeaderPanel.setLayout(connectionHeaderPanelLayout);
        connectionHeaderPanelLayout.setHorizontalGroup(connectionHeaderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, connectionHeaderPanelLayout.createSequentialGroup().addGap(333, 333, 333).addComponent(this.prereleaseWarningLabel).addContainerGap(82, Short.MAX_VALUE)).addGroup(connectionHeaderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane2, -1, 639, Short.MAX_VALUE)).addGroup(connectionHeaderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -1, 639, Short.MAX_VALUE)).addGroup(connectionHeaderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 639, Short.MAX_VALUE)));
        connectionHeaderPanelLayout.setVerticalGroup(connectionHeaderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(connectionHeaderPanelLayout.createSequentialGroup().addContainerGap(60, Short.MAX_VALUE).addComponent(this.prereleaseWarningLabel, -2, 24, -2)).addGroup(connectionHeaderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane2, -1, 84, Short.MAX_VALUE)).addGroup(connectionHeaderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(connectionHeaderPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLayeredPane1, -2, 50, -2).addContainerGap(28, Short.MAX_VALUE))).addGroup(connectionHeaderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, connectionHeaderPanelLayout.createSequentialGroup().addGap(0, 82, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, -1, -2))));
        this.add((Component)this.connectionHeaderPanel, "North");
        this.loginPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("loginPanel.border.title")));
        this.loginPanel.setEnabled(false);
        this.usernameLabel.setText(this.resourceBundle.getString("usernameLabel.text"));
        this.usernameLabel.setEnabled(false);
        this.usernameTextField.setText("admin");
        this.usernameTextField.setEnabled(false);
        this.passwordLabel.setText(this.resourceBundle.getString("passwordLabel.text"));
        this.passwordLabel.setEnabled(false);
        this.passwordField.setEnabled(false);
        GroupLayout loginPanelLayout = new GroupLayout(this.loginPanel);
        this.loginPanel.setLayout(loginPanelLayout);
        loginPanelLayout.setHorizontalGroup(loginPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(loginPanelLayout.createSequentialGroup().addContainerGap().addGroup(loginPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.usernameLabel).addComponent(this.usernameTextField).addComponent(this.passwordLabel).addComponent(this.passwordField)).addContainerGap()));
        loginPanelLayout.setVerticalGroup(loginPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, loginPanelLayout.createSequentialGroup().addComponent(this.usernameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.usernameTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordField, -2, -1, -2).addContainerGap(22, Short.MAX_VALUE)));
        this.okButton.setText(this.resourceBundle.getString("okButton.text"));
        this.okButton.setToolTipText("");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionPanel.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(this.resourceBundle.getString("cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        this.connectionPointLabel.setText(this.resourceBundle.getString("connectionPointLabel.text"));
        this.connectionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"localhost:22594"}));
        this.connectionManageButton.setText(this.resourceBundle.getString("connectionManageButton.text"));
        this.connectionManageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionPanel.this.connectionManageButtonActionPerformed(evt);
            }
        });
        this.anonymousRadioButton.setSelected(true);
        this.anonymousRadioButton.setText(this.resourceBundle.getString("anonymousRadioButton.text"));
        this.anonymousRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionPanel.this.anonymousRadioButtonActionPerformed(evt);
            }
        });
        this.loginRadioButton.setText(this.resourceBundle.getString("loginRadioButton.text"));
        this.loginRadioButton.setToolTipText("");
        this.loginRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionPanel.this.loginRadioButtonActionPerformed(evt);
            }
        });
        this.devDbLocalButton.setText("DB: Local");
        this.devDbLocalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionPanel.this.devDbLocalButtonActionPerformed(evt);
            }
        });
        this.devDbCatalogButton.setText("DB: xbcatalog");
        this.devDbCatalogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionPanel.this.devDbCatalogButtonActionPerformed(evt);
            }
        });
        this.devDbCatalogDevButton.setText("DB: xbcatalog-dev");
        this.devDbCatalogDevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionPanel.this.devDbCatalogDevButtonActionPerformed(evt);
            }
        });
        GroupLayout connectionLoginPanelLayout = new GroupLayout(this.connectionLoginPanel);
        this.connectionLoginPanel.setLayout(connectionLoginPanelLayout);
        connectionLoginPanelLayout.setHorizontalGroup(connectionLoginPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(connectionLoginPanelLayout.createSequentialGroup().addContainerGap().addGroup(connectionLoginPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.anonymousRadioButton, -1, -1, Short.MAX_VALUE).addComponent(this.connectionPointLabel).addGroup(GroupLayout.Alignment.TRAILING, connectionLoginPanelLayout.createSequentialGroup().addComponent(this.connectionComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.connectionManageButton)).addComponent(this.loginRadioButton, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, connectionLoginPanelLayout.createSequentialGroup().addComponent(this.devDbLocalButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.devDbCatalogButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.devDbCatalogDevButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 65, Short.MAX_VALUE).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton)).addComponent(this.loginPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        connectionLoginPanelLayout.setVerticalGroup(connectionLoginPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(connectionLoginPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.connectionPointLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(connectionLoginPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.connectionComboBox, -2, -1, -2).addComponent(this.connectionManageButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.anonymousRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loginRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loginPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 34, Short.MAX_VALUE).addGroup(connectionLoginPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.devDbLocalButton).addComponent(this.devDbCatalogButton).addComponent(this.devDbCatalogDevButton)).addContainerGap()));
        this.add((Component)this.connectionLoginPanel, "Center");
        this.statusPanel.setBackground(UIManager.getDefaults().getColor("PropSheet.setBackground"));
        this.statusPanel.setLayout(new BorderLayout());
        this.connectionStatusPanel.setLayout(new CardLayout());
        this.defaultPanel.setLayout(new BorderLayout());
        this.defaultPanel.add((Component)this.statusModeLabel, "Center");
        this.connectionStatusPanel.add((Component)this.defaultPanel, "default");
        this.busyProgressBar.setIndeterminate(true);
        this.busyProgressBar.setString("");
        this.busyProgressBar.setStringPainted(true);
        GroupLayout busyStatusPanelLayout = new GroupLayout(this.busyStatusPanel);
        this.busyStatusPanel.setLayout(busyStatusPanelLayout);
        busyStatusPanelLayout.setHorizontalGroup(busyStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.busyProgressBar, -1, 506, Short.MAX_VALUE));
        busyStatusPanelLayout.setVerticalGroup(busyStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.busyProgressBar, -1, 25, Short.MAX_VALUE));
        this.connectionStatusPanel.add((Component)this.busyStatusPanel, "busy");
        this.statusPanel.add((Component)this.connectionStatusPanel, "Center");
        this.statusIndicatorPanel.setBackground(new Color(153, 153, 153));
        this.statusTextLabel.setFont(new Font("Tahoma", 1, 11));
        this.statusTextLabel.setForeground(UIManager.getDefaults().getColor("TabRenderer.selectedActivatedForeground"));
        this.statusTextLabel.setHorizontalAlignment(0);
        this.statusTextLabel.setText("Disconnected");
        GroupLayout statusIndicatorPanelLayout = new GroupLayout(this.statusIndicatorPanel);
        this.statusIndicatorPanel.setLayout(statusIndicatorPanelLayout);
        statusIndicatorPanelLayout.setHorizontalGroup(statusIndicatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusTextLabel, GroupLayout.Alignment.TRAILING, -1, 133, Short.MAX_VALUE));
        statusIndicatorPanelLayout.setVerticalGroup(statusIndicatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusTextLabel, -2, 24, -2));
        this.statusPanel.add((Component)this.statusIndicatorPanel, "East");
        this.add((Component)this.statusPanel, "South");
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String connectionHost;
        String connectionString = (String)this.connectionComboBox.getSelectedItem();
        int connectionPort = 22594;
        int pos = connectionString.indexOf(":");
        if (pos >= 0) {
            connectionHost = connectionString.substring(0, pos);
            connectionPort = Integer.valueOf(connectionString.substring(pos + 1));
        } else {
            connectionHost = connectionString;
        }
        this.okButton.setEnabled(false);
        this.service = new XBCatalogNetServiceClient(connectionHost, connectionPort);
        String connectionLabel = "Connecting to server " + connectionHost + ":" + connectionPort;
        new Thread(() -> {
            block6: {
                this.setConnectionStatus(Color.ORANGE, "Connecting", connectionLabel);
                if (this.service != null) {
                    this.setConnectionStatus(Color.ORANGE, "Logging in", "Logging in...");
                    try {
                        int loginResult = this.service.login(this.usernameTextField.getText(), this.passwordField.getPassword());
                        if (loginResult == 0) {
                            this.setConnectionStatus(Color.GREEN, "Connected", null);
                            this.closeDialog();
                            break block6;
                        }
                        this.statusModeLabel.setText("Unable to login: error " + loginResult);
                        this.setConnectionStatus(Color.RED, "Failed", null);
                    }
                    catch (ConnectException ex) {
                        this.statusModeLabel.setText("Unable to connect: " + ex.getMessage());
                        this.setConnectionStatus(Color.RED, "Failed", null);
                    }
                    catch (IOException | UnsupportedOperationException ex) {
                        Logger.getLogger(ConnectionPanel.class.getName()).log(Level.SEVERE, null, ex);
                        this.setConnectionStatus(Color.RED, "Failed", null);
                    }
                } else {
                    this.setConnectionStatus(Color.RED, "Disconnected", null);
                }
            }
            this.okButton.setEnabled(true);
        }).start();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void connectionManageButtonActionPerformed(ActionEvent evt) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        ConnectionsManagerPanel panel = new ConnectionsManagerPanel();
        panel.setApplication(this.application);
        ArrayList<String> connectionList = new ArrayList<String>();
        int itemsCount = this.connectionComboBox.getItemCount();
        for (int i = 0; i < itemsCount; ++i) {
            connectionList.add(this.connectionComboBox.getItemAt(i));
        }
        panel.setConnectionList(connectionList);
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)panel, (JPanel)controlPanel);
        frameModule.setDialogTitle(dialog, panel.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            switch (actionType) {
                case OK: {
                    List<String> connectionList = panel.getConnectionList();
                    DefaultComboBoxModel comboBoxModel = (DefaultComboBoxModel)this.connectionComboBox.getModel();
                    comboBoxModel.removeAllElements();
                    connectionList.forEach(connection -> comboBoxModel.addElement(connection));
                    break;
                }
                case CANCEL: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected action type " + actionType.name());
                }
            }
            dialog.close();
        });
        dialog.showCentered((Component)this);
        dialog.dispose();
    }

    private void anonymousRadioButtonActionPerformed(ActionEvent evt) {
        this.setLoginAccountEnabled(false);
    }

    private void loginRadioButtonActionPerformed(ActionEvent evt) {
        this.setLoginAccountEnabled(true);
    }

    private void devDbLocalButtonActionPerformed(ActionEvent evt) {
        this.service = new XBDbServiceClient(Persistence.createEntityManagerFactory((String)"XBManagerLocalPU"));
        try {
            this.service.login(this.usernameTextField.getText(), this.passwordField.getPassword());
        }
        catch (IOException ex) {
            Logger.getLogger(ConnectionPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setConnectionStatus(Color.GREEN, "Connected", null);
        this.closeDialog();
    }

    private void devDbCatalogButtonActionPerformed(ActionEvent evt) {
        this.service = new XBDbServiceClient(Persistence.createEntityManagerFactory((String)"XBManagerMySQLPU"));
        try {
            this.service.login(this.usernameTextField.getText(), this.passwordField.getPassword());
        }
        catch (IOException ex) {
            Logger.getLogger(ConnectionPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setConnectionStatus(Color.GREEN, "Connected", null);
        this.closeDialog();
    }

    private void devDbCatalogDevButtonActionPerformed(ActionEvent evt) {
        this.service = new XBDbServiceClient(Persistence.createEntityManagerFactory((String)"XBManagerMySQLDevPU"));
        try {
            this.service.login(this.usernameTextField.getText(), this.passwordField.getPassword());
        }
        catch (IOException ex) {
            Logger.getLogger(ConnectionPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setConnectionStatus(Color.GREEN, "Connected", null);
        this.closeDialog();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ConnectionPanel());
    }

    private void setLoginAccountEnabled(boolean enabled) {
        this.loginPanel.setEnabled(enabled);
        this.usernameLabel.setEnabled(enabled);
        this.usernameTextField.setEnabled(enabled);
        this.passwordLabel.setEnabled(enabled);
        this.passwordField.setEnabled(enabled);
    }

    public List<String> getConnectionList() {
        ArrayList<String> connectionList = new ArrayList<String>();
        for (int pos = 0; pos < this.connectionComboBox.getItemCount(); ++pos) {
            connectionList.add(this.connectionComboBox.getItemAt(pos));
        }
        return connectionList;
    }

    public void setConnectionList(List<String> connectionList) {
        this.connectionComboBox.removeAllItems();
        connectionList.forEach(connection -> this.connectionComboBox.addItem((String)connection));
    }

    public void loadConnectionList(Preferences preferences) {
        ArrayList<String> connectionList = new ArrayList<String>();
        long pos = 1L;
        while (preferences.exists(PREFERENCES_PREFIX + String.valueOf(pos))) {
            connectionList.add(preferences.get(PREFERENCES_PREFIX + String.valueOf(pos), ""));
            ++pos;
        }
        if (!connectionList.isEmpty()) {
            this.setConnectionList(connectionList);
        }
    }

    public void saveConnectionList(Preferences preferences) {
        List<String> connectionList = this.getConnectionList();
        for (int pos = 0; pos < connectionList.size(); ++pos) {
            preferences.put(PREFERENCES_PREFIX + String.valueOf(pos + 1), connectionList.get(pos));
        }
    }

    private void closeDialog() {
        WindowUtils.closeWindow((Window)SwingUtilities.getWindowAncestor(this));
    }

    public JButton getCloseButton() {
        return this.cancelButton;
    }
}

