/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.viewer.gui;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import org.exbin.framework.editor.xbup.viewer.XbupTreeDocument;
import org.exbin.framework.editor.xbup.viewer.gui.XBBlockTableModel;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.parser_tree.XBTTreeNode;

@ParametersAreNonnullByDefault
public class XBBlockNameTableCellRenderer
extends DefaultTableCellRenderer {
    private final ImageIcon dataBlockIcon = new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/data-block-16x16.png"));
    private final Icon directoryIcon = UIManager.getIcon("FileView.directoryIcon");
    private XbupTreeDocument treeDocument;

    @Override
    @Nonnull
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        XBBlockTableModel tableModel = (XBBlockTableModel)table.getModel();
        XBTBlock block = tableModel.getRowAt(row);
        ImageIcon icon = null;
        if (block != null && block.getDataMode() == XBBlockDataMode.DATA_BLOCK) {
            icon = this.dataBlockIcon;
        } else if (block instanceof XBTTreeNode) {
            icon = this.treeDocument.getBlockIcon(((XBTTreeNode)block).getBlockDecl());
        }
        component.setIcon(icon == null ? this.directoryIcon : icon);
        return component;
    }

    public void setTreeDocument(XbupTreeDocument treeDocument) {
        this.treeDocument = treeDocument;
    }
}

