/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.viewer;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.viewer.BinaryViewer;
import org.exbin.framework.editor.xbup.viewer.BlockViewer;
import org.exbin.framework.editor.xbup.viewer.DocumentItemSelectionListener;
import org.exbin.framework.editor.xbup.viewer.DocumentViewer;
import org.exbin.framework.editor.xbup.viewer.PropertiesViewer;
import org.exbin.framework.editor.xbup.viewer.StructureViewer;
import org.exbin.framework.editor.xbup.viewer.TextualViewer;
import org.exbin.framework.editor.xbup.viewer.XbupTreeDocument;
import org.exbin.framework.editor.xbup.viewer.gui.XBDocumentPanel;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.operation.undo.XBUndoHandler;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class XbupDocumentViewer {
    private XbupTreeDocument treeDocument;
    private final XBDocumentPanel documentPanel = new XBDocumentPanel();
    private final List<BlockViewer> blockViewers = new ArrayList<BlockViewer>();
    private final DocumentViewer documentViewer = new DocumentViewer();
    private final StructureViewer structureViewer = new StructureViewer();
    private final PropertiesViewer propertiesViewer = new PropertiesViewer();
    private final TextualViewer textualViewer = new TextualViewer();
    private final BinaryViewer binaryViewer = new BinaryViewer();

    public XbupDocumentViewer() {
        this.init();
    }

    private void init() {
        this.blockViewers.add(this.documentViewer);
        this.blockViewers.add(this.structureViewer);
        this.blockViewers.add(this.propertiesViewer);
        this.blockViewers.add(this.textualViewer);
        this.blockViewers.add(this.binaryViewer);
        for (BlockViewer blockViewer : this.blockViewers) {
            this.documentPanel.addBlockViewer(blockViewer);
        }
        this.documentPanel.addTabChangedListener(() -> {
            BlockViewer activeViewer = this.documentPanel.getActiveViewer().orElse(null);
            if (activeViewer instanceof StructureViewer) {
                ((StructureViewer)activeViewer).postWindowOpened();
            }
        });
    }

    @Nonnull
    public JComponent getComponent() {
        return this.documentPanel;
    }

    public void postWindowOpened() {
        this.structureViewer.postWindowOpened();
    }

    public void setCatalog(XBACatalog catalog) {
        this.blockViewers.forEach(blockViewer -> blockViewer.setCatalog(catalog));
    }

    public void setApplication(XBApplication application) {
        this.blockViewers.forEach(blockViewer -> blockViewer.setApplication(application));
    }

    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.documentPanel.setPluginRepository(pluginRepository);
        this.blockViewers.forEach(blockViewer -> blockViewer.setPluginRepository(pluginRepository));
    }

    @Nonnull
    public Optional<BlockViewer> getCurrentViewer() {
        return this.documentPanel.getActiveViewer();
    }

    @Nonnull
    public XbupTreeDocument getTreeDocument() {
        return Objects.requireNonNull(this.treeDocument);
    }

    public void setTreeDocument(XbupTreeDocument treeDocument) {
        this.treeDocument = treeDocument;
        this.structureViewer.setTreeDocument(treeDocument);
    }

    public void setBlock(XBTBlock block) {
        this.blockViewers.forEach(blockViewer -> blockViewer.setBlock(block));
        this.documentPanel.setBlock((XBTBlock)((XBTTreeNode)block));
    }

    public void setUndoHandler(XBUndoHandler undoHandler) {
        this.documentViewer.setUndoHandler(undoHandler);
        this.structureViewer.setUndoHandler(undoHandler);
    }

    public void setAddressText(String addressText) {
        this.documentPanel.setAddressText(addressText);
    }

    public boolean isEditable() {
        return true;
    }

    public void setDevMode(boolean devMode) {
        this.propertiesViewer.setDevMode(devMode);
    }

    public void notifyFileChanged() {
        XBTBlock block = this.treeDocument.getRootBlock().orElse(null);
        this.structureViewer.reportStructureChange(block);
        this.documentPanel.setBlock((XBTBlock)((XBTTreeNode)block));
    }

    public void addItemSelectionListener(DocumentItemSelectionListener listener) {
        this.structureViewer.addItemSelectionListener(listener);
    }

    public void removeItemSelectionListener(DocumentItemSelectionListener listener) {
        this.structureViewer.removeItemSelectionListener(listener);
    }

    @Nonnull
    public Optional<XBTBlock> getSelectedItem() {
        return this.structureViewer.getSelectedItem();
    }
}

