/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.nio.charset.Charset;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.text.gui.TextPanel;
import org.exbin.framework.editor.text.service.TextSearchService;
import org.exbin.framework.editor.xbup.gui.SimpleMessagePanel;
import org.exbin.framework.editor.xbup.viewer.BlockViewer;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBFBlockType;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class TextualViewer
implements BlockViewer {
    private final JPanel wrapperPanel = new JPanel(new BorderLayout());
    private final SimpleMessagePanel messagePanel = new SimpleMessagePanel();
    private final TextPanel textPanel = new TextPanel();
    private XBACatalog catalog;
    private XBTBlock block = null;

    public TextualViewer() {
        this.textPanel.setNoBorder();
        this.textPanel.setEditable(false);
        this.wrapperPanel.add((Component)this.messagePanel, "Center");
    }

    @Override
    @Nonnull
    public JComponent getComponent() {
        return this.wrapperPanel;
    }

    @Override
    @Nonnull
    public String getName() {
        return "Text";
    }

    @Override
    @Nonnull
    public Optional<ImageIcon> getIcon() {
        return Optional.of(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/open_icon_library-standard/icons/png/16x16/actions/format-text-smallcaps.png")));
    }

    @Override
    public void setBlock(@Nullable XBTBlock block) {
        if (this.block != block) {
            if (block != null) {
                String text = "<!XBUP version=\"0.1\">\n";
                text = this.nodeAsText((XBTTreeNode)block, "").toString();
                this.textPanel.setText(text);
            }
            if (block == null && this.block != null) {
                this.wrapperPanel.remove((Component)this.textPanel);
                this.wrapperPanel.add((Component)this.messagePanel, "Center");
                this.wrapperPanel.revalidate();
                this.wrapperPanel.repaint();
            } else if (block != null && this.block == null) {
                this.wrapperPanel.remove(this.messagePanel);
                this.wrapperPanel.add((Component)this.textPanel, "Center");
                this.wrapperPanel.revalidate();
                this.wrapperPanel.repaint();
            }
            this.block = block;
        }
    }

    public Color[] getDefaultColors() {
        return this.textPanel.getDefaultColors();
    }

    public void setCurrentColors(Color[] colors) {
        this.textPanel.setCurrentColors(colors);
    }

    public Font getDefaultFont() {
        return this.textPanel.getDefaultFont();
    }

    public void setCurrentFont(Font deriveFont) {
        this.textPanel.setCurrentFont(deriveFont);
    }

    public boolean changeLineWrap() {
        return this.textPanel.changeLineWrap();
    }

    public int getLineCount() {
        return this.textPanel.getLineCount();
    }

    public void gotoRelative(int charPos) {
        this.textPanel.gotoRelative(charPos);
    }

    public void gotoLine(int line) {
        this.textPanel.gotoLine(line);
    }

    public void findText(TextSearchService.FindTextParameters findTextParameters) {
        this.textPanel.findText(findTextParameters);
    }

    public void setCharset(Charset charset) {
        this.textPanel.setCharset(charset);
    }

    public Color[] getCurrentColors() {
        return this.textPanel.getCurrentColors();
    }

    public void setFileMode(int i) {
    }

    public Font getCurrentFont() {
        return this.textPanel.getCurrentFont();
    }

    @Nonnull
    private StringBuffer nodeAsText(@Nullable XBTTreeNode node, String prefix) {
        StringBuffer result = new StringBuffer();
        result.append(prefix);
        if (node == null) {
            return result;
        }
        if (node.getDataMode() == XBBlockDataMode.DATA_BLOCK) {
            result.append("[");
            for (long i = 0L; i < node.getDataSize(); ++i) {
                byte b = node.getBlockData().getByte(i);
                result.append(TextualViewer.getHex(b));
            }
            result.append("]\n");
        } else {
            result.append("<").append(this.getCaption(node));
            if (node.getAttributesCount() > 2) {
                XBAttribute[] attributes = node.getAttributes();
                for (int i = 0; i < attributes.length; ++i) {
                    XBAttribute attribute = attributes[i];
                    result.append(" ").append(i + 1).append("=\"").append(attribute.getNaturalLong()).append("\"");
                }
            }
            if (node.getChildren() != null) {
                XBTBlock[] children;
                result.append(">\n");
                for (XBTBlock child : children = node.getChildren()) {
                    result.append(this.nodeAsText((XBTTreeNode)child, prefix + "  "));
                }
                result.append(prefix);
                result.append("</").append(this.getCaption(node)).append(">\n");
            } else {
                result.append("/>\n");
            }
        }
        return result;
    }

    public static String getHex(byte b) {
        byte low = (byte)(b & 0xF);
        byte hi = (byte)(b >> 8);
        return (Integer.toHexString(hi) + Integer.toHexString(low)).toUpperCase();
    }

    @Nonnull
    private String getCaption(XBTTreeNode node) {
        if (node.getDataMode() == XBBlockDataMode.DATA_BLOCK) {
            return "Data Block";
        }
        XBBlockType blockType = node.getBlockType();
        if (this.catalog != null) {
            XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
            XBCBlockDecl blockDecl = (XBCBlockDecl)node.getBlockDecl();
            if (blockDecl != null) {
                XBCBlockSpec blockSpec = blockDecl.getBlockSpecRev().getParent();
                return nameService.getDefaultText((XBCItem)blockSpec);
            }
        }
        return "Unknown (" + Integer.toString(((XBFBlockType)blockType).getGroupID().getInt()) + ", " + Integer.toString(((XBFBlockType)blockType).getBlockID().getInt()) + ")";
    }

    @Override
    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public void setApplication(XBApplication application) {
    }

    @Override
    public void setPluginRepository(XBPluginRepository pluginRepository) {
    }
}

