/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.def.gui;

import java.awt.GridLayout;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.def.AttributesEditor;
import org.exbin.framework.editor.xbup.def.BlocksEditor;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class NodeBlockPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(NodeBlockPanel.class);
    private XBApplication application;
    private final AttributesEditor attributesEditor = new AttributesEditor();
    private final BlocksEditor blocksEditor = new BlocksEditor();
    private JTabbedPane tabbedPane;

    public NodeBlockPanel() {
        this.initComponents();
        this.tabbedPane.add("Attributes", this.attributesEditor.getEditorPanel());
        this.tabbedPane.add("Child Blocks", this.blocksEditor.getEditorPanel());
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.attributesEditor.setApplication(application);
        this.blocksEditor.setApplication(application);
    }

    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.blocksEditor.setPluginRepository(pluginRepository);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.setLayout(new GridLayout());
        this.add(this.tabbedPane);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new NodeBlockPanel());
    }

    public void setCatalog(XBACatalog catalog) {
        this.attributesEditor.setCatalog(catalog);
        this.blocksEditor.setCatalog(catalog);
    }

    public void setBlock(XBTTreeNode block) {
        this.attributesEditor.setBlock(block);
        this.blocksEditor.setBlock(block);
    }
}

