/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup;

import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.exbin.framework.XBFrameworkUtils;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.action.api.MenuGroup;
import org.exbin.framework.action.api.MenuPosition;
import org.exbin.framework.action.api.PositionMode;
import org.exbin.framework.action.api.SeparationMode;
import org.exbin.framework.action.api.ToolBarGroup;
import org.exbin.framework.action.api.ToolBarPosition;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.api.XBApplicationModule;
import org.exbin.framework.api.XBModuleRepositoryUtils;
import org.exbin.framework.client.api.ClientConnectionListener;
import org.exbin.framework.editor.api.EditorModuleApi;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.api.EditorProviderVariant;
import org.exbin.framework.editor.api.MultiEditorProvider;
import org.exbin.framework.editor.xbup.StatusPanelHandler;
import org.exbin.framework.editor.xbup.action.AddItemAction;
import org.exbin.framework.editor.xbup.action.DocumentPropertiesAction;
import org.exbin.framework.editor.xbup.action.EditItemAction;
import org.exbin.framework.editor.xbup.action.ExportItemAction;
import org.exbin.framework.editor.xbup.action.ImportItemAction;
import org.exbin.framework.editor.xbup.action.ItemPropertiesAction;
import org.exbin.framework.editor.xbup.action.SampleFilesActions;
import org.exbin.framework.editor.xbup.options.gui.ServiceConnectionPanel;
import org.exbin.framework.editor.xbup.options.impl.ServiceConnectionOptionsImpl;
import org.exbin.framework.editor.xbup.preferences.ServiceConnectionPreferences;
import org.exbin.framework.editor.xbup.viewer.XbupEditorProvider;
import org.exbin.framework.editor.xbup.viewer.XbupMultiEditorProvider;
import org.exbin.framework.editor.xbup.viewer.XbupSingleEditorProvider;
import org.exbin.framework.file.api.FileModuleApi;
import org.exbin.framework.file.api.FileType;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.options.api.DefaultOptionsPage;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.xbup.catalog.XBFileType;
import org.exbin.framework.xbup.catalog.action.CatalogsManagerAction;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.plugin.XBModuleHandler;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class EditorXbupModule
implements XBApplicationModule {
    public static final String MODULE_ID = XBModuleRepositoryUtils.getModuleIdByApi(EditorXbupModule.class);
    public static final String XB_FILE_TYPE = "XBEditor.XBFileType";
    public static final String XBUP_POPUP_MENU_ID = MODULE_ID + ".xbupPopupMenu";
    private static final String EDIT_ITEM_MENU_GROUP_ID = MODULE_ID + ".editItemMenuGroup";
    private static final String EDIT_ITEM_TOOL_BAR_GROUP_ID = MODULE_ID + ".editItemToolBarGroup";
    public static final String DOC_STATUS_BAR_ID = "docStatusBar";
    public static final String SAMPLE_FILE_SUBMENU_ID = MODULE_ID + ".sampleFileSubMenu";
    private XBApplication application;
    private XbupEditorProvider editorProvider;
    private ResourceBundle resourceBundle;
    private XBACatalog catalog;
    private StatusPanelHandler statusPanelHandler;
    private SampleFilesActions sampleFilesActions;
    private CatalogsManagerAction catalogBrowserAction;
    private ItemPropertiesAction itemPropertiesAction;
    private DocumentPropertiesAction documentPropertiesAction;
    private ImportItemAction importItemAction;
    private ExportItemAction exportItemAction;
    private AddItemAction addItemAction;
    private EditItemAction editItemAction;
    private JPopupMenu itemPopupMenu;
    private DefaultOptionsPage<ServiceConnectionOptionsImpl> catalogConnectionOptionsPage;
    private boolean devMode;

    public void init(XBModuleHandler application) {
        this.application = (XBApplication)application;
    }

    public void initEditorProvider(EditorProviderVariant variant) {
        switch (variant) {
            case SINGLE: {
                this.editorProvider = this.createSingleEditorProvider();
                break;
            }
            case MULTI: {
                this.editorProvider = this.createMultiEditorProvider();
                break;
            }
            default: {
                throw XBFrameworkUtils.getInvalidTypeException((Enum)variant);
            }
        }
    }

    public void unregisterModule(String moduleId) {
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = LanguageUtils.getResourceBundleByClass(EditorXbupModule.class);
        }
        return this.resourceBundle;
    }

    @Nonnull
    private XbupEditorProvider createSingleEditorProvider() {
        if (this.editorProvider == null) {
            this.editorProvider = new XbupSingleEditorProvider();
            ((XbupSingleEditorProvider)this.editorProvider).setApplication(this.application);
            ((XbupSingleEditorProvider)this.editorProvider).setDevMode(this.devMode);
        }
        return this.editorProvider;
    }

    @Nonnull
    private XbupEditorProvider createMultiEditorProvider() {
        if (this.editorProvider == null) {
            this.editorProvider = new XbupMultiEditorProvider(this.application);
            ((XbupMultiEditorProvider)this.editorProvider).setDevMode(this.devMode);
            ((MultiEditorProvider)this.editorProvider).addActiveFileChangeListener(e -> this.updateActionStatus());
        }
        return this.editorProvider;
    }

    public void updateActionStatus() {
        EditorModuleApi editorModule = (EditorModuleApi)this.application.getModuleRepository().getModuleByInterface(EditorModuleApi.class);
        editorModule.updateActionStatus();
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        fileModule.updateForFileOperations();
    }

    public void registerFileTypes() {
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        fileModule.addFileType((FileType)new XBFileType());
    }

    @Nonnull
    public EditorProvider getEditorProvider() {
        return Objects.requireNonNull(this.editorProvider, "Editor provider was not yet initialized");
    }

    private void ensureSetup() {
        if (this.editorProvider == null) {
            this.getEditorProvider();
        }
        if (this.resourceBundle == null) {
            this.getResourceBundle();
        }
    }

    @Nonnull
    private StatusPanelHandler getStatusPanelHandler() {
        if (this.statusPanelHandler == null) {
            this.ensureSetup();
            this.statusPanelHandler = new StatusPanelHandler();
            this.statusPanelHandler.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.statusPanelHandler;
    }

    @Nonnull
    private SampleFilesActions getSampleFilesActions() {
        if (this.sampleFilesActions == null) {
            this.ensureSetup();
            this.sampleFilesActions = new SampleFilesActions();
            this.sampleFilesActions.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.sampleFilesActions;
    }

    @Nonnull
    private CatalogsManagerAction getCatalogBrowserAction() {
        if (this.catalogBrowserAction == null) {
            this.ensureSetup();
            this.catalogBrowserAction = new CatalogsManagerAction();
            this.catalogBrowserAction.setup(this.application);
            this.catalogBrowserAction.setCatalog(this.catalog);
        }
        return this.catalogBrowserAction;
    }

    @Nonnull
    private ItemPropertiesAction getItemPropertiesAction() {
        if (this.itemPropertiesAction == null) {
            this.ensureSetup();
            this.itemPropertiesAction = new ItemPropertiesAction();
            this.itemPropertiesAction.setup(this.editorProvider);
            this.itemPropertiesAction.setDevMode(this.devMode);
        }
        return this.itemPropertiesAction;
    }

    @Nonnull
    private DocumentPropertiesAction getDocumentPropertiesAction() {
        if (this.documentPropertiesAction == null) {
            this.ensureSetup();
            this.documentPropertiesAction = new DocumentPropertiesAction();
            this.documentPropertiesAction.setup(this.editorProvider);
        }
        return this.documentPropertiesAction;
    }

    @Nonnull
    public ImportItemAction getImportItemAction() {
        if (this.importItemAction == null) {
            this.ensureSetup();
            this.importItemAction = new ImportItemAction();
            this.importItemAction.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.importItemAction;
    }

    @Nonnull
    public ExportItemAction getExportItemAction() {
        if (this.exportItemAction == null) {
            this.ensureSetup();
            this.exportItemAction = new ExportItemAction();
            this.exportItemAction.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.exportItemAction;
    }

    @Nonnull
    public AddItemAction getAddItemAction() {
        if (this.addItemAction == null) {
            this.addItemAction = new AddItemAction();
            this.addItemAction.setup(this.editorProvider);
        }
        return this.addItemAction;
    }

    @Nonnull
    public EditItemAction getEditItemAction() {
        if (this.editItemAction == null) {
            this.editItemAction = new EditItemAction();
            this.editItemAction.setup(this.editorProvider);
        }
        return this.editItemAction;
    }

    public void registerDocEditingMenuActions() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuGroup(FrameModuleApi.EDIT_MENU_ID, new MenuGroup(EDIT_ITEM_MENU_GROUP_ID, new MenuPosition(PositionMode.BOTTOM), SeparationMode.AROUND));
        actionModule.registerMenuItem(FrameModuleApi.EDIT_MENU_ID, MODULE_ID, (Action)this.getAddItemAction(), new MenuPosition(EDIT_ITEM_MENU_GROUP_ID));
        actionModule.registerMenuItem(FrameModuleApi.EDIT_MENU_ID, MODULE_ID, (Action)this.getEditItemAction(), new MenuPosition(EDIT_ITEM_MENU_GROUP_ID));
    }

    public void registerDocEditingToolBarActions() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerToolBarGroup(FrameModuleApi.MAIN_TOOL_BAR_ID, new ToolBarGroup(EDIT_ITEM_TOOL_BAR_GROUP_ID, new ToolBarPosition(PositionMode.BOTTOM), SeparationMode.AROUND));
        actionModule.registerToolBarItem(FrameModuleApi.MAIN_TOOL_BAR_ID, MODULE_ID, (Action)this.getAddItemAction(), new ToolBarPosition(EDIT_ITEM_TOOL_BAR_GROUP_ID));
        actionModule.registerToolBarItem(FrameModuleApi.MAIN_TOOL_BAR_ID, MODULE_ID, (Action)this.getEditItemAction(), new ToolBarPosition(EDIT_ITEM_TOOL_BAR_GROUP_ID));
    }

    public void registerStatusBar() {
        this.getStatusPanelHandler();
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        frameModule.registerStatusBar(MODULE_ID, DOC_STATUS_BAR_ID, (JPanel)this.statusPanelHandler.getDocStatusPanel());
        frameModule.switchStatusBar(DOC_STATUS_BAR_ID);
    }

    public void registerSampleFilesSubMenuActions() {
        this.getSampleFilesActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenu(SAMPLE_FILE_SUBMENU_ID, MODULE_ID);
        actionModule.registerMenuItem(FrameModuleApi.FILE_MENU_ID, MODULE_ID, SAMPLE_FILE_SUBMENU_ID, "Open Sample File", new MenuPosition(PositionMode.BOTTOM));
        actionModule.registerMenuItem(SAMPLE_FILE_SUBMENU_ID, MODULE_ID, this.sampleFilesActions.getSampleHtmlFileAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(SAMPLE_FILE_SUBMENU_ID, MODULE_ID, this.sampleFilesActions.getSamplePictureFileAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(SAMPLE_FILE_SUBMENU_ID, MODULE_ID, this.sampleFilesActions.getSampleTypesFileAction(), new MenuPosition(PositionMode.TOP));
    }

    public void registerCatalogBrowserMenu() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.TOOLS_MENU_ID, MODULE_ID, (Action)this.getCatalogBrowserAction(), new MenuPosition(PositionMode.TOP));
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public void registerOptionsPanels() {
        OptionsModuleApi optionsModule = (OptionsModuleApi)this.application.getModuleRepository().getModuleByInterface(OptionsModuleApi.class);
        this.catalogConnectionOptionsPage = new DefaultOptionsPage<ServiceConnectionOptionsImpl>(){
            private ServiceConnectionPanel panel;

            public OptionsComponent<ServiceConnectionOptionsImpl> createPanel() {
                if (this.panel == null) {
                    this.panel = new ServiceConnectionPanel();
                }
                return this.panel;
            }

            @Nonnull
            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(ServiceConnectionPanel.class);
            }

            public ServiceConnectionOptionsImpl createOptions() {
                return new ServiceConnectionOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, ServiceConnectionOptionsImpl options) {
                options.loadFromPreferences(new ServiceConnectionPreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, ServiceConnectionOptionsImpl options) {
                options.saveToPreferences(new ServiceConnectionPreferences(preferences));
            }

            public void applyPreferencesChanges(ServiceConnectionOptionsImpl options) {
            }
        };
        optionsModule.addOptionsPage(this.catalogConnectionOptionsPage);
    }

    public void registerPropertiesMenuAction() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.FILE_MENU_ID, MODULE_ID, (Action)this.getDocumentPropertiesAction(), new MenuPosition(PositionMode.BOTTOM));
    }

    @Nonnull
    public JPopupMenu getItemPopupMenu() {
        if (this.itemPopupMenu == null) {
            ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
            actionModule.registerMenu(XBUP_POPUP_MENU_ID, MODULE_ID);
            actionModule.registerMenuItem(XBUP_POPUP_MENU_ID, MODULE_ID, (Action)this.getAddItemAction(), new MenuPosition(PositionMode.TOP));
            actionModule.registerMenuItem(XBUP_POPUP_MENU_ID, MODULE_ID, (Action)this.getEditItemAction(), new MenuPosition(PositionMode.TOP));
            actionModule.registerClipboardMenuItems(XBUP_POPUP_MENU_ID, MODULE_ID, SeparationMode.AROUND);
            actionModule.registerMenuItem(XBUP_POPUP_MENU_ID, MODULE_ID, (Action)this.getImportItemAction(), new MenuPosition(PositionMode.BOTTOM));
            actionModule.registerMenuItem(XBUP_POPUP_MENU_ID, MODULE_ID, (Action)this.getExportItemAction(), new MenuPosition(PositionMode.BOTTOM));
            actionModule.registerMenuItem(XBUP_POPUP_MENU_ID, MODULE_ID, (Action)this.getItemPropertiesAction(), new MenuPosition(PositionMode.BOTTOM));
            this.itemPopupMenu = new JPopupMenu();
            actionModule.buildMenu(this.itemPopupMenu, XBUP_POPUP_MENU_ID);
        }
        return this.itemPopupMenu;
    }

    @Nonnull
    public ClientConnectionListener getClientConnectionListener() {
        return this.getStatusPanelHandler().getClientConnectionListener();
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.editorProvider.setCatalog(catalog);
        if (this.catalogBrowserAction != null) {
            this.catalogBrowserAction.setCatalog(catalog);
        }
    }

    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.editorProvider.setPluginRepository(pluginRepository);
    }
}

