/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup;

import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.viewer.XbupDocumentViewer;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class BlockEditor {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BlockEditor.class);
    private XBApplication application;
    private XBACatalog catalog;
    private XBPluginRepository pluginRepository;
    private XBTTreeNode block;
    private final XbupDocumentViewer documentViewer = new XbupDocumentViewer();

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.documentViewer.setApplication(application);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.documentViewer.setCatalog(catalog);
    }

    public XBPluginRepository getPluginRepository() {
        return this.pluginRepository;
    }

    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
        this.documentViewer.setPluginRepository(pluginRepository);
    }

    @Nonnull
    public JComponent getPanel() {
        return this.documentViewer.getComponent();
    }

    public XBTTreeNode getBlock() {
        return this.block;
    }

    public void setBlock(XBTTreeNode block) {
        this.block = block.cloneNode(true);
        this.documentViewer.setBlock((XBTBlock)block);
    }
}

