/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.preferences;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.extended.theme.CodeAreaDecorationType;
import org.exbin.bined.extended.theme.ExtendedBackgroundPaintMode;
import org.exbin.bined.swing.extended.layout.ExtendedCodeAreaDecorations;
import org.exbin.bined.swing.extended.theme.ExtendedCodeAreaThemeProfile;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.bined.options.CodeAreaThemeOptions;

@ParametersAreNonnullByDefault
public class CodeAreaThemePreferences
implements CodeAreaThemeOptions {
    public static final String PREFERENCES_THEMES_COUNT = "themeProfilesCount";
    public static final String PREFERENCES_THEME_PROFILE_SELECTED = "themeProfilesSelected";
    public static final String PREFERENCES_THEME_NAME_PREFIX = "themeProfileName.";
    public static final String PREFERENCES_THEME_VALUE_PREFIX = "theme.";
    public static final String THEME_BACKGROUND_PAINT_MODE = "backgroundPaintMode";
    public static final String THEME_PAINT_ROWPOS_BACKGROUND = "paintRowPositionBackground";
    public static final String THEME_VERTICAL_LINE_BYTE_GROUP_SIZE = "verticalLineByteGroupSize";
    public static final String THEME_DECORATION_PREFIX = "decoration.";
    public static final String THEME_DECORATION_ROW_POSITION_LINE = "decoration." + ExtendedCodeAreaDecorations.ROW_POSITION_LINE.getId();
    public static final String THEME_DECORATION_HEADER_LINE = "decoration." + ExtendedCodeAreaDecorations.HEADER_LINE.getId();
    public static final String THEME_DECORATION_SPLIT_LINE = "decoration." + ExtendedCodeAreaDecorations.SPLIT_LINE.getId();
    public static final String THEME_DECORATION_BOX_LINES = "decoration." + ExtendedCodeAreaDecorations.BOX_LINES.getId();
    public static final String THEME_DECORATION_GROUP_LINES = "decoration." + ExtendedCodeAreaDecorations.GROUP_LINES.getId();
    private final Preferences preferences;

    public CodeAreaThemePreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Nonnull
    public List<String> getThemeProfilesList() {
        ArrayList<String> profilesList = new ArrayList<String>();
        int profilesCount = this.preferences.getInt(PREFERENCES_THEMES_COUNT, 0);
        for (int i = 0; i < profilesCount; ++i) {
            String profileName = this.preferences.get(PREFERENCES_THEME_NAME_PREFIX + String.valueOf(i), "");
            profilesList.add(profileName);
        }
        return profilesList;
    }

    public void setThemeProfilesList(List<String> themesNames) {
        int themesCount = themesNames.size();
        this.preferences.putInt(PREFERENCES_THEMES_COUNT, themesCount);
        for (int i = 0; i < themesCount; ++i) {
            this.preferences.put(PREFERENCES_THEME_NAME_PREFIX + String.valueOf(i), themesNames.get(i));
        }
    }

    @Override
    public int getSelectedProfile() {
        return this.preferences.getInt(PREFERENCES_THEME_PROFILE_SELECTED, -1);
    }

    @Override
    public void setSelectedProfile(int profileIndex) {
        this.preferences.putInt(PREFERENCES_THEME_PROFILE_SELECTED, profileIndex);
    }

    @Override
    @Nonnull
    public ExtendedCodeAreaThemeProfile getThemeProfile(int profileIndex) {
        ExtendedCodeAreaThemeProfile themeProfile = new ExtendedCodeAreaThemeProfile();
        String themePrefix = PREFERENCES_THEME_VALUE_PREFIX + String.valueOf(profileIndex) + ".";
        themeProfile.setBackgroundPaintMode(ExtendedBackgroundPaintMode.valueOf((String)this.preferences.get(themePrefix + THEME_BACKGROUND_PAINT_MODE, themeProfile.getBackgroundPaintMode().name())));
        themeProfile.setPaintRowPosBackground(this.preferences.getBoolean(themePrefix + THEME_PAINT_ROWPOS_BACKGROUND, themeProfile.isPaintRowPosBackground()));
        themeProfile.setVerticalLineByteGroupSize(this.preferences.getInt(themePrefix + THEME_VERTICAL_LINE_BYTE_GROUP_SIZE, themeProfile.getVerticalLineByteGroupSize()));
        themeProfile.setDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.ROW_POSITION_LINE, this.preferences.getBoolean(themePrefix + THEME_DECORATION_ROW_POSITION_LINE, themeProfile.hasDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.ROW_POSITION_LINE)));
        themeProfile.setDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.HEADER_LINE, this.preferences.getBoolean(themePrefix + THEME_DECORATION_HEADER_LINE, themeProfile.hasDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.HEADER_LINE)));
        themeProfile.setDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.SPLIT_LINE, this.preferences.getBoolean(themePrefix + THEME_DECORATION_SPLIT_LINE, themeProfile.hasDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.SPLIT_LINE)));
        themeProfile.setDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.BOX_LINES, this.preferences.getBoolean(themePrefix + THEME_DECORATION_BOX_LINES, themeProfile.hasDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.BOX_LINES)));
        themeProfile.setDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.GROUP_LINES, this.preferences.getBoolean(themePrefix + THEME_DECORATION_GROUP_LINES, themeProfile.hasDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.GROUP_LINES)));
        return themeProfile;
    }

    @Override
    public void setThemeProfile(int profileIndex, ExtendedCodeAreaThemeProfile themeProfile) {
        String themePrefix = PREFERENCES_THEME_VALUE_PREFIX + String.valueOf(profileIndex) + ".";
        this.preferences.put(themePrefix + THEME_BACKGROUND_PAINT_MODE, themeProfile.getBackgroundPaintMode().name());
        this.preferences.putBoolean(themePrefix + THEME_PAINT_ROWPOS_BACKGROUND, themeProfile.isPaintRowPosBackground());
        this.preferences.putInt(themePrefix + THEME_VERTICAL_LINE_BYTE_GROUP_SIZE, themeProfile.getVerticalLineByteGroupSize());
        this.preferences.putBoolean(themePrefix + THEME_DECORATION_ROW_POSITION_LINE, themeProfile.hasDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.ROW_POSITION_LINE));
        this.preferences.putBoolean(themePrefix + THEME_DECORATION_HEADER_LINE, themeProfile.hasDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.HEADER_LINE));
        this.preferences.putBoolean(themePrefix + THEME_DECORATION_SPLIT_LINE, themeProfile.hasDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.SPLIT_LINE));
        this.preferences.putBoolean(themePrefix + THEME_DECORATION_BOX_LINES, themeProfile.hasDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.BOX_LINES));
        this.preferences.putBoolean(themePrefix + THEME_DECORATION_GROUP_LINES, themeProfile.hasDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.GROUP_LINES));
    }

    @Override
    public void removeThemeProfile(int profileIndex) {
        String themePrefix = PREFERENCES_THEME_VALUE_PREFIX + String.valueOf(profileIndex) + ".";
        this.preferences.remove(themePrefix + THEME_BACKGROUND_PAINT_MODE);
        this.preferences.remove(themePrefix + THEME_PAINT_ROWPOS_BACKGROUND);
        this.preferences.remove(themePrefix + THEME_VERTICAL_LINE_BYTE_GROUP_SIZE);
        this.preferences.remove(themePrefix + THEME_DECORATION_ROW_POSITION_LINE);
        this.preferences.remove(themePrefix + THEME_DECORATION_HEADER_LINE);
        this.preferences.remove(themePrefix + THEME_DECORATION_SPLIT_LINE);
        this.preferences.remove(themePrefix + THEME_DECORATION_BOX_LINES);
        this.preferences.remove(themePrefix + THEME_DECORATION_GROUP_LINES);
    }
}

