/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.exbin.bined.extended.layout.ExtendedCodeAreaLayoutProfile;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.bined.swing.extended.layout.DefaultExtendedCodeAreaLayoutProfile;
import org.exbin.framework.bined.options.gui.PreviewPanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class LayoutProfilePanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(LayoutProfilePanel.class);
    private final PreviewPanel previewPanel = new PreviewPanel();
    private JLabel doubleSpaceGroupSizeLabel;
    private JSpinner doubleSpaceGroupSizeSpinner;
    private JLabel halfSpaceGroupSizeLabel;
    private JSpinner halfSpaceGroupSizeSpinner;
    private JLabel headerBottomSpaceLabel;
    private JSpinner headerBottomSpaceSpinner;
    private JPanel headerPanel;
    private JLabel headerTopSpaceLabel;
    private JSpinner headerTopSpaceSpinner;
    private JPanel preferencesPanel;
    private JScrollPane preferencesScrollPane;
    private JLabel rowPositionLeftSpaceLabel;
    private JSpinner rowPositionLeftSpaceSpinner;
    private JPanel rowPositionPanel;
    private JLabel rowPositionRightSpaceLabel;
    private JSpinner rowPositionRightSpaceSpinner;
    private JCheckBox showHeaderCheckBox;
    private JCheckBox showRowPositionCheckBox;
    private JLabel spaceGroupSizeLabel;
    private JSpinner spaceGroupSizeSpinner;

    public LayoutProfilePanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.add((Component)this.previewPanel, "Center");
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    @Nonnull
    public DefaultExtendedCodeAreaLayoutProfile getLayoutProfile() {
        ExtCodeArea codeArea = this.previewPanel.getCodeArea();
        DefaultExtendedCodeAreaLayoutProfile layoutProfile = (DefaultExtendedCodeAreaLayoutProfile)codeArea.getLayoutProfile();
        return Objects.requireNonNull(layoutProfile).createCopy();
    }

    public void setLayoutProfile(DefaultExtendedCodeAreaLayoutProfile layoutProfile) {
        DefaultExtendedCodeAreaLayoutProfile newLayoutProfile = layoutProfile.createCopy();
        this.updateLayoutProfile(newLayoutProfile);
        this.showHeaderCheckBox.setSelected(newLayoutProfile.isShowHeader());
        this.headerTopSpaceSpinner.setValue(newLayoutProfile.getTopHeaderSpace());
        this.headerBottomSpaceSpinner.setValue(newLayoutProfile.getBottomHeaderSpace());
        this.showRowPositionCheckBox.setSelected(newLayoutProfile.isShowRowPosition());
        this.rowPositionLeftSpaceSpinner.setValue(newLayoutProfile.getLeftRowPositionSpace());
        this.rowPositionRightSpaceSpinner.setValue(newLayoutProfile.getRightRowPositionSpace());
        this.spaceGroupSizeSpinner.setValue(newLayoutProfile.getSpaceGroupSize());
        this.halfSpaceGroupSizeSpinner.setValue(newLayoutProfile.getHalfSpaceGroupSize());
        this.doubleSpaceGroupSizeSpinner.setValue(newLayoutProfile.getDoubleSpaceGroupSize());
    }

    private void initComponents() {
        this.preferencesScrollPane = new JScrollPane();
        this.preferencesPanel = new JPanel();
        this.halfSpaceGroupSizeLabel = new JLabel();
        this.rowPositionPanel = new JPanel();
        this.showRowPositionCheckBox = new JCheckBox();
        this.rowPositionLeftSpaceLabel = new JLabel();
        this.rowPositionLeftSpaceSpinner = new JSpinner();
        this.rowPositionRightSpaceLabel = new JLabel();
        this.rowPositionRightSpaceSpinner = new JSpinner();
        this.halfSpaceGroupSizeSpinner = new JSpinner();
        this.spaceGroupSizeLabel = new JLabel();
        this.spaceGroupSizeSpinner = new JSpinner();
        this.doubleSpaceGroupSizeLabel = new JLabel();
        this.doubleSpaceGroupSizeSpinner = new JSpinner();
        this.headerPanel = new JPanel();
        this.showHeaderCheckBox = new JCheckBox();
        this.headerTopSpaceLabel = new JLabel();
        this.headerTopSpaceSpinner = new JSpinner();
        this.headerBottomSpaceLabel = new JLabel();
        this.headerBottomSpaceSpinner = new JSpinner();
        this.setLayout(new BorderLayout());
        this.halfSpaceGroupSizeLabel.setText(this.resourceBundle.getString("halfSpaceGroupSizeLabel.text"));
        this.rowPositionPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("rowPositionPanel.border.title")));
        this.showRowPositionCheckBox.setText(this.resourceBundle.getString("showRowPositionCheckBox.text"));
        this.showRowPositionCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LayoutProfilePanel.this.showRowPositionCheckBoxItemStateChanged(evt);
            }
        });
        this.rowPositionLeftSpaceLabel.setText(this.resourceBundle.getString("rowPositionLeftSpaceLabel.text"));
        this.rowPositionLeftSpaceSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.rowPositionLeftSpaceSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LayoutProfilePanel.this.rowPositionLeftSpaceSpinnerStateChanged(evt);
            }
        });
        this.rowPositionRightSpaceLabel.setText(this.resourceBundle.getString("rowPositionRightSpaceLabel.text"));
        this.rowPositionRightSpaceSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.rowPositionRightSpaceSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LayoutProfilePanel.this.rowPositionRightSpaceSpinnerStateChanged(evt);
            }
        });
        GroupLayout rowPositionPanelLayout = new GroupLayout(this.rowPositionPanel);
        this.rowPositionPanel.setLayout(rowPositionPanelLayout);
        rowPositionPanelLayout.setHorizontalGroup(rowPositionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, rowPositionPanelLayout.createSequentialGroup().addContainerGap().addGroup(rowPositionPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.showRowPositionCheckBox, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, rowPositionPanelLayout.createSequentialGroup().addGroup(rowPositionPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.rowPositionLeftSpaceLabel, GroupLayout.Alignment.LEADING).addComponent(this.rowPositionRightSpaceLabel, GroupLayout.Alignment.LEADING)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.rowPositionLeftSpaceSpinner, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addComponent(this.rowPositionRightSpaceSpinner, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        rowPositionPanelLayout.setVerticalGroup(rowPositionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rowPositionPanelLayout.createSequentialGroup().addComponent(this.showRowPositionCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowPositionLeftSpaceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowPositionLeftSpaceSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowPositionRightSpaceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowPositionRightSpaceSpinner, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.halfSpaceGroupSizeSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.halfSpaceGroupSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LayoutProfilePanel.this.halfSpaceGroupSizeSpinnerStateChanged(evt);
            }
        });
        this.spaceGroupSizeLabel.setText(this.resourceBundle.getString("spaceGroupSizeLabel.text"));
        this.spaceGroupSizeSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.spaceGroupSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LayoutProfilePanel.this.spaceGroupSizeSpinnerStateChanged(evt);
            }
        });
        this.doubleSpaceGroupSizeLabel.setText(this.resourceBundle.getString("doubleSpaceGroupSizeLabel.text"));
        this.doubleSpaceGroupSizeSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.doubleSpaceGroupSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LayoutProfilePanel.this.doubleSpaceGroupSizeSpinnerStateChanged(evt);
            }
        });
        this.headerPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("headerPanel.border.title")));
        this.showHeaderCheckBox.setText(this.resourceBundle.getString("showHeaderCheckBox.text"));
        this.showHeaderCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LayoutProfilePanel.this.showHeaderCheckBoxItemStateChanged(evt);
            }
        });
        this.headerTopSpaceLabel.setText(this.resourceBundle.getString("headerTopSpaceLabel.text"));
        this.headerTopSpaceSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.headerTopSpaceSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LayoutProfilePanel.this.headerTopSpaceSpinnerStateChanged(evt);
            }
        });
        this.headerBottomSpaceLabel.setText(this.resourceBundle.getString("headerBottomSpaceLabel.text"));
        this.headerBottomSpaceSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.headerBottomSpaceSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LayoutProfilePanel.this.headerBottomSpaceSpinnerStateChanged(evt);
            }
        });
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addContainerGap().addGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.showHeaderCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.headerTopSpaceSpinner, -2, 0, Short.MAX_VALUE).addGroup(headerPanelLayout.createSequentialGroup().addGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerTopSpaceLabel).addComponent(this.headerBottomSpaceLabel)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.headerBottomSpaceSpinner, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.showHeaderCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerTopSpaceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerTopSpaceSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerBottomSpaceLabel, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerBottomSpaceSpinner, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout preferencesPanelLayout = new GroupLayout(this.preferencesPanel);
        this.preferencesPanel.setLayout(preferencesPanelLayout);
        preferencesPanelLayout.setHorizontalGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(preferencesPanelLayout.createSequentialGroup().addContainerGap().addGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(preferencesPanelLayout.createSequentialGroup().addComponent(this.halfSpaceGroupSizeLabel).addGap(51, 51, 51)).addGroup(preferencesPanelLayout.createSequentialGroup().addGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.doubleSpaceGroupSizeLabel).addComponent(this.spaceGroupSizeLabel)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, preferencesPanelLayout.createSequentialGroup().addGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.halfSpaceGroupSizeSpinner, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addComponent(this.spaceGroupSizeSpinner, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addComponent(this.doubleSpaceGroupSizeSpinner, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addComponent(this.headerPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.rowPositionPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        preferencesPanelLayout.setVerticalGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(preferencesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.headerPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowPositionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.halfSpaceGroupSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.halfSpaceGroupSizeSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spaceGroupSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spaceGroupSizeSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.doubleSpaceGroupSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.doubleSpaceGroupSizeSpinner, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.preferencesScrollPane.setViewportView(this.preferencesPanel);
        this.add((Component)this.preferencesScrollPane, "West");
    }

    private void showRowPositionCheckBoxItemStateChanged(ItemEvent evt) {
        DefaultExtendedCodeAreaLayoutProfile layoutProfile = this.getLayoutProfile();
        layoutProfile.setShowRowPosition(this.showRowPositionCheckBox.isSelected());
        this.updateLayoutProfile(layoutProfile);
    }

    private void rowPositionLeftSpaceSpinnerStateChanged(ChangeEvent evt) {
        DefaultExtendedCodeAreaLayoutProfile layoutProfile = this.getLayoutProfile();
        layoutProfile.setLeftRowPositionSpace(((Integer)this.rowPositionLeftSpaceSpinner.getValue()).intValue());
        this.updateLayoutProfile(layoutProfile);
    }

    private void rowPositionRightSpaceSpinnerStateChanged(ChangeEvent evt) {
        DefaultExtendedCodeAreaLayoutProfile layoutProfile = this.getLayoutProfile();
        layoutProfile.setRightRowPositionSpace(((Integer)this.rowPositionRightSpaceSpinner.getValue()).intValue());
        this.updateLayoutProfile(layoutProfile);
    }

    private void halfSpaceGroupSizeSpinnerStateChanged(ChangeEvent evt) {
        DefaultExtendedCodeAreaLayoutProfile layoutProfile = this.getLayoutProfile();
        layoutProfile.setHalfSpaceGroupSize(((Integer)this.halfSpaceGroupSizeSpinner.getValue()).intValue());
        this.updateLayoutProfile(layoutProfile);
    }

    private void spaceGroupSizeSpinnerStateChanged(ChangeEvent evt) {
        DefaultExtendedCodeAreaLayoutProfile layoutProfile = this.getLayoutProfile();
        layoutProfile.setSpaceGroupSize(((Integer)this.spaceGroupSizeSpinner.getValue()).intValue());
        this.updateLayoutProfile(layoutProfile);
    }

    private void doubleSpaceGroupSizeSpinnerStateChanged(ChangeEvent evt) {
        DefaultExtendedCodeAreaLayoutProfile layoutProfile = this.getLayoutProfile();
        layoutProfile.setDoubleSpaceGroupSize(((Integer)this.doubleSpaceGroupSizeSpinner.getValue()).intValue());
        this.updateLayoutProfile(layoutProfile);
    }

    private void headerBottomSpaceSpinnerStateChanged(ChangeEvent evt) {
        DefaultExtendedCodeAreaLayoutProfile layoutProfile = this.getLayoutProfile();
        layoutProfile.setBottomHeaderSpace(((Integer)this.headerBottomSpaceSpinner.getValue()).intValue());
        this.updateLayoutProfile(layoutProfile);
    }

    private void headerTopSpaceSpinnerStateChanged(ChangeEvent evt) {
        DefaultExtendedCodeAreaLayoutProfile layoutProfile = this.getLayoutProfile();
        layoutProfile.setTopHeaderSpace(((Integer)this.headerTopSpaceSpinner.getValue()).intValue());
        this.updateLayoutProfile(layoutProfile);
    }

    private void showHeaderCheckBoxItemStateChanged(ItemEvent evt) {
        DefaultExtendedCodeAreaLayoutProfile layoutProfile = this.getLayoutProfile();
        layoutProfile.setShowHeader(this.showHeaderCheckBox.isSelected());
        this.updateLayoutProfile(layoutProfile);
    }

    private void updateLayoutProfile(DefaultExtendedCodeAreaLayoutProfile layoutProfile) {
        ExtCodeArea codeArea = this.previewPanel.getCodeArea();
        codeArea.setLayoutProfile((ExtendedCodeAreaLayoutProfile)layoutProfile);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new LayoutProfilePanel());
    }
}

