/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.plaf.basic.BasicArrowButton;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.EditMode;
import org.exbin.bined.EditOperation;
import org.exbin.bined.PositionCodeType;
import org.exbin.bined.SelectionRange;
import org.exbin.framework.bined.BinaryStatusApi;
import org.exbin.framework.bined.StatusCursorPositionFormat;
import org.exbin.framework.bined.StatusDocumentSizeFormat;
import org.exbin.framework.bined.options.StatusOptions;
import org.exbin.framework.bined.options.impl.StatusOptionsImpl;
import org.exbin.framework.bined.preferences.StatusPreferences;
import org.exbin.framework.editor.text.TextEncodingStatusApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class BinaryStatusPanel
extends JPanel
implements BinaryStatusApi,
TextEncodingStatusApi {
    private static final String BR_TAG = "<br>";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BinaryStatusPanel.class);
    private StatusPreferences statusParameters;
    private StatusControlHandler statusControlHandler;
    private StatusCursorPositionFormat cursorPositionFormat = new StatusCursorPositionFormat();
    private StatusDocumentSizeFormat documentSizeFormat = new StatusDocumentSizeFormat();
    private int octalSpaceGroupSize = StatusOptionsImpl.DEFAULT_OCTAL_SPACE_GROUP_SIZE;
    private int decimalSpaceGroupSize = StatusOptionsImpl.DEFAULT_DECIMAL_SPACE_GROUP_SIZE;
    private int hexadecimalSpaceGroupSize = StatusOptionsImpl.DEFAULT_HEXADECIMAL_SPACE_GROUP_SIZE;
    private EditOperation editOperation;
    private CodeAreaCaretPosition caretPosition;
    private SelectionRange selectionRange;
    private long documentSize;
    private long initialDocumentSize;
    private JMenu cursorPositionCodeTypeMenu;
    private JLabel cursorPositionLabel;
    private ButtonGroup cursorPositionModeButtonGroup;
    private JCheckBoxMenuItem cursorPositionShowOffsetCheckBoxMenuItem;
    private JRadioButtonMenuItem decimalCursorPositionModeRadioButtonMenuItem;
    private JRadioButtonMenuItem decimalDocumentSizeModeRadioButtonMenuItem;
    private JRadioButtonMenuItem deltaMemoryModeRadioButtonMenuItem;
    private JMenu documentSizeCodeTypeMenu;
    private JMenuItem documentSizeCopyMenuItem;
    private JLabel documentSizeLabel;
    private ButtonGroup documentSizeModeButtonGroup;
    private JPopupMenu documentSizePopupMenu;
    private JCheckBoxMenuItem documentSizeShowRelativeCheckBoxMenuItem;
    private JLabel editModeLabel;
    private JLabel encodingLabel;
    private JRadioButtonMenuItem hexadecimalCursorPositionModeRadioButtonMenuItem;
    private JRadioButtonMenuItem hexadecimalDocumentSizeModeRadioButtonMenuItem;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private ButtonGroup memoryModeButtonGroup;
    private JLabel memoryModeLabel;
    private JPopupMenu memoryModePopupMenu;
    private JRadioButtonMenuItem octalCursorPositionModeRadioButtonMenuItem;
    private JRadioButtonMenuItem octalDocumentSizeModeRadioButtonMenuItem;
    private JMenuItem positionCopyMenuItem;
    private JMenuItem positionGoToMenuItem;
    private JPopupMenu positionPopupMenu;
    private JRadioButtonMenuItem ramMemoryModeRadioButtonMenuItem;

    public BinaryStatusPanel() {
        this.initComponents();
    }

    public void loadFromPreferences(StatusPreferences statusParameters) {
        this.statusParameters = statusParameters;
        this.cursorPositionFormat.setCodeType(statusParameters.getCursorPositionCodeType());
        this.cursorPositionFormat.setShowOffset(statusParameters.isCursorShowOffset());
        this.documentSizeFormat.setCodeType(statusParameters.getDocumentSizeCodeType());
        this.documentSizeFormat.setShowRelative(statusParameters.isDocumentSizeShowRelative());
        this.octalSpaceGroupSize = statusParameters.getOctalSpaceGroupSize();
        this.decimalSpaceGroupSize = statusParameters.getDecimalSpaceGroupSize();
        this.hexadecimalSpaceGroupSize = statusParameters.getHexadecimalSpaceGroupSize();
        this.updateStatus();
    }

    public void updateStatus() {
        this.updateCaretPosition();
        this.updateCursorPositionToolTip();
        this.updateDocumentSize();
        this.updateDocumentSizeToolTip();
        switch (this.cursorPositionFormat.getCodeType()) {
            case OCTAL: {
                this.octalCursorPositionModeRadioButtonMenuItem.setSelected(true);
                break;
            }
            case DECIMAL: {
                this.decimalCursorPositionModeRadioButtonMenuItem.setSelected(true);
                break;
            }
            case HEXADECIMAL: {
                this.hexadecimalCursorPositionModeRadioButtonMenuItem.setSelected(true);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)this.cursorPositionFormat.getCodeType());
            }
        }
        this.cursorPositionShowOffsetCheckBoxMenuItem.setSelected(this.cursorPositionFormat.isShowOffset());
        switch (this.documentSizeFormat.getCodeType()) {
            case OCTAL: {
                this.octalDocumentSizeModeRadioButtonMenuItem.setSelected(true);
                break;
            }
            case DECIMAL: {
                this.decimalDocumentSizeModeRadioButtonMenuItem.setSelected(true);
                break;
            }
            case HEXADECIMAL: {
                this.hexadecimalDocumentSizeModeRadioButtonMenuItem.setSelected(true);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)this.documentSizeFormat.getCodeType());
            }
        }
        this.documentSizeShowRelativeCheckBoxMenuItem.setSelected(this.documentSizeFormat.isShowRelative());
    }

    public void setStatusOptions(StatusOptions statusOptions) {
        this.cursorPositionFormat = statusOptions.getCursorPositionFormat();
        this.documentSizeFormat = statusOptions.getDocumentSizeFormat();
        this.octalSpaceGroupSize = statusOptions.getOctalSpaceGroupSize();
        this.decimalSpaceGroupSize = statusOptions.getDecimalSpaceGroupSize();
        this.hexadecimalSpaceGroupSize = statusOptions.getHexadecimalSpaceGroupSize();
        this.updateStatus();
    }

    private void initComponents() {
        this.positionPopupMenu = new JPopupMenu();
        this.cursorPositionCodeTypeMenu = new JMenu();
        this.octalCursorPositionModeRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.decimalCursorPositionModeRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.hexadecimalCursorPositionModeRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.cursorPositionShowOffsetCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.positionCopyMenuItem = new JMenuItem();
        this.positionGoToMenuItem = new JMenuItem();
        this.documentSizePopupMenu = new JPopupMenu();
        this.documentSizeCodeTypeMenu = new JMenu();
        this.octalDocumentSizeModeRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.decimalDocumentSizeModeRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.hexadecimalDocumentSizeModeRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.documentSizeShowRelativeCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.documentSizeCopyMenuItem = new JMenuItem();
        this.memoryModePopupMenu = new JPopupMenu();
        this.deltaMemoryModeRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.ramMemoryModeRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.memoryModeButtonGroup = new ButtonGroup();
        this.documentSizeModeButtonGroup = new ButtonGroup();
        this.cursorPositionModeButtonGroup = new ButtonGroup();
        this.encodingLabel = new EncodingLabel();
        this.documentSizeLabel = new JLabel();
        this.cursorPositionLabel = new JLabel();
        this.memoryModeLabel = new JLabel();
        this.editModeLabel = new JLabel();
        this.positionPopupMenu.setName("positionPopupMenu");
        this.cursorPositionCodeTypeMenu.setText(this.resourceBundle.getString("cursorPositionCodeTypeMenu.text"));
        this.cursorPositionCodeTypeMenu.setName("cursorPositionCodeTypeMenu");
        this.cursorPositionModeButtonGroup.add(this.octalCursorPositionModeRadioButtonMenuItem);
        this.octalCursorPositionModeRadioButtonMenuItem.setText(this.resourceBundle.getString("octalCursorPositionModeRadioButtonMenuItem.text"));
        this.octalCursorPositionModeRadioButtonMenuItem.setName("octalCursorPositionModeRadioButtonMenuItem");
        this.octalCursorPositionModeRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryStatusPanel.this.octalCursorPositionModeRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.cursorPositionCodeTypeMenu.add(this.octalCursorPositionModeRadioButtonMenuItem);
        this.cursorPositionModeButtonGroup.add(this.decimalCursorPositionModeRadioButtonMenuItem);
        this.decimalCursorPositionModeRadioButtonMenuItem.setSelected(true);
        this.decimalCursorPositionModeRadioButtonMenuItem.setText(this.resourceBundle.getString("decimalCursorPositionModeRadioButtonMenuItem.text"));
        this.decimalCursorPositionModeRadioButtonMenuItem.setName("decimalCursorPositionModeRadioButtonMenuItem");
        this.decimalCursorPositionModeRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryStatusPanel.this.decimalCursorPositionModeRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.cursorPositionCodeTypeMenu.add(this.decimalCursorPositionModeRadioButtonMenuItem);
        this.cursorPositionModeButtonGroup.add(this.hexadecimalCursorPositionModeRadioButtonMenuItem);
        this.hexadecimalCursorPositionModeRadioButtonMenuItem.setText(this.resourceBundle.getString("hexadecimalCursorPositionModeRadioButtonMenuItem.text"));
        this.hexadecimalCursorPositionModeRadioButtonMenuItem.setName("hexadecimalCursorPositionModeRadioButtonMenuItem");
        this.hexadecimalCursorPositionModeRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryStatusPanel.this.hexadecimalCursorPositionModeRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.cursorPositionCodeTypeMenu.add(this.hexadecimalCursorPositionModeRadioButtonMenuItem);
        this.positionPopupMenu.add(this.cursorPositionCodeTypeMenu);
        this.cursorPositionShowOffsetCheckBoxMenuItem.setSelected(true);
        this.cursorPositionShowOffsetCheckBoxMenuItem.setText(this.resourceBundle.getString("cursorPositionShowOffsetCheckBoxMenuItem.text"));
        this.cursorPositionShowOffsetCheckBoxMenuItem.setName("cursorPositionShowOffsetCheckBoxMenuItem");
        this.cursorPositionShowOffsetCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryStatusPanel.this.cursorPositionShowOffsetCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.positionPopupMenu.add(this.cursorPositionShowOffsetCheckBoxMenuItem);
        this.positionPopupMenu.add(this.jSeparator2);
        this.positionCopyMenuItem.setText(this.resourceBundle.getString("positionCopyMenuItem.text"));
        this.positionCopyMenuItem.setName("positionCopyMenuItem");
        this.positionCopyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryStatusPanel.this.positionCopyMenuItemActionPerformed(evt);
            }
        });
        this.positionPopupMenu.add(this.positionCopyMenuItem);
        this.positionGoToMenuItem.setText(this.resourceBundle.getString("positionGoToMenuItem.text"));
        this.positionGoToMenuItem.setName("positionGoToMenuItem");
        this.positionGoToMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryStatusPanel.this.positionGoToMenuItemActionPerformed(evt);
            }
        });
        this.positionPopupMenu.add(this.positionGoToMenuItem);
        this.documentSizePopupMenu.setName("documentSizePopupMenu");
        this.documentSizeCodeTypeMenu.setText(this.resourceBundle.getString("documentSizecodeTypeMenu.text"));
        this.documentSizeCodeTypeMenu.setName("documentSizeCodeTypeMenu");
        this.documentSizeModeButtonGroup.add(this.octalDocumentSizeModeRadioButtonMenuItem);
        this.octalDocumentSizeModeRadioButtonMenuItem.setText(this.resourceBundle.getString("octDocumentSizeModeRadioButtonMenuItem.text"));
        this.octalDocumentSizeModeRadioButtonMenuItem.setName("octalDocumentSizeModeRadioButtonMenuItem");
        this.octalDocumentSizeModeRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryStatusPanel.this.octalDocumentSizeModeRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.documentSizeCodeTypeMenu.add(this.octalDocumentSizeModeRadioButtonMenuItem);
        this.documentSizeModeButtonGroup.add(this.decimalDocumentSizeModeRadioButtonMenuItem);
        this.decimalDocumentSizeModeRadioButtonMenuItem.setSelected(true);
        this.decimalDocumentSizeModeRadioButtonMenuItem.setText(this.resourceBundle.getString("decDocumentSizeModeRadioButtonMenuItem.text"));
        this.decimalDocumentSizeModeRadioButtonMenuItem.setName("decimalDocumentSizeModeRadioButtonMenuItem");
        this.decimalDocumentSizeModeRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryStatusPanel.this.decimalDocumentSizeModeRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.documentSizeCodeTypeMenu.add(this.decimalDocumentSizeModeRadioButtonMenuItem);
        this.documentSizeModeButtonGroup.add(this.hexadecimalDocumentSizeModeRadioButtonMenuItem);
        this.hexadecimalDocumentSizeModeRadioButtonMenuItem.setText(this.resourceBundle.getString("hexadecimalDocumentSizeModeRadioButtonMenuItem.text"));
        this.hexadecimalDocumentSizeModeRadioButtonMenuItem.setName("hexadecimalDocumentSizeModeRadioButtonMenuItem");
        this.hexadecimalDocumentSizeModeRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryStatusPanel.this.hexadecimalDocumentSizeModeRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.documentSizeCodeTypeMenu.add(this.hexadecimalDocumentSizeModeRadioButtonMenuItem);
        this.documentSizePopupMenu.add(this.documentSizeCodeTypeMenu);
        this.documentSizeShowRelativeCheckBoxMenuItem.setSelected(true);
        this.documentSizeShowRelativeCheckBoxMenuItem.setText(this.resourceBundle.getString("showRelativeCheckBoxMenuItem.text"));
        this.documentSizeShowRelativeCheckBoxMenuItem.setName("documentSizeShowRelativeCheckBoxMenuItem");
        this.documentSizeShowRelativeCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryStatusPanel.this.documentSizeShowRelativeCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.documentSizePopupMenu.add(this.documentSizeShowRelativeCheckBoxMenuItem);
        this.documentSizePopupMenu.add(this.jSeparator1);
        this.documentSizeCopyMenuItem.setText(this.resourceBundle.getString("documentSizeCopyMenuItem.text"));
        this.documentSizeCopyMenuItem.setName("documentSizeCopyMenuItem");
        this.documentSizeCopyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryStatusPanel.this.documentSizeCopyMenuItemActionPerformed(evt);
            }
        });
        this.documentSizePopupMenu.add(this.documentSizeCopyMenuItem);
        this.memoryModePopupMenu.setName("memoryModePopupMenu");
        this.memoryModeButtonGroup.add(this.deltaMemoryModeRadioButtonMenuItem);
        this.deltaMemoryModeRadioButtonMenuItem.setSelected(true);
        this.deltaMemoryModeRadioButtonMenuItem.setText(this.resourceBundle.getString("deltaMemoryModeRadioButtonMenuItem.text"));
        this.deltaMemoryModeRadioButtonMenuItem.setName("deltaMemoryModeRadioButtonMenuItem");
        this.deltaMemoryModeRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryStatusPanel.this.deltaMemoryModeRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.memoryModePopupMenu.add(this.deltaMemoryModeRadioButtonMenuItem);
        this.memoryModeButtonGroup.add(this.ramMemoryModeRadioButtonMenuItem);
        this.ramMemoryModeRadioButtonMenuItem.setText(this.resourceBundle.getString("ramMemoryModeRadioButtonMenuItem.text"));
        this.ramMemoryModeRadioButtonMenuItem.setName("ramMemoryModeRadioButtonMenuItem");
        this.ramMemoryModeRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryStatusPanel.this.ramMemoryModeRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.memoryModePopupMenu.add(this.ramMemoryModeRadioButtonMenuItem);
        this.setName("Form");
        this.encodingLabel.setHorizontalAlignment(0);
        this.encodingLabel.setText(this.resourceBundle.getString("encodingLabel.text"));
        this.encodingLabel.setToolTipText(this.resourceBundle.getString("encodingLabel.toolTipText"));
        this.encodingLabel.setBorder(BorderFactory.createEtchedBorder());
        this.encodingLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BinaryStatusPanel.this.encodingLabelMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                BinaryStatusPanel.this.encodingLabelMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BinaryStatusPanel.this.encodingLabelMouseReleased(evt);
            }
        });
        this.documentSizeLabel.setHorizontalAlignment(0);
        this.documentSizeLabel.setText("0 (0)");
        this.documentSizeLabel.setToolTipText(this.resourceBundle.getString("documentSizeLabel.toolTipText"));
        this.documentSizeLabel.setBorder(BorderFactory.createEtchedBorder());
        this.documentSizeLabel.setComponentPopupMenu(this.documentSizePopupMenu);
        this.cursorPositionLabel.setHorizontalAlignment(0);
        this.cursorPositionLabel.setText("0:0");
        this.cursorPositionLabel.setToolTipText(this.resourceBundle.getString("cursorPositionLabel.toolTipText"));
        this.cursorPositionLabel.setBorder(BorderFactory.createEtchedBorder());
        this.cursorPositionLabel.setComponentPopupMenu(this.positionPopupMenu);
        this.cursorPositionLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BinaryStatusPanel.this.cursorPositionLabelMouseClicked(evt);
            }
        });
        this.memoryModeLabel.setHorizontalAlignment(0);
        this.memoryModeLabel.setText(this.resourceBundle.getString("memoryModeLabel.text"));
        this.memoryModeLabel.setToolTipText(this.resourceBundle.getString("memoryModeLabel.toolTipText"));
        this.memoryModeLabel.setBorder(BorderFactory.createEtchedBorder());
        this.memoryModeLabel.setComponentPopupMenu(this.memoryModePopupMenu);
        this.editModeLabel.setHorizontalAlignment(0);
        this.editModeLabel.setText("OVR");
        this.editModeLabel.setToolTipText(this.resourceBundle.getString("editModeLabel.toolTipText"));
        this.editModeLabel.setBorder(BorderFactory.createEtchedBorder());
        this.editModeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BinaryStatusPanel.this.editModeLabelMouseClicked(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(195, Short.MAX_VALUE).addComponent(this.encodingLabel, -2, 148, -2).addGap(0, 0, 0).addComponent(this.documentSizeLabel, -2, 168, -2).addGap(0, 0, 0).addComponent(this.cursorPositionLabel, -2, 168, -2).addGap(0, 0, 0).addComponent(this.memoryModeLabel, -2, 16, -2).addGap(0, 0, 0).addComponent(this.editModeLabel, -2, 35, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editModeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.documentSizeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.memoryModeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.cursorPositionLabel, -1, -1, Short.MAX_VALUE).addComponent(this.encodingLabel, -1, -1, Short.MAX_VALUE));
    }

    private void editModeLabelMouseClicked(MouseEvent evt) {
        if (this.statusControlHandler != null && evt.getButton() == 1) {
            if (this.editOperation == EditOperation.INSERT) {
                this.statusControlHandler.changeEditOperation(EditOperation.OVERWRITE);
            } else if (this.editOperation == EditOperation.OVERWRITE) {
                this.statusControlHandler.changeEditOperation(EditOperation.INSERT);
            }
        }
    }

    private void cursorPositionLabelMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() > 1) {
            this.statusControlHandler.changeCursorPosition();
        }
    }

    private void positionGoToMenuItemActionPerformed(ActionEvent evt) {
        this.statusControlHandler.changeCursorPosition();
    }

    private void positionCopyMenuItemActionPerformed(ActionEvent evt) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(this.cursorPositionLabel.getText()), null);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void documentSizeCopyMenuItemActionPerformed(ActionEvent evt) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(this.documentSizeLabel.getText()), null);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void encodingLabelMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1) {
            this.statusControlHandler.cycleEncodings();
        } else {
            this.handleEncodingPopup(evt);
        }
    }

    private void encodingLabelMousePressed(MouseEvent evt) {
        this.handleEncodingPopup(evt);
    }

    private void encodingLabelMouseReleased(MouseEvent evt) {
        this.handleEncodingPopup(evt);
    }

    private void deltaMemoryModeRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.statusControlHandler.changeMemoryMode(BinaryStatusApi.MemoryMode.DELTA_MODE);
    }

    private void ramMemoryModeRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.statusControlHandler.changeMemoryMode(BinaryStatusApi.MemoryMode.RAM_MEMORY);
    }

    private void cursorPositionShowOffsetCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.cursorPositionFormat.setShowOffset(this.cursorPositionShowOffsetCheckBoxMenuItem.isSelected());
        this.updateCaretPosition();
        this.statusParameters.setCursorShowOffset(this.cursorPositionFormat.isShowOffset());
    }

    private void documentSizeShowRelativeCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.documentSizeFormat.setShowRelative(this.documentSizeShowRelativeCheckBoxMenuItem.isSelected());
        this.updateDocumentSize();
        this.updateDocumentSizeToolTip();
        this.statusParameters.setDocumentSizeShowRelative(this.documentSizeFormat.isShowRelative());
    }

    private void octalCursorPositionModeRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.cursorPositionFormat.setCodeType(PositionCodeType.OCTAL);
        this.updateCaretPosition();
        this.statusParameters.setCursorPositionCodeType(this.cursorPositionFormat.getCodeType());
    }

    private void decimalCursorPositionModeRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.cursorPositionFormat.setCodeType(PositionCodeType.DECIMAL);
        this.updateCaretPosition();
        this.statusParameters.setCursorPositionCodeType(this.cursorPositionFormat.getCodeType());
    }

    private void hexadecimalCursorPositionModeRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.cursorPositionFormat.setCodeType(PositionCodeType.HEXADECIMAL);
        this.updateCaretPosition();
        this.statusParameters.setCursorPositionCodeType(this.cursorPositionFormat.getCodeType());
    }

    private void octalDocumentSizeModeRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.documentSizeFormat.setCodeType(PositionCodeType.OCTAL);
        this.updateDocumentSize();
        this.statusParameters.setDocumentSizeCodeType(this.documentSizeFormat.getCodeType());
    }

    private void decimalDocumentSizeModeRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.documentSizeFormat.setCodeType(PositionCodeType.DECIMAL);
        this.updateDocumentSize();
        this.statusParameters.setDocumentSizeCodeType(this.documentSizeFormat.getCodeType());
    }

    private void hexadecimalDocumentSizeModeRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.documentSizeFormat.setCodeType(PositionCodeType.HEXADECIMAL);
        this.updateDocumentSize();
        this.statusParameters.setDocumentSizeCodeType(this.documentSizeFormat.getCodeType());
    }

    private void handleEncodingPopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.statusControlHandler.encodingsPopupEncodingsMenu(evt);
        }
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new BinaryStatusPanel());
    }

    @Override
    public void setCursorPosition(CodeAreaCaretPosition caretPosition) {
        this.caretPosition = caretPosition;
        this.updateCaretPosition();
        this.updateCursorPositionToolTip();
    }

    @Override
    public void setSelectionRange(SelectionRange selectionRange) {
        this.selectionRange = selectionRange;
        this.updateCaretPosition();
        this.updateCursorPositionToolTip();
        this.updateDocumentSize();
        this.updateDocumentSizeToolTip();
    }

    @Override
    public void setCurrentDocumentSize(long documentSize, long initialDocumentSize) {
        this.documentSize = documentSize;
        this.initialDocumentSize = initialDocumentSize;
        this.updateDocumentSize();
        this.updateDocumentSizeToolTip();
    }

    @Nonnull
    public String getEncoding() {
        return this.encodingLabel.getText();
    }

    public void setEncoding(String encodingName) {
        this.encodingLabel.setText(encodingName);
    }

    @Override
    public void setEditMode(EditMode editMode, EditOperation editOperation) {
        this.editOperation = editOperation;
        block0 : switch (editMode) {
            case READ_ONLY: {
                this.editModeLabel.setText(this.resourceBundle.getString("editMode.readonly"));
                break;
            }
            case EXPANDING: 
            case CAPPED: {
                switch (editOperation) {
                    case INSERT: {
                        this.editModeLabel.setText(this.resourceBundle.getString("editMode.insert"));
                        break block0;
                    }
                    case OVERWRITE: {
                        this.editModeLabel.setText(this.resourceBundle.getString("editMode.overwrite"));
                        break block0;
                    }
                }
                throw CodeAreaUtils.getInvalidTypeException((Enum)editOperation);
            }
            case INPLACE: {
                this.editModeLabel.setText(this.resourceBundle.getString("editMode.inplace"));
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)editMode);
            }
        }
    }

    public void setStatusControlHandler(StatusControlHandler statusControlHandler) {
        this.statusControlHandler = statusControlHandler;
    }

    @Override
    public void setMemoryMode(BinaryStatusApi.MemoryMode memoryMode) {
        this.memoryModeLabel.setText(memoryMode.getDisplayChar());
        boolean enabled = memoryMode != BinaryStatusApi.MemoryMode.READ_ONLY;
        this.deltaMemoryModeRadioButtonMenuItem.setEnabled(enabled);
        this.ramMemoryModeRadioButtonMenuItem.setEnabled(enabled);
        if (memoryMode == BinaryStatusApi.MemoryMode.DELTA_MODE) {
            this.deltaMemoryModeRadioButtonMenuItem.setSelected(true);
        } else {
            this.ramMemoryModeRadioButtonMenuItem.setSelected(true);
        }
    }

    private void updateCaretPosition() {
        if (this.caretPosition == null) {
            this.cursorPositionLabel.setText("-");
        } else {
            StringBuilder labelBuilder = new StringBuilder();
            if (this.selectionRange != null && !this.selectionRange.isEmpty()) {
                long first = this.selectionRange.getFirst();
                long last = this.selectionRange.getLast();
                labelBuilder.append(String.format(this.resourceBundle.getString("caretPosition.text"), this.numberToPosition(first, this.cursorPositionFormat.getCodeType()), this.numberToPosition(last, this.cursorPositionFormat.getCodeType())));
            } else {
                labelBuilder.append(this.numberToPosition(this.caretPosition.getDataPosition(), this.cursorPositionFormat.getCodeType()));
                if (this.cursorPositionFormat.isShowOffset()) {
                    labelBuilder.append(":");
                    labelBuilder.append(this.caretPosition.getCodeOffset());
                }
            }
            this.cursorPositionLabel.setText(labelBuilder.toString());
        }
    }

    private void updateCursorPositionToolTip() {
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body>");
        if (this.caretPosition == null) {
            builder.append(this.resourceBundle.getString("cursorPositionLabel.toolTipText"));
        } else {
            String octalPrefix = this.resourceBundle.getString("codeType.octal") + ": ";
            String decimalPrefix = this.resourceBundle.getString("codeType.decimal") + ": ";
            String hexadecimalPrefix = this.resourceBundle.getString("codeType.hexadecimal") + ": ";
            if (this.selectionRange != null && !this.selectionRange.isEmpty()) {
                long first = this.selectionRange.getFirst();
                long last = this.selectionRange.getLast();
                builder.append(this.resourceBundle.getString("selectionFromLabel.toolTipText")).append(BR_TAG);
                builder.append(octalPrefix).append(this.numberToPosition(first, PositionCodeType.OCTAL)).append(BR_TAG);
                builder.append(decimalPrefix).append(this.numberToPosition(first, PositionCodeType.DECIMAL)).append(BR_TAG);
                builder.append(hexadecimalPrefix).append(this.numberToPosition(first, PositionCodeType.HEXADECIMAL)).append(BR_TAG);
                builder.append(BR_TAG);
                builder.append(this.resourceBundle.getString("selectionToLabel.toolTipText")).append(BR_TAG);
                builder.append(octalPrefix).append(this.numberToPosition(last, PositionCodeType.OCTAL)).append(BR_TAG);
                builder.append(decimalPrefix).append(this.numberToPosition(last, PositionCodeType.DECIMAL)).append(BR_TAG);
                builder.append(hexadecimalPrefix).append(this.numberToPosition(first, PositionCodeType.HEXADECIMAL)).append(BR_TAG);
            } else {
                long dataPosition = this.caretPosition.getDataPosition();
                builder.append(this.resourceBundle.getString("cursorPositionLabel.toolTipText")).append(BR_TAG);
                builder.append(octalPrefix).append(this.numberToPosition(dataPosition, PositionCodeType.OCTAL)).append(BR_TAG);
                builder.append(decimalPrefix).append(this.numberToPosition(dataPosition, PositionCodeType.DECIMAL)).append(BR_TAG);
                builder.append(hexadecimalPrefix).append(this.numberToPosition(dataPosition, PositionCodeType.HEXADECIMAL));
            }
        }
        builder.append("</body></html>");
        this.cursorPositionLabel.setToolTipText(builder.toString());
    }

    private void updateDocumentSize() {
        if (this.documentSize == -1L) {
            this.documentSizeLabel.setText(this.documentSizeFormat.isShowRelative() ? "0 (0)" : "0");
        } else {
            StringBuilder labelBuilder = new StringBuilder();
            if (this.selectionRange != null && !this.selectionRange.isEmpty()) {
                labelBuilder.append(String.format(this.resourceBundle.getString("documentSize.text"), this.numberToPosition(this.selectionRange.getLength(), this.documentSizeFormat.getCodeType()), this.numberToPosition(this.documentSize, this.documentSizeFormat.getCodeType())));
            } else {
                labelBuilder.append(this.numberToPosition(this.documentSize, this.documentSizeFormat.getCodeType()));
                if (this.documentSizeFormat.isShowRelative()) {
                    long difference = this.documentSize - this.initialDocumentSize;
                    labelBuilder.append(difference > 0L ? " (+" : " (");
                    labelBuilder.append(this.numberToPosition(difference, this.documentSizeFormat.getCodeType()));
                    labelBuilder.append(")");
                }
            }
            this.documentSizeLabel.setText(labelBuilder.toString());
        }
    }

    private void updateDocumentSizeToolTip() {
        String octalPrefix = this.resourceBundle.getString("codeType.octal") + ": ";
        String decimalPrefix = this.resourceBundle.getString("codeType.decimal") + ": ";
        String hexadecimalPrefix = this.resourceBundle.getString("codeType.hexadecimal") + ": ";
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body>");
        if (this.selectionRange != null && !this.selectionRange.isEmpty()) {
            long length = this.selectionRange.getLength();
            builder.append(this.resourceBundle.getString("selectionLengthLabel.toolTipText")).append(BR_TAG);
            builder.append(octalPrefix).append(this.numberToPosition(length, PositionCodeType.OCTAL)).append(BR_TAG);
            builder.append(decimalPrefix).append(this.numberToPosition(length, PositionCodeType.DECIMAL)).append(BR_TAG);
            builder.append(hexadecimalPrefix).append(this.numberToPosition(length, PositionCodeType.HEXADECIMAL)).append(BR_TAG);
            builder.append(BR_TAG);
        }
        builder.append(this.resourceBundle.getString("documentSizeLabel.toolTipText")).append(BR_TAG);
        builder.append(octalPrefix).append(this.numberToPosition(this.documentSize, PositionCodeType.OCTAL)).append(BR_TAG);
        builder.append(decimalPrefix).append(this.numberToPosition(this.documentSize, PositionCodeType.DECIMAL)).append(BR_TAG);
        builder.append(hexadecimalPrefix).append(this.numberToPosition(this.documentSize, PositionCodeType.HEXADECIMAL));
        builder.append("</body></html>");
        this.documentSizeLabel.setToolTipText(builder.toString());
    }

    @Nonnull
    private String numberToPosition(long value, PositionCodeType codeType) {
        int groupSize;
        if (value == 0L) {
            return "0";
        }
        int spaceGroupSize = 0;
        switch (codeType) {
            case OCTAL: {
                spaceGroupSize = this.octalSpaceGroupSize;
                break;
            }
            case DECIMAL: {
                spaceGroupSize = this.decimalSpaceGroupSize;
                break;
            }
            case HEXADECIMAL: {
                spaceGroupSize = this.hexadecimalSpaceGroupSize;
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)codeType);
            }
        }
        StringBuilder builder = new StringBuilder();
        int base = codeType.getBase();
        int n = groupSize = spaceGroupSize == 0 ? -1 : spaceGroupSize;
        for (long remainder = value > 0L ? value : -value; remainder > 0L; remainder /= (long)base) {
            if (groupSize >= 0) {
                if (groupSize == 0) {
                    builder.insert(0, ' ');
                    groupSize = spaceGroupSize - 1;
                } else {
                    --groupSize;
                }
            }
            int digit = (int)(remainder % (long)base);
            builder.insert(0, CodeAreaUtils.UPPER_HEX_CODES[digit]);
        }
        if (value < 0L) {
            builder.insert(0, "-");
        }
        return builder.toString();
    }

    private static class EncodingLabel
    extends JLabel {
        private final BasicArrowButton basicArrowButton = new BasicArrowButton(1);

        private EncodingLabel() {
        }

        @Override
        protected void paintComponent(@Nonnull Graphics g) {
            super.paintComponent(g);
            Dimension areaSize = this.getSize();
            int h = areaSize.height;
            int w = areaSize.width;
            int size = Math.min(Math.max((h - 4) / 4, 2), 10);
            this.basicArrowButton.paintTriangle(g, w - size * 2, (h - size) / 2 - h / 5, size, 1, true);
            this.basicArrowButton.paintTriangle(g, w - size * 2, (h - size) / 2 + h / 5, size, 5, true);
        }
    }

    @ParametersAreNonnullByDefault
    public static interface StatusControlHandler {
        public void changeEditOperation(EditOperation var1);

        public void changeCursorPosition();

        public void cycleEncodings();

        public void encodingsPopupEncodingsMenu(MouseEvent var1);

        public void changeMemoryMode(BinaryStatusApi.MemoryMode var1);
    }
}

