/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.action;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.capability.CodeCharactersCaseCapable;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.action.CodeAreaAction;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class HexCharactersCaseActions
implements CodeAreaAction {
    public static final String UPPER_HEX_CHARACTERS_ACTION_ID = "upperHexCharactersAction";
    public static final String LOWER_HEX_CHARACTERS_ACTION_ID = "lowerHexCharactersAction";
    public static final String HEX_CHARACTERS_CASE_RADIO_GROUP_ID = "hexCharactersCaseRadioGroup";
    private CodeAreaCore codeArea;
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private Action upperHexCharsAction;
    private Action lowerHexCharsAction;
    private CodeCharactersCase hexCharactersCase = CodeCharactersCase.UPPER;

    public void setup(XBApplication application, ResourceBundle resourceBundle) {
        this.application = application;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void updateForActiveCodeArea(@Nullable CodeAreaCore codeArea) {
        CodeCharactersCase codeCharactersCase;
        this.codeArea = codeArea;
        CodeCharactersCase codeCharactersCase2 = codeCharactersCase = codeArea != null ? ((CodeCharactersCaseCapable)codeArea).getCodeCharactersCase() : null;
        if (this.upperHexCharsAction != null) {
            this.upperHexCharsAction.setEnabled(codeArea != null);
            if (codeCharactersCase == CodeCharactersCase.UPPER) {
                this.upperHexCharsAction.putValue("SwingSelectedKey", true);
            }
        }
        if (this.lowerHexCharsAction != null) {
            this.lowerHexCharsAction.setEnabled(codeArea != null);
            if (codeCharactersCase == CodeCharactersCase.LOWER) {
                this.lowerHexCharsAction.putValue("SwingSelectedKey", true);
            }
        }
    }

    public void setHexCharactersCase(CodeCharactersCase hexCharactersCase) {
        this.hexCharactersCase = hexCharactersCase;
        ((CodeCharactersCaseCapable)this.codeArea).setCodeCharactersCase(hexCharactersCase);
    }

    @Nonnull
    public Action getUpperHexCharsAction() {
        if (this.upperHexCharsAction == null) {
            this.upperHexCharsAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HexCharactersCaseActions.this.setHexCharactersCase(CodeCharactersCase.UPPER);
                }
            };
            ActionUtils.setupAction((Action)this.upperHexCharsAction, (ResourceBundle)this.resourceBundle, (String)UPPER_HEX_CHARACTERS_ACTION_ID);
            this.upperHexCharsAction.putValue("type", ActionUtils.ActionType.RADIO);
            this.upperHexCharsAction.putValue("radioGroup", HEX_CHARACTERS_CASE_RADIO_GROUP_ID);
            this.upperHexCharsAction.putValue("SwingSelectedKey", this.hexCharactersCase == CodeCharactersCase.UPPER);
        }
        return this.upperHexCharsAction;
    }

    @Nonnull
    public Action getLowerHexCharsAction() {
        if (this.lowerHexCharsAction == null) {
            this.lowerHexCharsAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HexCharactersCaseActions.this.setHexCharactersCase(CodeCharactersCase.LOWER);
                }
            };
            ActionUtils.setupAction((Action)this.lowerHexCharsAction, (ResourceBundle)this.resourceBundle, (String)LOWER_HEX_CHARACTERS_ACTION_ID);
            this.lowerHexCharsAction.putValue("type", ActionUtils.ActionType.RADIO);
            this.lowerHexCharsAction.putValue("radioGroup", HEX_CHARACTERS_CASE_RADIO_GROUP_ID);
            this.lowerHexCharsAction.putValue("SwingSelectedKey", this.hexCharactersCase == CodeCharactersCase.LOWER);
        }
        return this.lowerHexCharsAction;
    }
}

