/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JOptionPane;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.ByteArrayEditableData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.auxiliary.binary_data.EmptyBinaryData;
import org.exbin.auxiliary.binary_data.delta.DeltaDocument;
import org.exbin.auxiliary.binary_data.delta.FileDataSource;
import org.exbin.auxiliary.binary_data.delta.SegmentsRepository;
import org.exbin.bined.operation.swing.CodeAreaUndoHandler;
import org.exbin.bined.operation.undo.BinaryDataUndoHandler;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.bined.swing.extended.color.ExtendedCodeAreaColorProfile;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.BinEdEditorComponent;
import org.exbin.framework.bined.FileHandlingMode;
import org.exbin.framework.bined.UndoHandlerWrapper;
import org.exbin.framework.bined.gui.BinEdComponentFileApi;
import org.exbin.framework.bined.gui.BinEdComponentPanel;
import org.exbin.framework.bined.preferences.BinaryEditorPreferences;
import org.exbin.framework.editor.text.TextCharsetApi;
import org.exbin.framework.editor.text.TextFontApi;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.file.api.FileType;
import org.exbin.framework.operation.undo.api.UndoFileHandler;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ClipboardActionsUpdateListener;
import org.exbin.xbup.core.type.XBData;
import org.exbin.xbup.operation.undo.XBUndoHandler;

@ParametersAreNonnullByDefault
public class BinEdFileHandler
implements FileHandler,
UndoFileHandler,
BinEdComponentFileApi,
ClipboardActionsHandler,
TextFontApi,
TextCharsetApi {
    private SegmentsRepository segmentsRepository;
    @Nonnull
    private final BinEdEditorComponent editorComponent = new BinEdEditorComponent();
    private XBUndoHandler undoHandlerWrapper;
    private int id = 0;
    private URI fileUri = null;
    private FileType fileType;
    private String title;
    private Font defaultFont;
    private ExtendedCodeAreaColorProfile defaultColors;
    private long documentOriginalSize;

    public BinEdFileHandler() {
        this.init();
    }

    public BinEdFileHandler(int id) {
        this();
        this.id = id;
    }

    private void init() {
        ExtCodeArea codeArea = this.getCodeArea();
        CodeAreaUndoHandler undoHandler = new CodeAreaUndoHandler((CodeAreaCore)this.editorComponent.getCodeArea());
        this.editorComponent.setUndoHandler((BinaryDataUndoHandler)undoHandler);
        this.defaultFont = codeArea.getCodeFont();
        this.defaultColors = (ExtendedCodeAreaColorProfile)codeArea.getColorsProfile();
    }

    public void setApplication(XBApplication application) {
        this.editorComponent.setApplication(application);
    }

    public void onInitFromPreferences(BinaryEditorPreferences preferences) {
        this.editorComponent.onInitFromPreferences(preferences);
    }

    public void loadFromFile(URI fileUri, FileType fileType) {
        this.loadFromFile(fileUri, fileType, this.getFileHandlingMode());
    }

    private void loadFromFile(URI fileUri, FileType fileType, FileHandlingMode fileHandlingMode) {
        block17: {
            this.fileType = fileType;
            File file = new File(fileUri);
            if (!file.isFile()) {
                JOptionPane.showOptionDialog(this.editorComponent.getComponentPanel(), "File not found", "Unable to load file", -1, 0, null, null, null);
                return;
            }
            try {
                BinaryData oldData = this.editorComponent.getContentData();
                if (fileHandlingMode == FileHandlingMode.DELTA) {
                    FileDataSource openFileSource = this.segmentsRepository.openFileSource(file);
                    DeltaDocument document = this.segmentsRepository.createDocument(openFileSource);
                    this.editorComponent.setContentData((BinaryData)document);
                    this.fileUri = fileUri;
                    oldData.dispose();
                    break block17;
                }
                try (FileInputStream fileStream = new FileInputStream(file);){
                    BinaryData data = this.editorComponent.getContentData();
                    if (!(data instanceof XBData)) {
                        data = new XBData();
                        oldData.dispose();
                    }
                    ((EditableBinaryData)data).loadFromStream((InputStream)fileStream);
                    this.editorComponent.setContentData(data);
                    this.fileUri = fileUri;
                }
            }
            catch (IOException ex) {
                Logger.getLogger(BinEdFileHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.undoHandlerWrapper.clear();
        this.fileSync();
    }

    public void saveToFile(URI fileUri, FileType fileType) {
        block17: {
            File file = new File(fileUri);
            try {
                BinaryData contentData = this.editorComponent.getContentData();
                if (contentData instanceof EmptyBinaryData) {
                    this.clearFile();
                    contentData = this.editorComponent.getContentData();
                }
                if (contentData instanceof DeltaDocument) {
                    DeltaDocument document = (DeltaDocument)contentData;
                    FileDataSource fileSource = document.getFileSource();
                    if (fileSource == null || !file.equals(fileSource.getFile())) {
                        fileSource = this.segmentsRepository.openFileSource(file);
                        document.setFileSource(fileSource);
                    }
                    this.segmentsRepository.saveDocument(document);
                    this.fileUri = fileUri;
                    break block17;
                }
                try (FileOutputStream outputStream = new FileOutputStream(file);){
                    Objects.requireNonNull(contentData).saveToStream((OutputStream)outputStream);
                    this.fileUri = fileUri;
                }
            }
            catch (IOException ex) {
                Logger.getLogger(BinEdFileHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.fileSync();
    }

    private void fileSync() {
        this.documentOriginalSize = this.getCodeArea().getDataSize();
        this.undoHandlerWrapper.setSyncPoint();
    }

    public void loadFromStream(InputStream stream) throws IOException {
        BinaryData contentData = this.editorComponent.getContentData();
        if (!(contentData instanceof EditableBinaryData)) {
            contentData = new ByteArrayEditableData();
        }
        EditableBinaryData data = Objects.requireNonNull((EditableBinaryData)contentData);
        data.loadFromStream(stream);
        this.editorComponent.setContentData(contentData);
    }

    public void loadFromStream(InputStream stream, long dataSize) throws IOException {
        BinaryData contentData = this.editorComponent.getContentData();
        if (!(contentData instanceof EditableBinaryData)) {
            contentData = new ByteArrayEditableData();
        }
        EditableBinaryData data = Objects.requireNonNull((EditableBinaryData)contentData);
        data.clear();
        data.insert(0L, stream, dataSize);
        this.editorComponent.setContentData(contentData);
    }

    public void saveToStream(OutputStream stream) throws IOException {
        BinaryData data = Objects.requireNonNull(this.editorComponent.getContentData());
        data.saveToStream(stream);
    }

    @Nonnull
    public Optional<URI> getFileUri() {
        return Optional.ofNullable(this.fileUri);
    }

    public void clearFile() {
        FileHandlingMode fileHandlingMode = this.getFileHandlingMode();
        this.closeData();
        ExtCodeArea codeArea = this.editorComponent.getCodeArea();
        BinaryData data = codeArea.getContentData();
        if (data instanceof DeltaDocument) {
            this.segmentsRepository.dropDocument(Objects.requireNonNull((DeltaDocument)codeArea.getContentData()));
        }
        this.setNewData(fileHandlingMode);
        this.fileUri = null;
        if (this.undoHandlerWrapper != null) {
            this.undoHandlerWrapper.clear();
        }
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public String getTitle() {
        if (this.fileUri != null) {
            String path = this.fileUri.getPath();
            int lastSegment = path.lastIndexOf("/");
            String fileName = lastSegment < 0 ? path : path.substring(lastSegment + 1);
            return fileName == null ? "" : fileName;
        }
        return this.title == null ? "" : this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Nonnull
    public String getWindowTitle(String windowTitle) {
        if (this.fileUri != null) {
            String path = this.fileUri.getPath();
            int lastIndexOf = path.lastIndexOf("/");
            if (lastIndexOf < 0) {
                return path + " - " + windowTitle;
            }
            return path.substring(lastIndexOf + 1) + " - " + windowTitle;
        }
        return windowTitle;
    }

    public long getDocumentOriginalSize() {
        return this.documentOriginalSize;
    }

    public void saveFile() {
        ExtCodeArea codeArea = this.editorComponent.getCodeArea();
        BinaryData data = codeArea.getContentData();
        if (data instanceof DeltaDocument) {
            try {
                this.segmentsRepository.saveDocument((DeltaDocument)data);
            }
            catch (IOException ex) {
                Logger.getLogger(BinEdFileHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            File file = new File(this.fileUri);
            try (FileOutputStream stream = new FileOutputStream(file);){
                BinaryData contentData = codeArea.getContentData();
                contentData.saveToStream((OutputStream)stream);
                stream.flush();
            }
            catch (IOException ex) {
                Logger.getLogger(BinEdFileHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void reloadFile() {
        if (this.fileUri != null) {
            this.loadFromFile(this.fileUri, this.fileType, this.getFileHandlingMode());
        }
    }

    @Override
    public void closeData() {
        ExtCodeArea codeArea = this.editorComponent.getCodeArea();
        BinaryData data = codeArea.getContentData();
        this.editorComponent.setContentData((BinaryData)EmptyBinaryData.INSTANCE);
        if (data instanceof DeltaDocument) {
            FileDataSource fileSource = ((DeltaDocument)data).getFileSource();
            data.dispose();
            if (fileSource != null) {
                this.segmentsRepository.detachFileSource(fileSource);
                this.segmentsRepository.closeFileSource(fileSource);
            }
        } else {
            data.dispose();
        }
    }

    @Override
    public void saveDocument() {
        if (this.fileUri == null) {
            return;
        }
        this.saveFile();
    }

    @Override
    public void switchFileHandlingMode(FileHandlingMode handlingMode) {
        FileHandlingMode oldFileHandlingMode = this.getFileHandlingMode();
        ExtCodeArea codeArea = this.editorComponent.getCodeArea();
        if (handlingMode != oldFileHandlingMode) {
            if (this.fileUri != null) {
                this.loadFromFile(this.fileUri, null, handlingMode);
            } else {
                BinaryData oldData = codeArea.getContentData();
                if (oldData instanceof DeltaDocument) {
                    XBData data = new XBData();
                    data.insert(0L, oldData);
                    this.editorComponent.setContentData((BinaryData)data);
                } else {
                    DeltaDocument document = this.segmentsRepository.createDocument();
                    document.insert(0L, oldData);
                    this.editorComponent.setContentData((BinaryData)document);
                }
                if (this.undoHandlerWrapper != null) {
                    this.undoHandlerWrapper.clear();
                }
                oldData.dispose();
            }
        }
    }

    @Nonnull
    public FileHandlingMode getFileHandlingMode() {
        return this.getCodeArea().getContentData() instanceof DeltaDocument ? FileHandlingMode.DELTA : FileHandlingMode.MEMORY;
    }

    @Nonnull
    public BinEdComponentPanel getComponent() {
        return this.editorComponent.getComponentPanel();
    }

    @Nonnull
    public ExtCodeArea getCodeArea() {
        return this.editorComponent.getCodeArea();
    }

    @Nonnull
    public Optional<FileType> getFileType() {
        return Optional.empty();
    }

    public void setFileType(FileType fileType) {
    }

    public boolean isModified() {
        return this.undoHandlerWrapper.getCommandPosition() != this.undoHandlerWrapper.getSyncPoint();
    }

    public void setNewData(FileHandlingMode fileHandlingMode) {
        if (fileHandlingMode == FileHandlingMode.DELTA) {
            this.editorComponent.setContentData((BinaryData)this.segmentsRepository.createDocument());
        } else {
            this.editorComponent.setContentData((BinaryData)new XBData());
        }
    }

    public void setSegmentsRepository(SegmentsRepository segmentsRepository) {
        this.segmentsRepository = segmentsRepository;
    }

    public void requestFocus() {
        this.editorComponent.getCodeArea().requestFocus();
    }

    @Nonnull
    public XBUndoHandler getUndoHandler() {
        if (this.undoHandlerWrapper == null) {
            this.undoHandlerWrapper = new UndoHandlerWrapper();
            ((UndoHandlerWrapper)this.undoHandlerWrapper).setHandler(this.editorComponent.getUndoHandler().orElse(null));
        }
        return this.undoHandlerWrapper;
    }

    @Nonnull
    public Optional<BinaryDataUndoHandler> getCodeAreaUndoHandler() {
        return this.editorComponent.getUndoHandler();
    }

    @Override
    public boolean isSaveSupported() {
        return true;
    }

    public void performCut() {
        this.getCodeArea().cut();
    }

    public void performCopy() {
        this.getCodeArea().copy();
    }

    public void performPaste() {
        this.getCodeArea().paste();
    }

    public void performDelete() {
        this.getCodeArea().delete();
    }

    public void performSelectAll() {
        this.getCodeArea().selectAll();
    }

    public boolean isSelection() {
        return this.getCodeArea().hasSelection();
    }

    public boolean isEditable() {
        return this.getCodeArea().isEditable();
    }

    public boolean canSelectAll() {
        return true;
    }

    public boolean canPaste() {
        return this.getCodeArea().canPaste();
    }

    public boolean canDelete() {
        return true;
    }

    public void setCurrentFont(Font font) {
        this.getCodeArea().setCodeFont(font);
    }

    @Nonnull
    public Font getCurrentFont() {
        return this.getCodeArea().getCodeFont();
    }

    @Nonnull
    public Font getDefaultFont() {
        return this.defaultFont;
    }

    @Nonnull
    public ExtendedCodeAreaColorProfile getDefaultColors() {
        return this.defaultColors;
    }

    @Nonnull
    public Charset getCharset() {
        return this.getCodeArea().getCharset();
    }

    public void setCharset(Charset charset) {
        this.getCodeArea().setCharset(charset);
    }

    public void setUpdateListener(ClipboardActionsUpdateListener updateListener) {
    }
}

