/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.operation.basic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBEditableBlock;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTEditableBlock;
import org.exbin.xbup.core.block.XBTEditableDocument;
import org.exbin.xbup.core.parser.XBParserMode;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.basic.XBListener;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.parser.token.event.XBEventReader;
import org.exbin.xbup.core.parser.token.event.XBEventWriter;
import org.exbin.xbup.core.parser.token.event.convert.XBEventListenerToListener;
import org.exbin.xbup.core.parser.token.event.convert.XBListenerToEventListener;
import org.exbin.xbup.core.serial.XBPSerialReader;
import org.exbin.xbup.core.serial.XBPSerialWriter;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBSerializationMode;
import org.exbin.xbup.core.type.XBData;
import org.exbin.xbup.operation.Operation;
import org.exbin.xbup.operation.XBTDocOperation;
import org.exbin.xbup.operation.basic.XBBasicOperationType;
import org.exbin.xbup.operation.basic.XBTDeleteBlockOperation;
import org.exbin.xbup.parser_tree.XBTBlockToXBBlock;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.parser_tree.XBTreeReader;
import org.exbin.xbup.parser_tree.XBTreeWriter;

@ParametersAreNonnullByDefault
public class XBTAddBlockOperation
extends XBTDocOperation {
    public XBTAddBlockOperation(XBTEditableDocument document, @Nullable Long parentPosition, int childIndex, XBTEditableBlock newNode) {
        super(document);
        OutputStream dataOutputStream = this.data.getDataOutputStream();
        XBPSerialWriter writer = new XBPSerialWriter(dataOutputStream);
        Serializator serializator = new Serializator(parentPosition == null ? 0L : parentPosition + 1L, childIndex, newNode);
        writer.write((XBSerializable)serializator);
    }

    @Override
    @Nonnull
    public XBBasicOperationType getBasicType() {
        return XBBasicOperationType.ADD_BLOCK;
    }

    @Override
    public void execute() throws Exception {
        this.execute(false);
    }

    @Override
    @Nonnull
    public Optional<Operation> executeWithUndo() throws Exception {
        return this.execute(true);
    }

    @Nonnull
    private Optional<Operation> execute(boolean withUndo) {
        InputStream dataInputStream = this.getData().getDataInputStream();
        XBPSerialReader reader = new XBPSerialReader(dataInputStream);
        Serializator serial = new Serializator();
        try {
            reader.read((XBSerializable)serial);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBTAddBlockOperation.class.getName()).log(Level.SEVERE, null, ex);
            throw new IllegalStateException("Unable to process data");
        }
        if (serial.parentPosition == 0L) {
            if (!this.document.getRootBlock().isPresent()) {
                this.document.setRootBlock((XBTBlock)serial.newNode);
            }
        } else {
            XBTEditableBlock parentNode = this.document.findBlockByIndex(serial.parentPosition - 1L).orElse(null);
            if (parentNode != null) {
                if (serial.childIndex < parentNode.getChildrenCount()) {
                    parentNode.setChildrenCount(parentNode.getChildrenCount() + 1);
                    for (int i = parentNode.getChildrenCount() - 1; i > serial.childIndex; --i) {
                        parentNode.setChildAt(parentNode.getChildAt(i - 1), i);
                    }
                }
                parentNode.setChildAt((XBTBlock)serial.newNode, serial.childIndex);
            }
            serial.newNode.setParent((XBTBlock)parentNode);
        }
        if (withUndo) {
            XBTDeleteBlockOperation undoOperation;
            if (serial.parentPosition > 0L) {
                XBTEditableBlock parentNode = (XBTEditableBlock)this.document.findBlockByIndex(serial.parentPosition - 1L).get();
                XBTBlock node = parentNode.getChildAt(serial.childIndex);
                undoOperation = new XBTDeleteBlockOperation(this.document, node);
            } else {
                undoOperation = new XBTDeleteBlockOperation(this.document, (XBTBlock)this.document.getRootBlock().get());
            }
            return Optional.of(undoOperation);
        }
        return Optional.empty();
    }

    @ParametersAreNonnullByDefault
    private class Serializator
    implements XBPSequenceSerializable {
        private long parentPosition;
        private int childIndex;
        private XBTEditableBlock newNode;

        private Serializator() {
        }

        public Serializator(long parentPosition, int childIndex, XBTEditableBlock newNode) {
            this.parentPosition = parentPosition;
            this.childIndex = childIndex;
            this.newNode = newNode;
        }

        public void serializeXB(XBPSequenceSerialHandler serializationHandler) throws XBProcessingException, IOException {
            serializationHandler.begin();
            serializationHandler.matchType();
            if (serializationHandler.getSerializationMode() == XBSerializationMode.PULL) {
                this.parentPosition = serializationHandler.pullLongAttribute();
                this.childIndex = serializationHandler.pullIntAttribute();
                this.newNode = new XBTTreeNode();
                serializationHandler.consist((XBSerializable)new XBPSequenceSerializable(){

                    public void serializeXB(XBPSequenceSerialHandler serializationHandler) throws XBProcessingException, IOException {
                        serializationHandler.begin();
                        XBData data = new XBData();
                        data.loadFromStream(serializationHandler.pullData());
                        serializationHandler.end();
                        XBTreeReader treeReader = new XBTreeReader((XBEditableBlock)new XBTBlockToXBBlock((XBTBlock)Serializator.this.newNode));
                        XBEventReader reader = new XBEventReader(data.getDataInputStream(), XBParserMode.SKIP_TAIL);
                        reader.attachXBEventListener((XBEventListener)new XBListenerToEventListener((XBListener)treeReader));
                        reader.read();
                        reader.close();
                    }
                });
            } else {
                serializationHandler.putAttribute(this.parentPosition);
                serializationHandler.putAttribute(this.childIndex);
                serializationHandler.consist((XBSerializable)new XBPSequenceSerializable(){

                    public void serializeXB(XBPSequenceSerialHandler serializationHandler) throws XBProcessingException, IOException {
                        XBData data = new XBData();
                        XBTreeWriter treeWriter = new XBTreeWriter((XBBlock)new XBTBlockToXBBlock((XBTBlock)Serializator.this.newNode));
                        XBEventWriter writer = new XBEventWriter(data.getDataOutputStream());
                        treeWriter.attachXBListener((XBListener)new XBEventListenerToListener((XBEventListener)writer));
                        serializationHandler.begin();
                        serializationHandler.putData(data.getDataInputStream());
                        serializationHandler.end();
                    }
                });
            }
            serializationHandler.end();
        }
    }
}

