/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.service.skeleton;

import java.io.IOException;
import java.util.Optional;
import org.exbin.xbup.catalog.XBAECatalog;
import org.exbin.xbup.catalog.entity.XBEXBlockUi;
import org.exbin.xbup.catalog.entity.XBEXPlugUi;
import org.exbin.xbup.client.stub.XBPXUiStub;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBTEmptyBlock;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.XBPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCBlockRev;
import org.exbin.xbup.core.catalog.base.XBCXPlugin;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;
import org.exbin.xbup.core.catalog.base.service.XBCXPlugService;
import org.exbin.xbup.core.catalog.base.service.XBCXUiService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.remote.XBExecutable;
import org.exbin.xbup.core.remote.XBMultiProcedure;
import org.exbin.xbup.core.remote.XBServiceServer;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.stream.XBInput;
import org.exbin.xbup.core.stream.XBOutput;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.service.skeleton.XBPCatalogSkeleton;

public class XBPXUiSkeleton
implements XBPCatalogSkeleton {
    private XBAECatalog catalog;

    public XBPXUiSkeleton(XBAECatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public void registerProcedures(XBServiceServer remoteServer) {
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXUiStub.UIPLUGIN_PLUGIN_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCXUiService uiService = (XBCXUiService)XBPXUiSkeleton.this.catalog.getCatalogService(XBCXUiService.class);
                XBEXPlugUi plugLine = (XBEXPlugUi)uiService.findPlugUiById(index.getNaturalLong());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(plugLine == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(plugLine.getPlugin().getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXUiStub.METHODINDEX_PLUGIN_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCXUiService lineService = (XBCXUiService)XBPXUiSkeleton.this.catalog.getCatalogService(XBCXUiService.class);
                XBEXPlugUi plugLine = (XBEXPlugUi)lineService.findPlugUiById(index.getNaturalLong());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(plugLine == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(plugLine.getMethodIndex())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXUiStub.REV_UI_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCXUiService uiService = (XBCXUiService)XBPXUiSkeleton.this.catalog.getCatalogService(XBCXUiService.class);
                XBEXBlockUi blockUi = (XBEXBlockUi)uiService.findById(index.getNaturalLong());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(blockUi == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(blockUi.getBlockRev().getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXUiStub.PLUGIN_UI_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCXUiService uiService = (XBCXUiService)XBPXUiSkeleton.this.catalog.getCatalogService(XBCXUiService.class);
                XBEXBlockUi blockUi = (XBEXBlockUi)uiService.findById(index.getNaturalLong());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(blockUi == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(blockUi.getUi().getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXUiStub.PRIORITY_UI_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCXUiService uiService = (XBCXUiService)XBPXUiSkeleton.this.catalog.getCatalogService(XBCXUiService.class);
                XBEXBlockUi blockUi = (XBEXBlockUi)uiService.findById(index.getNaturalLong());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(blockUi == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(blockUi.getPriority())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXUiStub.UISCOUNT_UI_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                provider.end();
                XBCXUiService uiService = (XBCXUiService)XBPXUiSkeleton.this.catalog.getCatalogService(XBCXUiService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(uiService.getItemsCount()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXUiStub.REVUI_UI_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                XBAttribute type = provider.pullAttribute();
                XBAttribute priority = provider.pullAttribute();
                provider.end();
                XBCXUiService uiService = (XBCXUiService)XBPXUiSkeleton.this.catalog.getCatalogService(XBCXUiService.class);
                XBCRevService revService = (XBCRevService)XBPXUiSkeleton.this.catalog.getCatalogService(XBCRevService.class);
                Optional rev = revService.getItem(index.getNaturalLong());
                XBEXBlockUi blockUi = rev.isPresent() ? (XBEXBlockUi)uiService.findUiByPR((XBCBlockRev)rev.get(), XBPlugUiType.findByDbIndex((int)type.getNaturalInt()), priority.getNaturalLong()) : null;
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(blockUi == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(blockUi.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXUiStub.PLUGUISCOUNT_UI_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                provider.end();
                XBCXUiService uiService = (XBCXUiService)XBPXUiSkeleton.this.catalog.getCatalogService(XBCXUiService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(uiService.getAllPlugUisCount()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXUiStub.PLUGUI_UI_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                XBAttribute type = provider.pullAttribute();
                XBAttribute lineOrder = provider.pullAttribute();
                provider.end();
                XBCXUiService uiService = (XBCXUiService)XBPXUiSkeleton.this.catalog.getCatalogService(XBCXUiService.class);
                XBCXPlugService pluginService = (XBCXPlugService)XBPXUiSkeleton.this.catalog.getCatalogService(XBCXPlugService.class);
                XBCXPlugin plugin = pluginService.findById(index.getNaturalLong());
                XBEXPlugUi plugUi = plugin == null ? null : (XBEXPlugUi)uiService.getPlugUi(plugin, XBPlugUiType.findByDbIndex((int)type.getNaturalInt()), lineOrder.getNaturalLong());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(plugUi == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(plugUi.getId())));
            }
        });
    }

    @Override
    public void setCatalog(XBAECatalog catalog) {
        this.catalog = catalog;
    }
}

