/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.service;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.catalog.XBAECatalog;
import org.exbin.xbup.client.update.XBCUpdateHandler;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.service.XBCRootService;
import org.exbin.xbup.service.XBTCPServiceServer;
import org.exbin.xbup.service.skeleton.XBPCatalogSkeleton;
import org.exbin.xbup.service.skeleton.XBPInfoSkeleton;
import org.exbin.xbup.service.skeleton.XBPItemSkeleton;
import org.exbin.xbup.service.skeleton.XBPNodeSkeleton;
import org.exbin.xbup.service.skeleton.XBPRevSkeleton;
import org.exbin.xbup.service.skeleton.XBPRootSkeleton;
import org.exbin.xbup.service.skeleton.XBPServiceSkeleton;
import org.exbin.xbup.service.skeleton.XBPSpecSkeleton;
import org.exbin.xbup.service.skeleton.XBPXDescSkeleton;
import org.exbin.xbup.service.skeleton.XBPXFileSkeleton;
import org.exbin.xbup.service.skeleton.XBPXHDocSkeleton;
import org.exbin.xbup.service.skeleton.XBPXIconSkeleton;
import org.exbin.xbup.service.skeleton.XBPXLangSkeleton;
import org.exbin.xbup.service.skeleton.XBPXNameSkeleton;
import org.exbin.xbup.service.skeleton.XBPXPlugSkeleton;
import org.exbin.xbup.service.skeleton.XBPXStriSkeleton;
import org.exbin.xbup.service.skeleton.XBPXUiSkeleton;

@ParametersAreNonnullByDefault
public class XBCatalogNetServiceServer
extends XBTCPServiceServer {
    private static final String LOG_BUNDLE = "sun.util.logging.resources.logging";
    public static final Level XB_SERVICE_STATUS = new XBServiceStatus("XB_SERVICE_STATUS", 758, "sun.util.logging.resources.logging");
    private final ResourceBundle resourceBundle = ResourceBundle.getBundle("org/exbin/xbup/service/messages");
    private XBCUpdateHandler updateHandler = null;
    private final List<XBPCatalogSkeleton> skeletons = new ArrayList<XBPCatalogSkeleton>();

    public XBCatalogNetServiceServer() {
        new XBPServiceSkeleton(this).registerProcedures(this);
    }

    @Override
    public void replaceCatalog() {
        super.replaceCatalog();
        XBAECatalog aeCatalog = (XBAECatalog)this.catalog;
        if (this.skeletons.isEmpty()) {
            XBCatalogNetServiceServer server = this;
            this.skeletons.add(new XBPItemSkeleton(aeCatalog));
            this.skeletons.add(new XBPRootSkeleton(aeCatalog));
            this.skeletons.add(new XBPNodeSkeleton(aeCatalog));
            this.skeletons.add(new XBPSpecSkeleton(aeCatalog));
            this.skeletons.add(new XBPRevSkeleton(aeCatalog));
            this.skeletons.add(new XBPXLangSkeleton(aeCatalog));
            this.skeletons.add(new XBPXNameSkeleton(aeCatalog));
            this.skeletons.add(new XBPXDescSkeleton(aeCatalog));
            this.skeletons.add(new XBPInfoSkeleton(aeCatalog));
            this.skeletons.add(new XBPXFileSkeleton(aeCatalog));
            this.skeletons.add(new XBPXIconSkeleton(aeCatalog));
            this.skeletons.add(new XBPXPlugSkeleton(aeCatalog));
            this.skeletons.add(new XBPXStriSkeleton(aeCatalog));
            this.skeletons.add(new XBPXUiSkeleton(aeCatalog));
            this.skeletons.add(new XBPXHDocSkeleton(aeCatalog));
            for (XBPCatalogSkeleton skeleton : this.skeletons) {
                skeleton.registerProcedures(server);
            }
        } else {
            for (XBPCatalogSkeleton skeleton : this.skeletons) {
                skeleton.setCatalog(aeCatalog);
            }
        }
    }

    public void performStop() {
        Logger.getLogger(XBCatalogNetServiceServer.class.getName()).log(XB_SERVICE_STATUS, this.resourceBundle.getString("stop_service"));
        this.setStop(true);
    }

    @Nonnull
    public String getVersion() {
        return this.resourceBundle.getString("Application.version");
    }

    public int login(String user, char[] password) {
        return 0;
    }

    public boolean shallUpdate(XBACatalog checkedCatalog) {
        XBCRootService rootService = (XBCRootService)checkedCatalog.getCatalogService(XBCRootService.class);
        return !rootService.isMainPresent();
    }

    public void update() {
        ((XBAECatalog)this.catalog).clear();
        ((XBAECatalog)this.catalog).getUpdateHandler().performUpdate();
    }

    @Nullable
    public XBCUpdateHandler getUpdateHandler() {
        return this.updateHandler;
    }

    @ParametersAreNonnullByDefault
    public static class XBServiceLogHandler
    extends Handler {
        boolean verboseMode;

        public XBServiceLogHandler(boolean verboseMode) {
            this.verboseMode = verboseMode;
        }

        @Override
        public void publish(LogRecord record) {
            if (record.getLevel() == XB_SERVICE_STATUS && this.verboseMode) {
                if ("".equals(record.getMessage())) {
                    System.out.println();
                } else {
                    System.out.println("STATUS: " + record.getMessage());
                }
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    @ParametersAreNonnullByDefault
    private static class XBServiceStatus
    extends Level {
        public XBServiceStatus(String string, int value, String defaultBundle) {
            super(string, value, defaultBundle);
        }
    }
}

