/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.tool.xbmanager;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.exbin.framework.XBBaseApplication;
import org.exbin.framework.about.api.AboutModuleApi;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplicationModuleRepository;
import org.exbin.framework.frame.api.ApplicationFrameHandler;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.help.online.api.HelpOnlineModuleApi;
import org.exbin.framework.options.api.OptionsModuleApi;
import org.exbin.framework.update.api.UpdateModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.xbup.catalog.XbupCatalogModule;
import org.exbin.framework.xbup.service.XbupServiceModule;
import org.exbin.framework.xbup.service.gui.ServiceManagerPanel;
import org.exbin.xbup.core.parser.basic.XBHead;

@ParametersAreNonnullByDefault
public class XBManager {
    private XBManager() {
    }

    public static void main(String[] args) {
        block9: {
            ResourceBundle bundle = LanguageUtils.getResourceBundleByClass(XBManager.class);
            try {
                Options opt = new Options();
                opt.addOption("h", "help", false, bundle.getString("cl_option_help"));
                opt.addOption("v", false, bundle.getString("cl_option_verbose"));
                opt.addOption("dev", false, bundle.getString("cl_option_dev"));
                BasicParser parser = new BasicParser();
                CommandLine cl = parser.parse(opt, args);
                if (cl.hasOption('h')) {
                    HelpFormatter f = new HelpFormatter();
                    f.printHelp(bundle.getString("cl_syntax"), opt);
                    break block9;
                }
                boolean verboseMode = cl.hasOption("v");
                boolean devMode = cl.hasOption("dev");
                Logger logger = Logger.getLogger("");
                try {
                    logger.setLevel(Level.ALL);
                    logger.addHandler((Handler)new XBHead.XBLogHandler(verboseMode));
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                XBBaseApplication app = new XBBaseApplication();
                app.setAppDirectory(XBManager.class);
                Preferences preferences = app.createPreferences(XBManager.class);
                app.setAppBundle(bundle, LanguageUtils.getResourceBaseNameBundleByClass(XBManager.class));
                XBApplicationModuleRepository moduleRepository = app.getModuleRepository();
                moduleRepository.addClassPathModules();
                moduleRepository.addModulesFromManifest(XBManager.class);
                moduleRepository.loadModulesFromPath(new File("plugins").toURI());
                moduleRepository.initModules();
                app.init();
                FrameModuleApi frameModule = (FrameModuleApi)moduleRepository.getModuleByInterface(FrameModuleApi.class);
                ActionModuleApi actionModule = (ActionModuleApi)moduleRepository.getModuleByInterface(ActionModuleApi.class);
                AboutModuleApi aboutModule = (AboutModuleApi)moduleRepository.getModuleByInterface(AboutModuleApi.class);
                HelpOnlineModuleApi helpOnlineModule = (HelpOnlineModuleApi)moduleRepository.getModuleByInterface(HelpOnlineModuleApi.class);
                OptionsModuleApi optionsModule = (OptionsModuleApi)moduleRepository.getModuleByInterface(OptionsModuleApi.class);
                XbupCatalogModule xbupCatalogModule = (XbupCatalogModule)moduleRepository.getModuleByInterface(XbupCatalogModule.class);
                XbupServiceModule xbupServiceModule = (XbupServiceModule)moduleRepository.getModuleByInterface(XbupServiceModule.class);
                UpdateModuleApi updateModule = (UpdateModuleApi)moduleRepository.getModuleByInterface(UpdateModuleApi.class);
                frameModule.createMainMenu();
                try {
                    updateModule.setUpdateUrl(new URL(bundle.getString("update_url")));
                    updateModule.setUpdateDownloadUrl(new URL(bundle.getString("update_download_url")));
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(XBManager.class.getName()).log(Level.SEVERE, null, ex);
                }
                updateModule.registerDefaultMenuItem();
                aboutModule.registerDefaultMenuItem();
                try {
                    helpOnlineModule.setOnlineHelpUrl(new URL(bundle.getString("online_help_url")));
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(XBManager.class.getName()).log(Level.SEVERE, null, ex);
                }
                helpOnlineModule.registerOnlineHelpMenu();
                frameModule.registerExitAction();
                frameModule.registerStatusBarVisibilityActions();
                actionModule.registerMenuClipboardActions();
                optionsModule.registerMenuAction();
                updateModule.registerOptionsPanels();
                ApplicationFrameHandler frameHandler = frameModule.getFrameHandler();
                xbupServiceModule.setPreferences(preferences);
                ServiceManagerPanel servicePanel = xbupServiceModule.getServicePanel();
                frameHandler.setMainPanel((Component)servicePanel);
                frameHandler.setDefaultSize(new Dimension(600, 400));
                optionsModule.initialLoadFromPreferences();
                frameHandler.showFrame();
                updateModule.checkOnStart(frameHandler.getFrame());
                xbupServiceModule.openConnectionDialog((Component)frameHandler.getFrame());
            }
            catch (ParseException ex) {
                Logger.getLogger(XBManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

