/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.ubnumber.type;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBSerializationMode;
import org.exbin.xbup.core.ubnumber.UBInteger;
import org.exbin.xbup.core.ubnumber.UBNatural;
import org.exbin.xbup.core.ubnumber.exception.UBOverFlowException;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

@ParametersAreNonnullByDefault
public class UBInt32
implements UBInteger,
XBPSequenceSerializable {
    private long value;

    public UBInt32() {
        this.value = 0L;
    }

    public UBInt32(int value) {
        this.value = value;
    }

    public UBInt32(long value) {
        this.value = value;
    }

    @Override
    public int getInt() throws UBOverFlowException {
        return (int)this.value;
    }

    @Override
    public long getLong() throws UBOverFlowException {
        return this.value;
    }

    @Override
    public boolean isZero() {
        return this.value == 0L;
    }

    @Override
    public void setValue(int value) throws UBOverFlowException {
        this.value = value;
    }

    @Override
    public void setValue(long value) throws UBOverFlowException {
        this.value = (int)value;
    }

    @Override
    public long getSegmentCount() {
        return 1L;
    }

    @Override
    public long getValueSegment(long segmentIndex) {
        if (segmentIndex != 0L) {
            throw new IndexOutOfBoundsException();
        }
        return this.value;
    }

    public int hashCode() {
        return Long.valueOf(this.value).hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UBInt32 other = (UBInt32)obj;
        return this.value == other.value;
    }

    @Override
    public void serializeXB(XBPSequenceSerialHandler serial) throws XBProcessingException, IOException {
        serial.begin();
        serial.matchType(new XBDeclBlockType(XBUP_BLOCKREV_CATALOGPATH));
        if (serial.getSerializationMode() == XBSerializationMode.PULL) {
            this.convertFromNatural(serial.pullAttribute().convertToNatural());
        } else {
            serial.putAttribute(this.convertToNatural());
        }
        serial.end();
    }

    @Override
    public int fromStreamUB(InputStream stream) throws IOException, XBProcessingException {
        byte[] buffer = new byte[1];
        this.readBuf(stream, buffer);
        long input = (char)buffer[0] & 0xFF;
        if (input < 128L) {
            boolean negativeValue = (input & 0x40L) > 0L;
            this.value = input & 0x3FL;
            this.value = negativeValue ? (this.value = this.value - 64L) : this.value;
            return 1;
        }
        if (input < 192L) {
            boolean negativeValue = (input & 0x20L) > 0L;
            this.value = (input & 0x1FL) << 8;
            this.readBuf(stream, buffer);
            this.value += (long)(buffer[0] & 0xFF);
            this.value = negativeValue ? (this.value = this.value - 8256L) : this.value + 64L;
            return 2;
        }
        if (input < 224L) {
            boolean negativeValue = (input & 0x10L) > 0L;
            this.value = (input & 0xFL) << 16;
            this.readBuf(stream, buffer);
            this.value += (long)((buffer[0] & 0xFF) << 8);
            this.readBuf(stream, buffer);
            this.value += (long)(buffer[0] & 0xFF);
            this.value = negativeValue ? (this.value = this.value - 1056832L) : this.value + 8256L;
            return 3;
        }
        if (input < 240L) {
            boolean negativeValue = (input & 8L) > 0L;
            this.value = (input & 7L) << 24;
            this.readBuf(stream, buffer);
            this.value += (long)((buffer[0] & 0xFF) << 16);
            this.readBuf(stream, buffer);
            this.value += (long)((buffer[0] & 0xFF) << 8);
            this.readBuf(stream, buffer);
            this.value += (long)(buffer[0] & 0xFF);
            this.value = negativeValue ? (this.value = this.value - 135274560L) : this.value + 1056832L;
            return 4;
        }
        if (input < 248L) {
            boolean negativeValue;
            boolean bl = negativeValue = (input & 4L) > 0L;
            if (negativeValue) {
                throw new XBProcessingException("Value is too big for 32-bit value", XBProcessingExceptionType.UNSUPPORTED);
            }
            this.value = (input & 3L) << 32;
            this.readBuf(stream, buffer);
            this.value += (long)((buffer[0] & 0xFF) << 24);
            this.readBuf(stream, buffer);
            this.value += (long)((buffer[0] & 0xFF) << 16);
            this.readBuf(stream, buffer);
            this.value += (long)((buffer[0] & 0xFF) << 8);
            this.readBuf(stream, buffer);
            this.value += (long)(buffer[0] & 0xFF);
            this.value += 135274560L;
            return 5;
        }
        throw new XBProcessingException("Value is too big for 32-bit value", XBProcessingExceptionType.UNSUPPORTED);
    }

    private void readBuf(InputStream stream, byte[] buffer) throws IOException {
        if (stream.read(buffer) < 0) {
            throw new XBProcessingException("End of data reached", XBProcessingExceptionType.UNEXPECTED_END_OF_STREAM);
        }
    }

    @Override
    public int toStreamUB(OutputStream stream) throws IOException {
        if (this.value < 0L) {
            if (this.value >= -64L) {
                stream.write((char)(128L + this.value));
                return 1;
            }
            if (this.value >= -8256L) {
                byte[] out = new byte[2];
                long outValue = 16448L + this.value;
                out[0] = (byte)((outValue >> 8) + 128L);
                out[1] = (byte)(outValue & 0xFFL);
                stream.write(out);
                return 2;
            }
            if (this.value >= -1056832L) {
                long outValue = 0x202040L + this.value;
                byte[] out = new byte[]{(byte)((outValue >> 16) + 192L), (byte)(outValue >> 8 & 0xFFL), (byte)(outValue & 0xFFL)};
                stream.write(out);
                return 3;
            }
            if (this.value >= -135274560L) {
                long outValue = 269492288L + this.value;
                byte[] out = new byte[]{(byte)((outValue >> 24) + 224L), (byte)(outValue >> 16 & 0xFFL), (byte)(outValue >> 8 & 0xFFL), (byte)(outValue & 0xFFL)};
                stream.write(out);
                return 4;
            }
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.value < 64L) {
            stream.write((char)this.value);
            return 1;
        }
        if (this.value < 8256L) {
            byte[] out = new byte[2];
            long outValue = this.value - 64L;
            out[0] = (byte)((outValue >> 8) + 128L);
            out[1] = (byte)(outValue & 0xFFL);
            stream.write(out);
            return 2;
        }
        if (this.value < 1056832L) {
            long outValue = this.value - 8256L;
            byte[] out = new byte[]{(byte)((outValue >> 16) + 192L), (byte)(outValue >> 8 & 0xFFL), (byte)(outValue & 0xFFL)};
            stream.write(out);
            return 3;
        }
        if (this.value < 135274560L) {
            long outValue = this.value - 1056832L;
            byte[] out = new byte[]{(byte)((outValue >> 24) + 224L), (byte)(outValue >> 16 & 0xFFL), (byte)(outValue >> 8 & 0xFFL), (byte)(outValue & 0xFFL)};
            stream.write(out);
            return 4;
        }
        long outValue = this.value - 135274560L;
        byte[] out = new byte[]{(byte)((outValue >> 32) + 240L), (byte)(outValue >> 24 & 0xFFL), (byte)(outValue >> 16 & 0xFFL), (byte)(outValue >> 8 & 0xFFL), (byte)(outValue & 0xFFL)};
        stream.write(out);
        return 5;
    }

    @Override
    public int getSizeUB() {
        if (this.value < 0L) {
            if (this.value >= -64L) {
                return 1;
            }
            if (this.value >= -8256L) {
                return 2;
            }
            if (this.value >= -1056832L) {
                return 3;
            }
            if (this.value >= -135274560L) {
                return 4;
            }
            return 5;
        }
        if (this.value < 64L) {
            return 1;
        }
        if (this.value < 8256L) {
            return 2;
        }
        if (this.value < 1056832L) {
            return 3;
        }
        if (this.value < 135274560L) {
            return 4;
        }
        return 5;
    }

    @Override
    public void setNaturalZero() {
        this.setNaturalLong(0L);
    }

    @Override
    public void setNaturalInt(int intValue) throws UBOverFlowException {
        this.setNaturalLong(intValue);
    }

    @Override
    public void setNaturalLong(long longValue) throws UBOverFlowException {
        this.value = longValue < 64L ? longValue : (longValue < 128L ? -128L + longValue : (longValue < 8320L ? longValue - 64L : (longValue < 16512L ? -16576L + longValue : (longValue < 1065088L ? longValue - 8320L : (longValue < 2113664L ? -2121984L + longValue : (longValue < 136331392L ? longValue - 1065088L : (longValue < 270549120L ? -271614208L + longValue : longValue - 136331392L)))))));
    }

    @Override
    public boolean isNaturalZero() {
        return this.value == 0L;
    }

    @Override
    public int getNaturalInt() throws UBOverFlowException {
        return (int)this.getNaturalLong();
    }

    @Override
    public long getNaturalLong() throws UBOverFlowException {
        if (this.value < 0L) {
            if (this.value >= -64L) {
                return 128L - this.value;
            }
            if (this.value >= -8256L) {
                return 8320L - this.value;
            }
            if (this.value >= -1056832L) {
                return 1056896L - this.value;
            }
            if (this.value >= -135274560L) {
                return 135274624L - this.value;
            }
            throw new UBOverFlowException("Unable to convert big negative value to natural");
        }
        if (this.value < 64L) {
            return this.value;
        }
        if (this.value < 8256L) {
            return this.value + 64L;
        }
        if (this.value < 135274560L) {
            return this.value + 8256L;
        }
        return this.value + 135274560L;
    }

    @Override
    public void convertFromNatural(UBNatural nat) {
        this.setNaturalLong(nat.getLong());
    }

    @Override
    @Nonnull
    public UBNatural convertToNatural() {
        return new UBNat32(this.getNaturalLong());
    }
}

