/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.serial.param;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.definition.XBParamType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBTConsumer;
import org.exbin.xbup.core.parser.basic.XBTProvider;
import org.exbin.xbup.core.parser.basic.convert.XBTProducerToProvider;
import org.exbin.xbup.core.parser.param.XBParamProcessingState;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBEditableAttribute;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTEndToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTokenType;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.convert.XBTListenerToToken;
import org.exbin.xbup.core.parser.token.event.XBTEventProducer;
import org.exbin.xbup.core.parser.token.event.convert.XBTEventProducerToProducer;
import org.exbin.xbup.core.parser.token.pull.XBTPullConsumer;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.parser.token.pull.convert.XBTProviderToPullProvider;
import org.exbin.xbup.core.parser.token.pull.convert.XBTPullPreLoader;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.basic.XBTBasicInputSerialHandler;
import org.exbin.xbup.core.serial.basic.XBTBasicSerializable;
import org.exbin.xbup.core.serial.child.XBTChildInputSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildSerializable;
import org.exbin.xbup.core.serial.param.XBPInputSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBPSerializable;
import org.exbin.xbup.core.serial.param.XBPTokenWrapper;
import org.exbin.xbup.core.serial.param.XBSerializationMode;
import org.exbin.xbup.core.serial.sequence.XBListConsistSerializable;
import org.exbin.xbup.core.serial.sequence.XBListJoinSerializable;
import org.exbin.xbup.core.serial.sequence.XBSerialSequenceItem;
import org.exbin.xbup.core.serial.token.XBTTokenInputSerialHandler;
import org.exbin.xbup.core.stream.XBOutput;
import org.exbin.xbup.core.ubnumber.UBENatural;
import org.exbin.xbup.core.ubnumber.UBNatural;
import org.exbin.xbup.core.ubnumber.type.UBENat32;

@ParametersAreNonnullByDefault
public class XBPProviderSerialHandler
implements XBPInputSerialHandler,
XBPSequenceSerialHandler,
XBTTokenInputSerialHandler {
    private XBPSequencePullConsumer pullProvider;
    private boolean finished = false;
    private final List<XBParamType> paramTypes = new ArrayList<XBParamType>();
    private XBParamType paramType = XBParamType.CONSIST;
    private static final String PUSH_NOT_ALLOWED_EXCEPTION = "Pushing data not allowed in pulling mode";
    private XBTBeginToken beginToken = null;

    public XBPProviderSerialHandler() {
    }

    public XBPProviderSerialHandler(XBOutput output) {
        this.performAttachXBOutput(output);
    }

    @Override
    public void attachXBTPullProvider(XBTPullProvider pullProvider) {
        this.attachXBOutput(pullProvider);
    }

    public void attachXBOutput(XBTPullProvider pullProvider) {
        this.performAttachXBOutput(pullProvider);
    }

    private void performAttachXBOutput(XBOutput output) {
        this.pullProvider = output instanceof XBPSequencePullConsumer ? (XBPSequencePullConsumer)((Object)output) : new XBPSequencePullConsumer(output);
    }

    @Override
    @Nonnull
    public XBBlockTerminationMode pullBegin() throws XBProcessingException, IOException {
        XBTBeginToken token;
        if (this.paramType.isJoin()) {
            return XBBlockTerminationMode.SIZE_SPECIFIED;
        }
        if (this.beginToken != null) {
            token = this.beginToken;
            this.beginToken = null;
        } else {
            token = (XBTBeginToken)this.pullProvider.pullToken(XBTTokenType.BEGIN);
        }
        return token.getTerminationMode();
    }

    @Override
    @Nonnull
    public XBBlockType pullType() throws XBProcessingException, IOException {
        if (this.paramType.isJoin()) {
            return new XBFixedBlockType();
        }
        XBTTypeToken token = (XBTTypeToken)this.pullProvider.pullToken(XBTTokenType.TYPE);
        return token.getBlockType();
    }

    @Override
    @Nonnull
    public XBAttribute pullAttribute() throws XBProcessingException, IOException {
        XBTAttributeToken token = (XBTAttributeToken)this.pullProvider.pullToken(XBTTokenType.ATTRIBUTE);
        return token.getAttribute();
    }

    @Override
    public byte pullByteAttribute() throws XBProcessingException, IOException {
        return (byte)this.pullAttribute().getNaturalInt();
    }

    @Override
    public short pullShortAttribute() throws XBProcessingException, IOException {
        return (short)this.pullAttribute().getNaturalInt();
    }

    @Override
    public int pullIntAttribute() throws XBProcessingException, IOException {
        return this.pullAttribute().getNaturalInt();
    }

    @Override
    public long pullLongAttribute() throws XBProcessingException, IOException {
        return this.pullAttribute().getNaturalLong();
    }

    @Override
    @Nonnull
    public InputStream pullData() throws XBProcessingException, IOException {
        XBTDataToken token = (XBTDataToken)this.pullProvider.pullToken(XBTTokenType.DATA);
        return token.getData();
    }

    @Override
    public boolean pullIfEmptyData() throws XBProcessingException, IOException {
        return this.pullProvider.pullIfEmpty();
    }

    @Override
    public boolean pullIfEmptyBlock() throws XBProcessingException, IOException {
        this.pullProvider.processAttributes();
        if (this.pullProvider.isEndNext()) {
            return true;
        }
        this.paramTypes.add(this.paramType);
        this.paramType = XBParamType.CONSIST;
        this.beginToken = XBTBeginToken.create(this.pullBegin());
        if (this.pullIfEmptyData()) {
            this.pullEnd();
            this.beginToken = null;
            return true;
        }
        this.paramType = this.paramTypes.remove(this.paramTypes.size() - 1);
        return false;
    }

    @Override
    public boolean isEndNext() {
        return this.pullProvider.isEndNext();
    }

    @Override
    public XBTTokenType getFutureTokenType() {
        return this.pullProvider.getFutureTokenType();
    }

    @Override
    public void pullEnd() throws XBProcessingException, IOException {
        if (this.paramType.isConsist()) {
            this.pullProvider.pullToken(XBTTokenType.END);
            this.pullProvider.pullRest();
        }
        this.paramType = this.paramTypes.isEmpty() ? XBParamType.CONSIST : this.paramTypes.remove(this.paramTypes.size() - 1);
        this.finished = true;
    }

    @Override
    @Nonnull
    public XBTToken pullToken(XBTTokenType tokenType) throws XBProcessingException, IOException {
        switch (tokenType) {
            case BEGIN: {
                return XBTBeginToken.create(this.pullBegin());
            }
            case TYPE: {
                return XBTTypeToken.create(this.pullType());
            }
            case ATTRIBUTE: {
                return XBTAttributeToken.create(this.pullAttribute());
            }
            case DATA: {
                return XBTDataToken.create(this.pullData());
            }
            case END: {
                this.pullEnd();
                return XBTEndToken.create();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    @Nonnull
    public XBTToken pullToken() throws XBProcessingException, IOException {
        XBTToken token = this.pullProvider.pullToken();
        if (token.getTokenType() == XBTTokenType.END) {
            this.pullProvider.pullRest();
        }
        return token;
    }

    @Override
    public void pullConsist(XBSerializable serial) throws XBProcessingException, IOException {
        this.paramTypes.add(this.paramType);
        this.paramType = XBParamType.CONSIST;
        this.process(serial);
    }

    @Override
    public void pullJoin(XBSerializable serial) throws XBProcessingException, IOException {
        this.paramTypes.add(this.paramType);
        this.paramType = XBParamType.JOIN;
        this.process(serial);
    }

    @Override
    public void pullListConsist(XBSerializable serial) throws XBProcessingException, IOException {
        UBENatural listSize;
        XBAttribute attribute = this.pullAttribute();
        if (attribute instanceof UBENatural) {
            listSize = (UBENatural)attribute;
        } else {
            listSize = new UBENat32();
            listSize.convertFromNatural(attribute.convertToNatural());
        }
        ((XBListConsistSerializable)serial).setSize(listSize);
        int listItemCount = listSize.getInt();
        ((XBListConsistSerializable)serial).reset();
        for (int i = 0; i < listItemCount; ++i) {
            this.paramTypes.add(this.paramType);
            this.paramType = XBParamType.CONSIST;
            this.process(((XBListConsistSerializable)serial).next());
        }
    }

    @Override
    public void pullListJoin(XBSerializable serial) throws XBProcessingException, IOException {
        UBNatural listSize = this.pullAttribute().convertToNatural();
        ((XBListJoinSerializable)serial).setSize(listSize);
        int listItemCount = listSize.getInt();
        ((XBListJoinSerializable)serial).reset();
        for (int i = 0; i < listItemCount; ++i) {
            this.paramTypes.add(this.paramType);
            this.paramType = XBParamType.JOIN;
            this.process(((XBListJoinSerializable)serial).next());
        }
    }

    @Override
    public void pullItem(XBSerialSequenceItem item) throws XBProcessingException, IOException {
        switch (item.getSequenceOp()) {
            case TOKEN: {
                this.pullToken(((XBPTokenWrapper)item.getItem()).getToken().getTokenType());
                break;
            }
            case CONSIST: {
                this.pullConsist(item.getItem());
                break;
            }
            case JOIN: {
                this.pullJoin(item.getItem());
                break;
            }
            case LIST_CONSIST: {
                this.pullListConsist(item.getItem());
                break;
            }
            case LIST_JOIN: {
                this.pullListJoin(item.getItem());
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void pullAppend(XBSerializable serial) throws XBProcessingException, IOException {
        this.process(serial);
    }

    @Override
    @Nonnull
    public XBSerializationMode getSerializationMode() {
        return XBSerializationMode.PULL;
    }

    @Override
    public void begin() throws XBProcessingException, IOException {
        this.pullBegin();
    }

    @Override
    public void matchType(XBBlockType blockType) throws XBProcessingException, IOException {
        XBBlockType type = this.pullType();
        if (blockType != null && blockType.getAsBasicType() != XBBasicBlockType.UNKNOWN_BLOCK && type.getAsBasicType() != XBBasicBlockType.UNKNOWN_BLOCK && !blockType.equals(type)) {
            throw new XBProcessingException("Block type doesn't match", XBProcessingExceptionType.BLOCK_TYPE_MISMATCH);
        }
    }

    @Override
    public void matchType() throws XBProcessingException, IOException {
        this.matchType(XBFixedBlockType.UNKNOWN_BLOCK_TYPE);
    }

    @Override
    public void end() throws XBProcessingException, IOException {
        this.pullEnd();
    }

    @Override
    public void attribute(XBEditableAttribute attributeValue) throws XBProcessingException, IOException {
        if (attributeValue instanceof UBNatural) {
            ((UBNatural)attributeValue).setValue(this.pullAttribute().getNaturalLong());
        } else {
            attributeValue.convertFromNatural(this.pullAttribute().convertToNatural());
        }
    }

    @Override
    public void consist(XBSerializable serial) throws XBProcessingException, IOException {
        this.pullConsist(serial);
    }

    @Override
    public void join(XBSerializable serial) throws XBProcessingException, IOException {
        this.pullJoin(serial);
    }

    @Override
    public void listConsist(XBSerializable serial) throws XBProcessingException, IOException {
        this.pullListConsist(serial);
    }

    @Override
    public void listJoin(XBSerializable serial) throws XBProcessingException, IOException {
        this.pullListJoin(serial);
    }

    @Override
    public void append(XBSerializable serial) throws XBProcessingException, IOException {
        this.pullAppend(serial);
    }

    public boolean isFinished() {
        return this.finished && this.paramTypes.isEmpty();
    }

    private void extractSerial(XBSerializable serial, XBPProviderSerialHandler provider) throws IOException, XBProcessingException {
        if (serial instanceof XBPSerializable) {
            ((XBPSerializable)serial).serializeFromXB(provider instanceof XBPInputSerialHandler ? provider : new SerialHandlerWrapper(provider));
        } else if (serial instanceof XBPSequenceSerializable) {
            ((XBPSequenceSerializable)serial).serializeXB((XBPSequenceSerialHandler)((Object)(provider instanceof XBPSequenceSerialHandler ? provider : new SerialHandlerWrapper(provider))));
        } else if (serial instanceof XBTChildSerializable) {
            ((XBTChildSerializable)serial).serializeFromXB(provider instanceof XBTChildInputSerialHandler ? (XBTChildInputSerialHandler)((Object)provider) : new SerialHandlerWrapper(provider));
        } else if (serial instanceof XBTBasicSerializable) {
            ((XBTBasicSerializable)serial).serializeFromXB(provider instanceof XBTBasicInputSerialHandler ? (XBTBasicInputSerialHandler)((Object)provider) : new SerialHandlerWrapper(provider));
        } else {
            throw new UnsupportedOperationException("Serialization method " + (serial == null ? "null" : serial.getClass().getCanonicalName()) + " not supported.");
        }
    }

    public void process(XBSerializable serial) throws IOException, XBProcessingException {
        this.extractSerial(serial, this);
    }

    @Override
    public void putBegin(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
        throw new XBProcessingException(PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void putType(XBBlockType type) throws XBProcessingException, IOException {
        throw new XBProcessingException(PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void putAttribute(XBAttribute attribute) throws XBProcessingException, IOException {
        throw new XBProcessingException(PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void putAttribute(byte attributeValue) throws XBProcessingException, IOException {
        throw new XBProcessingException(PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void putAttribute(short attributeValue) throws XBProcessingException, IOException {
        throw new XBProcessingException(PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void putAttribute(int attributeValue) throws XBProcessingException, IOException {
        throw new XBProcessingException(PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void putAttribute(long attributeValue) throws XBProcessingException, IOException {
        throw new XBProcessingException(PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void putData(InputStream data) throws XBProcessingException, IOException {
        throw new XBProcessingException(PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void putEnd() throws XBProcessingException, IOException {
        throw new XBProcessingException(PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void putToken(XBTToken token) throws XBProcessingException, IOException {
        throw new XBProcessingException(PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void putConsist(XBSerializable serial) throws XBProcessingException, IOException {
        throw new XBProcessingException(PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void putJoin(XBSerializable serial) throws XBProcessingException, IOException {
        throw new XBProcessingException(PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void putListConsist(XBSerializable serial) throws XBProcessingException, IOException {
        throw new XBProcessingException(PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void putListJoin(XBSerializable serial) throws XBProcessingException, IOException {
        throw new XBProcessingException(PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void putItem(XBSerialSequenceItem item) throws XBProcessingException, IOException {
        throw new XBProcessingException(PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @Override
    public void putAppend(XBSerializable serial) throws XBProcessingException, IOException {
        throw new XBProcessingException(PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
    }

    @ParametersAreNonnullByDefault
    private static class SerialHandlerWrapper
    implements XBTChildInputSerialHandler,
    XBTBasicInputSerialHandler,
    XBPInputSerialHandler,
    XBPSequenceSerialHandler {
        private final XBPProviderSerialHandler provider;

        public SerialHandlerWrapper(XBPProviderSerialHandler provider) {
            this.provider = provider;
        }

        @Override
        @Nonnull
        public XBBlockTerminationMode pullBegin() throws XBProcessingException, IOException {
            return this.provider.pullBegin();
        }

        @Override
        @Nonnull
        public XBBlockType pullType() throws XBProcessingException, IOException {
            return this.provider.pullType();
        }

        @Override
        @Nonnull
        public XBAttribute pullAttribute() throws XBProcessingException, IOException {
            return this.provider.pullAttribute();
        }

        @Override
        public byte pullByteAttribute() throws XBProcessingException, IOException {
            return this.provider.pullByteAttribute();
        }

        @Override
        public short pullShortAttribute() throws XBProcessingException, IOException {
            return this.provider.pullShortAttribute();
        }

        @Override
        public int pullIntAttribute() throws XBProcessingException, IOException {
            return this.provider.pullIntAttribute();
        }

        @Override
        public long pullLongAttribute() throws XBProcessingException, IOException {
            return this.provider.pullLongAttribute();
        }

        @Override
        public void pullChild(XBSerializable child) throws XBProcessingException, IOException {
            this.provider.pullConsist(child);
        }

        @Override
        public void pullAppend(XBSerializable serial) throws XBProcessingException, IOException {
            this.provider.pullAppend(serial);
        }

        @Override
        @Nonnull
        public InputStream pullData() throws XBProcessingException, IOException {
            return this.provider.pullData();
        }

        @Override
        public void pullEnd() throws XBProcessingException, IOException {
            this.provider.pullEnd();
        }

        @Override
        public void attachXBTPullProvider(XBTPullProvider provider) {
            throw new IllegalStateException();
        }

        @Override
        public void process(XBTConsumer consumer) {
            consumer.attachXBTProvider(listener -> {
                XBTToken token = this.provider.pullToken();
                XBTListenerToToken.tokenToListener(token, listener);
            });
        }

        @Override
        @Nonnull
        public XBSerializationMode getSerializationMode() {
            return XBSerializationMode.PUSH;
        }

        @Override
        public void begin() throws XBProcessingException, IOException {
            this.pullBegin();
        }

        @Override
        public void matchType(XBBlockType blockType) throws XBProcessingException, IOException {
            XBBlockType type = this.pullType();
            if (blockType != null && blockType.getAsBasicType() != XBBasicBlockType.UNKNOWN_BLOCK && type.getAsBasicType() != XBBasicBlockType.UNKNOWN_BLOCK && !blockType.equals(type)) {
                throw new XBProcessingException("Block type doesn't match", XBProcessingExceptionType.BLOCK_TYPE_MISMATCH);
            }
        }

        @Override
        public void matchType() throws XBProcessingException, IOException {
            this.pullType();
        }

        @Override
        public void end() throws XBProcessingException, IOException {
            this.pullEnd();
        }

        @Override
        public void attribute(XBEditableAttribute attributeValue) throws XBProcessingException, IOException {
            if (attributeValue instanceof UBNatural) {
                ((UBNatural)attributeValue).setValue(this.pullAttribute().getNaturalLong());
            } else {
                attributeValue.convertFromNatural(this.pullAttribute().convertToNatural());
            }
        }

        @Override
        public void consist(XBSerializable serial) throws XBProcessingException, IOException {
            this.pullConsist(serial);
        }

        @Override
        public void join(XBSerializable serial) throws XBProcessingException, IOException {
            this.pullJoin(serial);
        }

        @Override
        public void listConsist(XBSerializable serial) throws XBProcessingException, IOException {
            this.pullListConsist(serial);
        }

        @Override
        public void listJoin(XBSerializable serial) throws XBProcessingException, IOException {
            this.pullListJoin(serial);
        }

        @Override
        public void append(XBSerializable serial) throws XBProcessingException, IOException {
            this.pullAppend(serial);
        }

        @Override
        public void putBegin(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPProviderSerialHandler.PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void putType(XBBlockType type) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPProviderSerialHandler.PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void putAttribute(XBAttribute attribute) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPProviderSerialHandler.PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void putAttribute(byte attributeValue) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPProviderSerialHandler.PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void putAttribute(short attributeValue) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPProviderSerialHandler.PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void putAttribute(int attributeValue) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPProviderSerialHandler.PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void putAttribute(long attributeValue) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPProviderSerialHandler.PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void putData(InputStream data) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPProviderSerialHandler.PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void putEnd() throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPProviderSerialHandler.PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void putToken(XBTToken token) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPProviderSerialHandler.PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void putConsist(XBSerializable serial) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPProviderSerialHandler.PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void putJoin(XBSerializable serial) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPProviderSerialHandler.PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void putListConsist(XBSerializable serial) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPProviderSerialHandler.PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void putListJoin(XBSerializable serial) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPProviderSerialHandler.PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void putItem(XBSerialSequenceItem item) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPProviderSerialHandler.PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public void putAppend(XBSerializable serial) throws XBProcessingException, IOException {
            throw new XBProcessingException(XBPProviderSerialHandler.PUSH_NOT_ALLOWED_EXCEPTION, XBProcessingExceptionType.ILLEGAL_OPERATION);
        }

        @Override
        public boolean pullIfEmptyData() throws XBProcessingException, IOException {
            return this.provider.pullIfEmptyData();
        }

        @Override
        public boolean pullIfEmptyBlock() throws XBProcessingException, IOException {
            return this.provider.pullIfEmptyBlock();
        }

        @Override
        @Nonnull
        public XBTToken pullToken(XBTTokenType tokenType) throws XBProcessingException, IOException {
            return this.provider.pullToken(tokenType);
        }

        @Override
        @Nonnull
        public XBTToken pullToken() throws XBProcessingException, IOException {
            return this.provider.pullToken();
        }

        @Override
        public void pullConsist(XBSerializable child) throws XBProcessingException, IOException {
            this.provider.pullConsist(child);
        }

        @Override
        public void pullJoin(XBSerializable serial) throws XBProcessingException, IOException {
            this.provider.pullJoin(serial);
        }

        @Override
        public void pullListConsist(XBSerializable child) throws XBProcessingException, IOException {
            this.provider.pullListConsist(child);
        }

        @Override
        public void pullListJoin(XBSerializable serial) throws XBProcessingException, IOException {
            this.provider.pullListJoin(serial);
        }

        @Override
        public void pullItem(XBSerialSequenceItem item) throws XBProcessingException, IOException {
            this.provider.pullItem(item);
        }

        @Override
        public boolean isEndNext() {
            return this.provider.isEndNext();
        }

        @Override
        @Nullable
        public XBTTokenType getFutureTokenType() {
            return this.provider.getFutureTokenType();
        }
    }

    public static class XBPSequencePullConsumer
    implements XBTPullConsumer {
        private XBTPullPreLoader pullProvider;
        private final List<List<XBTAttributeToken>> attributeSequences = new ArrayList<List<XBTAttributeToken>>();
        private List<XBTAttributeToken> attributeSequence = new LinkedList<XBTAttributeToken>();
        private XBParamProcessingState processingState = XBParamProcessingState.START;
        private boolean emptyNodeMode = false;

        public XBPSequencePullConsumer(XBOutput output) {
            if (output instanceof XBTPullProvider) {
                this.attachProvider((XBTPullProvider)output);
            } else if (output instanceof XBTProvider) {
                this.attachProvider(new XBTProviderToPullProvider((XBTProvider)output));
            } else if (output instanceof XBTEventProducer) {
                this.attachProvider(new XBTProviderToPullProvider(new XBTProducerToProvider(new XBTEventProducerToProducer((XBTEventProducer)output))));
            } else {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }

        @Override
        public void attachXBTPullProvider(XBTPullProvider pullProvider) {
            this.attachProvider(pullProvider);
        }

        private void attachProvider(XBTPullProvider pullProvider) {
            this.pullProvider = pullProvider instanceof XBTPullPreLoader ? (XBTPullPreLoader)pullProvider : new XBTPullPreLoader(pullProvider);
        }

        @Nonnull
        public XBTToken pullToken(XBTTokenType tokenType) throws XBProcessingException, IOException {
            switch (tokenType) {
                case BEGIN: {
                    if (this.processingState == XBParamProcessingState.DATA || this.processingState == XBParamProcessingState.BEGIN) {
                        throw new XBProcessingException("Begin token out of order", XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                    if (this.processingState == XBParamProcessingState.TYPE || this.processingState == XBParamProcessingState.ATTRIBUTES) {
                        this.processAttributes();
                        this.attributeSequences.add(this.attributeSequence);
                        this.attributeSequence = new LinkedList<XBTAttributeToken>();
                    }
                    XBTToken token = this.pullProvider.pullXBTToken();
                    this.processingState = XBParamProcessingState.BEGIN;
                    if (token.getTokenType() == XBTTokenType.END) {
                        this.emptyNodeMode = true;
                        return XBTBeginToken.create(XBBlockTerminationMode.SIZE_SPECIFIED);
                    }
                    if (token.getTokenType() != XBTTokenType.BEGIN) {
                        throw new XBProcessingException("Unexpected token type " + token.getTokenType(), XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                    return token;
                }
                case TYPE: {
                    if (this.processingState != XBParamProcessingState.BEGIN && !this.emptyNodeMode) {
                        throw new XBProcessingException("Type token out of order", XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                    XBTToken token = this.pullProvider.pullXBTToken();
                    if (token.getTokenType() != XBTTokenType.TYPE) {
                        throw new XBProcessingException("Unexpected token type", XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                    this.processingState = XBParamProcessingState.TYPE;
                    return token;
                }
                case ATTRIBUTE: {
                    if (this.processingState == XBParamProcessingState.DATA || this.processingState == XBParamProcessingState.START || this.emptyNodeMode) {
                        throw new XBProcessingException("Attribute token out of order", XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                    if (this.pullProvider.getNextTokenType() != XBTTokenType.ATTRIBUTE) {
                        this.processingState = XBParamProcessingState.ATTRIBUTES;
                        if (!this.attributeSequence.isEmpty()) {
                            return this.attributeSequence.remove(0);
                        }
                        return XBTAttributeToken.createZeroToken();
                    }
                    XBTToken token = this.pullProvider.pullXBTToken();
                    if (token.getTokenType() != XBTTokenType.ATTRIBUTE) {
                        throw new XBProcessingException("Unexpected token type", XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                    this.processingState = XBParamProcessingState.ATTRIBUTES;
                    return token;
                }
                case DATA: {
                    if (this.processingState != XBParamProcessingState.BEGIN) {
                        throw new XBProcessingException("Data token out of order", XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                    this.processingState = XBParamProcessingState.DATA;
                    if (this.emptyNodeMode) {
                        return XBTDataToken.createEmptyToken();
                    }
                    XBTToken token = this.pullProvider.pullXBTToken();
                    if (token.getTokenType() != XBTTokenType.DATA) {
                        throw new XBProcessingException("Unexpected token type", XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                    return token;
                }
                case END: {
                    if (this.processingState == XBParamProcessingState.BEGIN) {
                        throw new XBProcessingException("Unexpected token type", XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                    this.processingState = XBParamProcessingState.END;
                    if (this.emptyNodeMode) {
                        this.emptyNodeMode = false;
                    } else if (!this.attributeSequences.isEmpty()) {
                        this.attributeSequence = this.attributeSequences.remove(this.attributeSequences.size() - 1);
                    }
                    return XBTEndToken.create();
                }
            }
            throw new IllegalStateException();
        }

        @Nonnull
        public XBTToken pullToken() throws XBProcessingException, IOException {
            if (this.emptyNodeMode) {
                return this.pullToken(this.processingState == XBParamProcessingState.DATA ? XBTTokenType.END : XBTTokenType.DATA);
            }
            return this.pullToken(this.pullProvider.getNextTokenType());
        }

        public boolean pullIfEmpty() throws XBProcessingException, IOException {
            if (this.processingState != XBParamProcessingState.BEGIN) {
                throw new XBProcessingException("Empty data token test out of order", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
            if (this.emptyNodeMode) {
                this.processingState = XBParamProcessingState.DATA;
                return true;
            }
            XBTToken nextToken = this.pullProvider.getNextToken();
            if (nextToken != null && nextToken.getTokenType() == XBTTokenType.DATA && ((XBTDataToken)nextToken).isEmpty()) {
                this.pullProvider.pullXBTToken();
                this.processingState = XBParamProcessingState.DATA;
                return true;
            }
            return false;
        }

        public void processAttributes() throws XBProcessingException, IOException {
            while (this.pullProvider.getNextTokenType() == XBTTokenType.ATTRIBUTE) {
                this.attributeSequence.add((XBTAttributeToken)this.pullProvider.pullXBTToken());
            }
        }

        public boolean isFinished() {
            return this.processingState == XBParamProcessingState.END;
        }

        @Nullable
        public XBTTokenType getFutureTokenType() {
            return this.pullProvider.getNextTokenType();
        }

        public boolean isEndNext() {
            return this.getFutureTokenType() == XBTTokenType.END;
        }

        @Nonnull
        public List<XBTAttributeToken> getAttributeSequence() {
            return this.attributeSequence;
        }

        public void resetSequence() {
            this.attributeSequence = new LinkedList<XBTAttributeToken>();
            this.processingState = XBParamProcessingState.START;
        }

        public void pullRest() throws XBProcessingException, IOException {
            this.pullProvider.skipAttributes();
            this.pullProvider.skipChildren();
            XBTToken token = this.pullProvider.pullXBTToken();
            if (token.getTokenType() != XBTTokenType.END) {
                throw new XBProcessingException("End token was expected, but " + token.getTokenType().name() + " token was received", XBProcessingExceptionType.UNEXPECTED_ORDER);
            }
        }
    }
}

