/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.serial;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTEventListenerToListener;
import org.exbin.xbup.core.parser.token.event.convert.XBToXBTEventWrapper;
import org.exbin.xbup.core.serial.XBSerialReader;
import org.exbin.xbup.core.serial.XBSerialWriter;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.XBTWriteSerialHandler;
import org.exbin.xbup.core.serial.basic.XBTBasicSerializable;
import org.exbin.xbup.core.serial.basic.XBTListenerSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildListenerSerialHandler;
import org.exbin.xbup.core.serial.child.XBTChildSerializable;
import org.exbin.xbup.core.serial.token.XBTEventListenerSerialHandler;
import org.exbin.xbup.core.serial.token.XBTTokenSerializable;

@ParametersAreNonnullByDefault
public class XBTSerialWriter
implements XBTWriteSerialHandler {
    protected final XBTEventListener eventListener;

    public XBTSerialWriter(XBTEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    public void write(XBSerializable serial) {
        if (serial instanceof XBTBasicSerializable) {
            XBTListenerSerialHandler listenerHandler = new XBTListenerSerialHandler();
            listenerHandler.attachXBTListener(new XBTEventListenerToListener(this.eventListener));
            try {
                ((XBTBasicSerializable)serial).serializeToXB(listenerHandler);
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(XBSerialReader.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (serial instanceof XBTTokenSerializable) {
            XBTEventListenerSerialHandler listenerHandler = new XBTEventListenerSerialHandler();
            listenerHandler.attachXBTEventListener(this.eventListener);
            try {
                ((XBTTokenSerializable)serial).serializeToXB(listenerHandler);
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(XBSerialReader.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (serial instanceof XBTChildSerializable) {
            XBTChildListenerSerialHandler childOutput = new XBTChildListenerSerialHandler(this);
            childOutput.attachXBTEventListener(this.eventListener);
            try {
                ((XBTChildSerializable)serial).serializeToXB(childOutput);
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(XBTSerialWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (XBSerialWriter.isValidSerializableObject(serial)) {
            XBToXBTEventWrapper eventWrapper = new XBToXBTEventWrapper(this.eventListener);
            XBSerialWriter serialWriter = new XBSerialWriter(eventWrapper);
            serialWriter.write(serial);
        } else {
            throw new UnsupportedOperationException("Serialization method " + serial.getClass().getCanonicalName() + " not supported.");
        }
    }

    public static boolean isValidSerializableObject(XBSerializable serial) {
        return serial instanceof XBTBasicSerializable || serial instanceof XBTTokenSerializable || serial instanceof XBTChildSerializable || XBSerialWriter.isValidSerializableObject(serial);
    }
}

