/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.serial;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.pull.XBPullReader;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.parser.token.pull.convert.XBToXBTPullConvertor;
import org.exbin.xbup.core.serial.XBPReadSerialHandler;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBPSerializable;

@ParametersAreNonnullByDefault
public class XBPSerialReader
implements XBPReadSerialHandler {
    protected final XBTPullProvider pullProvider;

    public XBPSerialReader(XBTPullProvider pullProvider) {
        this.pullProvider = pullProvider;
    }

    public XBPSerialReader(InputStream inputStream) {
        XBToXBTPullConvertor provider = null;
        try {
            provider = new XBToXBTPullConvertor(new XBPullReader(inputStream));
        }
        catch (IOException ex) {
            Logger.getLogger(XBPSerialReader.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.pullProvider = provider;
    }

    @Override
    public void read(XBSerializable serial) throws XBProcessingException, IOException {
        if (!(serial instanceof XBPSerializable) && !(serial instanceof XBPSequenceSerializable)) {
            throw new UnsupportedOperationException("Serialization method " + serial.getClass().getCanonicalName() + " not supported.");
        }
        XBPProviderSerialHandler childOutput = new XBPProviderSerialHandler();
        childOutput.attachXBTPullProvider(this.pullProvider);
        childOutput.process(serial);
    }

    public static boolean isValidSerializableObject(XBSerializable serial) {
        return serial instanceof XBPSerializable || serial instanceof XBPSequenceSerializable;
    }
}

