/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.pull.convert;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.token.XBAttributeToken;
import org.exbin.xbup.core.parser.token.XBBeginToken;
import org.exbin.xbup.core.parser.token.XBDataToken;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTEndToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.XBTokenType;
import org.exbin.xbup.core.parser.token.pull.XBPullConsumer;
import org.exbin.xbup.core.parser.token.pull.XBPullProvider;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;

@ParametersAreNonnullByDefault
public class XBToXBTPullConvertor
implements XBPullConsumer,
XBTPullProvider {
    private XBPullProvider pullProvider;
    private boolean first;
    private XBToken buffer;

    public XBToXBTPullConvertor(XBPullProvider pullProvider) {
        this.pullProvider = pullProvider;
    }

    @Override
    public void attachXBPullProvider(XBPullProvider pullProvider) {
        this.pullProvider = pullProvider;
        this.first = true;
        this.buffer = null;
    }

    @Override
    @Nonnull
    public XBTToken pullXBTToken() throws XBProcessingException, IOException {
        XBToken token;
        if (this.buffer != null) {
            token = this.buffer;
            this.buffer = null;
        } else {
            token = this.pullProvider.pullXBToken();
        }
        switch (token.getTokenType()) {
            case BEGIN: {
                this.first = true;
                return XBTBeginToken.create(((XBBeginToken)token).getTerminationMode());
            }
            case ATTRIBUTE: {
                if (this.first) {
                    XBFixedBlockType blockType;
                    this.first = false;
                    this.buffer = this.pullProvider.pullXBToken();
                    if (this.buffer.getTokenType() == XBTokenType.ATTRIBUTE) {
                        blockType = new XBFixedBlockType(((XBAttributeToken)token).getAttribute().getNaturalLong(), ((XBAttributeToken)this.buffer).getAttribute().getNaturalLong());
                        this.buffer = null;
                    } else {
                        blockType = new XBFixedBlockType(((XBAttributeToken)token).getAttribute().getNaturalLong(), 0L);
                    }
                    return XBTTypeToken.create(blockType);
                }
                return XBTAttributeToken.create(((XBAttributeToken)token).getAttribute());
            }
            case DATA: {
                return XBTDataToken.create(((XBDataToken)token).getData());
            }
            case END: {
                return XBTEndToken.create();
            }
        }
        throw new XBProcessingException("Unexpected token type", XBProcessingExceptionType.UNKNOWN);
    }
}

