/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTokenType;

@ParametersAreNonnullByDefault
public abstract class XBTBeginToken
implements XBTToken {
    private static XBTBeginTokenImpl sizeSpecifiedBeginToken = null;
    private static XBTBeginTokenImpl terminatedByZeroBeginToken = null;

    @Nonnull
    public abstract XBBlockTerminationMode getTerminationMode();

    @Override
    @Nonnull
    public XBTTokenType getTokenType() {
        return XBTTokenType.BEGIN;
    }

    @Nonnull
    public static XBTBeginToken create(XBBlockTerminationMode terminationMode) {
        switch (terminationMode) {
            case SIZE_SPECIFIED: {
                return XBTBeginToken.getSizeSpecifiedInstance();
            }
            case TERMINATED_BY_ZERO: {
                return XBTBeginToken.getTerminatedByZeroInstance();
            }
        }
        throw new IllegalStateException("Unexpected termination mode");
    }

    @Nonnull
    public static XBTBeginToken getSizeSpecifiedInstance() {
        if (sizeSpecifiedBeginToken == null) {
            sizeSpecifiedBeginToken = new XBTBeginTokenImpl(XBBlockTerminationMode.SIZE_SPECIFIED);
        }
        return sizeSpecifiedBeginToken;
    }

    @Nonnull
    public static XBTBeginToken getTerminatedByZeroInstance() {
        if (terminatedByZeroBeginToken == null) {
            terminatedByZeroBeginToken = new XBTBeginTokenImpl(XBBlockTerminationMode.TERMINATED_BY_ZERO);
        }
        return terminatedByZeroBeginToken;
    }

    @ParametersAreNonnullByDefault
    private static class XBTBeginTokenImpl
    extends XBTBeginToken {
        @Nonnull
        private final XBBlockTerminationMode terminationMode;

        private XBTBeginTokenImpl(XBBlockTerminationMode terminationMode) {
            this.terminationMode = terminationMode;
        }

        @Override
        @Nonnull
        public XBBlockTerminationMode getTerminationMode() {
            return this.terminationMode;
        }
    }
}

