/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block;

import javax.annotation.Nullable;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBFBlockType;
import org.exbin.xbup.core.ubnumber.UBNatural;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

public class XBFixedBlockType
implements XBFBlockType {
    private final UBNatural groupID;
    private final UBNatural blockID;
    public static final XBFixedBlockType UNKNOWN_BLOCK_TYPE = new XBFixedBlockType();

    public XBFixedBlockType() {
        this.groupID = new UBNat32(0);
        this.blockID = new UBNat32(0);
    }

    public XBFixedBlockType(UBNatural groupID, UBNatural blockID) {
        this.groupID = groupID;
        this.blockID = blockID;
    }

    public XBFixedBlockType(long groupID, long blockID) {
        this.groupID = new UBNat32(groupID);
        this.blockID = new UBNat32(blockID);
    }

    public XBFixedBlockType(int groupID, int blockID) {
        this.groupID = new UBNat32(groupID);
        this.blockID = new UBNat32(blockID);
    }

    public XBFixedBlockType(XBBasicBlockType type) {
        this.groupID = new UBNat32(0);
        this.blockID = new UBNat32(type.ordinal());
    }

    @Override
    public XBBasicBlockType getAsBasicType() {
        if (this.groupID.getLong() == 0L) {
            return XBBasicBlockType.valueOf((int)this.blockID.getLong());
        }
        return null;
    }

    @Override
    public UBNatural getGroupID() {
        return this.groupID;
    }

    @Override
    public UBNatural getBlockID() {
        return this.blockID;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof XBFBlockType) {
            return ((XBFBlockType)obj).getGroupID().getLong() == 0L && this.groupID.getLong() == 0L && ((XBFBlockType)obj).getBlockID().getLong() == this.blockID.getLong();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this.groupID != null ? this.groupID.hashCode() : 0);
        hash = 29 * hash + (this.blockID != null ? this.blockID.hashCode() : 0);
        return hash;
    }

    public int getSizeUB() {
        return this.groupID.getSizeUB() + this.blockID.getSizeUB();
    }
}

