/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.docking;

import bibliothek.gui.dock.common.DefaultMultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.docking.EditorFactory;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.file.api.FileHandler;

@ParametersAreNonnullByDefault
public class EditorCDockable
extends DefaultMultipleCDockable {
    public static final String UNDEFINED_NAME = "Untitled";
    private final EditorFactory factory;
    private Component content;

    public EditorCDockable(EditorFactory factory) {
        super((MultipleCDockableFactory)factory, new CAction[0]);
        this.factory = factory;
        this.setLayout(new GridLayout(1, 1));
        this.setTitleText(UNDEFINED_NAME);
        this.setTitleShown(false);
        this.setSingleTabShown(true);
        this.setStickySwitchable(false);
        this.setMinimizable(false);
        this.setExternalizable(false);
        this.setMaximizable(false);
        this.setCloseable(false);
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        this.content = content;
        this.add(content);
        this.update();
    }

    public void update() {
        if (this.content instanceof EditorProvider) {
            String name;
            EditorProvider editorProvider = (EditorProvider)this.content;
            Optional activeFile = editorProvider.getActiveFile();
            if (!activeFile.isPresent()) {
                return;
            }
            FileHandler fileHandler = (FileHandler)activeFile.get();
            String title = fileHandler.getTitle();
            String string = name = title.isEmpty() ? UNDEFINED_NAME : title;
            if (fileHandler.isModified()) {
                name = name + " *";
            }
            this.setTitleText(name);
        }
    }
}

