/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.docking;

import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.action.predefined.CCloseAction;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.event.CVetoClosingEvent;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.DefaultCDockable;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.docking.EditorCDockable;
import org.exbin.framework.docking.EditorFactory;
import org.exbin.framework.docking.api.DockingModuleApi;
import org.exbin.framework.docking.api.EditorViewHandling;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.api.MultiEditorProvider;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.plugin.XBModuleHandler;

public class DockingModule
implements DockingModuleApi {
    public static final String FILE_EXIT_GROUP_ID = MODULE_ID + ".exit";
    public static final String VIEW_BARS_GROUP_ID = MODULE_ID + ".view";
    public static final String EDITOR_FACTORY_ID = "editor";
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private CControl control = null;
    private CGrid grid = null;
    private EditorFactory factory = null;
    private CLocation editorLocation = null;
    private MultiEditorProvider multiEditorProvider = null;
    private final Map<EditorProvider, EditorCDockable> editorMap = new HashMap<EditorProvider, EditorCDockable>();

    public void init(XBModuleHandler moduleHandler) {
        this.application = (XBApplication)moduleHandler;
        this.resourceBundle = LanguageUtils.getResourceBundleByClass(this.getClass());
    }

    public void unregisterModule(String moduleId) {
    }

    public Component getDockingPanel() {
        if (this.control == null) {
            this.control = new CControl();
            this.control.setTheme("smooth");
            this.control.putProperty(StackDockStation.TAB_PLACEMENT, (Object)TabPlacement.TOP_OF_DOCKABLE);
            this.grid = new CGrid(this.control);
        }
        CContentArea area = this.control.getContentArea();
        return area;
    }

    public void addDockingView(Component component) {
        CContentArea area = this.control.getContentArea();
        DefaultCDockable view = new DefaultCDockable();
        view.add(component);
        view.setTitleText("Test");
        view.setTitleShown(false);
        view.setSingleTabShown(true);
        view.addAction((CAction)new CCloseAction(this.control));
        view.setLocation((CLocation)CLocation.maximized());
        view.setCloseable(true);
        CStation station = view.asStation();
        if (station instanceof StackDockStation) {
            ((StackDockStation)station).setTabPlacement(TabPlacement.TOP_OF_DOCKABLE);
        }
        this.grid = new CGrid(this.control);
        this.grid.add(0.0, 0.0, 1.0, 1.0, new CDockable[]{view});
        area.deploy(this.grid);
    }

    public EditorViewHandling getEditorViewHandling() {
        return new EditorViewHandling(){

            public void addEditorView(final EditorProvider editorProvider) {
                if (DockingModule.this.factory == null) {
                    DockingModule.this.factory = new EditorFactory();
                    DockingModule.this.control.addMultipleDockableFactory(DockingModule.EDITOR_FACTORY_ID, (MultipleCDockableFactory)DockingModule.this.factory);
                    DockingModule.this.editorLocation = (CLocation)CLocation.base();
                    DockingModule.this.control.addFocusListener(new CFocusListener(){

                        public void focusGained(CDockable dockable) {
                            EditorProvider editor = (EditorProvider)((EditorCDockable)dockable).getContent();
                            if (editor != null) {
                                // empty if block
                            }
                        }

                        public void focusLost(CDockable dockable) {
                        }
                    });
                }
                CContentArea area = DockingModule.this.control.getContentArea();
                EditorCDockable view = new EditorCDockable(DockingModule.this.factory);
                view.setContent((Component)editorProvider);
                view.addAction((CAction)new CCloseAction(DockingModule.this.control));
                view.setLocation(DockingModule.this.editorLocation);
                view.addVetoClosingListener(new CVetoClosingListener(){

                    public void closing(CVetoClosingEvent event) {
                    }

                    public void closed(CVetoClosingEvent event) {
                        for (int i = 0; i < event.getDockableCount(); ++i) {
                            CDockable dockable = event.getDockable(i);
                            if (!(dockable instanceof EditorCDockable)) continue;
                            EditorProvider editor = (EditorProvider)((EditorCDockable)dockable).getContent();
                            Optional activeFile = editor.getActiveFile();
                            if (activeFile.isPresent()) {
                                DockingModule.this.multiEditorProvider.closeFile((FileHandler)activeFile.get());
                            }
                            this.removeEditorView(editorProvider);
                        }
                    }
                });
                view.setLocation(area.getCenterArea().asStation().getDropLocation());
                DockingModule.this.control.addDockable((MultipleCDockable)view);
                view.setVisible(true);
                DockingModule.this.editorMap.put(editorProvider, view);
            }

            public void removeEditorView(EditorProvider editorProvider) {
                EditorCDockable dockable = (EditorCDockable)((Object)DockingModule.this.editorMap.remove(editorProvider));
                if (dockable != null) {
                    dockable.setVisible(false);
                    DockingModule.this.control.removeDockable((MultipleCDockable)dockable);
                }
            }

            public void setMultiEditorProvider(MultiEditorProvider multiEditor) {
                DockingModule.this.multiEditorProvider = multiEditor;
            }

            public void updateEditorView(EditorProvider editorProvider) {
                EditorCDockable dockable = (EditorCDockable)((Object)DockingModule.this.editorMap.get(editorProvider));
                if (dockable != null) {
                    dockable.update();
                }
            }
        };
    }
}

