/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.parser_tree;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBEditableBlock;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTEditableBlock;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.parser_tree.XBTBlockToXBBlock;

public class XBBlockToXBTBlock
implements XBTEditableBlock {
    private final XBBlock block;

    public XBBlockToXBTBlock(XBBlock block) {
        this.block = block;
    }

    public XBBlock getBlock() {
        return this.block;
    }

    @Nonnull
    public Optional<XBTBlock> getParentBlock() {
        Optional optParent = this.block.getParentBlock();
        if (!optParent.isPresent()) {
            return Optional.empty();
        }
        XBBlock parent = (XBBlock)optParent.get();
        if (parent instanceof XBTBlockToXBBlock) {
            return Optional.of(((XBTBlockToXBBlock)parent).getBlock());
        }
        return Optional.of(new XBBlockToXBTBlock(parent));
    }

    public XBBlockDataMode getDataMode() {
        return this.block.getDataMode();
    }

    public XBBlockTerminationMode getTerminationMode() {
        return this.block.getTerminationMode();
    }

    public XBBlockType getBlockType() {
        return new XBFixedBlockType(this.block.getAttributesCount() > 0 ? this.block.getAttributeAt(0).getNaturalLong() : 0L, this.block.getAttributesCount() > 1 ? this.block.getAttributeAt(1).getNaturalLong() : 0L);
    }

    public void setBlockType(XBBlockType blockType) {
        if (!(this.block instanceof XBEditableBlock)) {
            throw new IllegalStateException("Cannot clear data of read only block");
        }
        if (blockType instanceof XBFixedBlockType) {
            if (this.block.getAttributesCount() < 2) {
                ((XBEditableBlock)this.block).setAttributesCount(2);
            }
        } else {
            throw new IllegalStateException("Setting non-fixed block type");
        }
        ((XBEditableBlock)this.block).setAttributeAt((XBAttribute)((XBFixedBlockType)blockType).getGroupID(), 0);
        ((XBEditableBlock)this.block).setAttributeAt((XBAttribute)((XBFixedBlockType)blockType).getBlockID(), 1);
    }

    public XBAttribute[] getAttributes() {
        int attributesCount = this.block.getAttributesCount();
        if (attributesCount < 3) {
            return new XBAttribute[0];
        }
        XBAttribute[] result = new XBAttribute[attributesCount - 2];
        System.arraycopy(this.block.getAttributes(), 2, result, 0, attributesCount - 2);
        return result;
    }

    public XBAttribute getAttributeAt(int attributeIndex) {
        return this.block.getAttributeAt(attributeIndex + 2);
    }

    public int getAttributesCount() {
        int attributesCount = this.block.getAttributesCount();
        return attributesCount < 2 ? 0 : attributesCount - 2;
    }

    public XBTBlock[] getChildren() {
        XBTBlock[] result = new XBTBlock[this.getChildrenCount()];
        int i = 0;
        for (XBBlock child : this.block.getChildren()) {
            result[i++] = new XBBlockToXBTBlock(child);
        }
        return result;
    }

    public XBTBlock getChildAt(int childIndex) {
        return new XBBlockToXBTBlock(this.block.getChildAt(childIndex));
    }

    public int getChildrenCount() {
        return this.block.getChildrenCount();
    }

    @Nonnull
    public InputStream getData() {
        return this.block.getData();
    }

    @Nonnull
    public BinaryData getBlockData() {
        return this.block.getBlockData();
    }

    public void setParent(XBTBlock parent) {
        if (!(this.block instanceof XBEditableBlock)) {
            throw new IllegalStateException("Cannot set parent of read only block");
        }
        if (parent instanceof XBBlockToXBTBlock) {
            ((XBEditableBlock)this.block).setParent(((XBBlockToXBTBlock)parent).block);
        } else {
            ((XBEditableBlock)this.block).setParent((XBBlock)(parent == null ? null : new XBTBlockToXBBlock(parent)));
        }
    }

    public void setTerminationMode(XBBlockTerminationMode terminationMode) {
        if (!(this.block instanceof XBEditableBlock)) {
            throw new IllegalStateException("Cannot set termination mode of read only block");
        }
        ((XBEditableBlock)this.block).setTerminationMode(terminationMode);
    }

    public void setDataMode(XBBlockDataMode dataMode) {
        if (!(this.block instanceof XBEditableBlock)) {
            throw new IllegalStateException("Cannot set data mode of read only block");
        }
        ((XBEditableBlock)this.block).setDataMode(dataMode);
    }

    public void setAttributes(XBAttribute[] attributes) {
        if (!(this.block instanceof XBEditableBlock)) {
            throw new IllegalStateException("Cannot set attribute of read only block");
        }
        XBAttribute[] result = new XBAttribute[attributes.length + 2];
        result[0] = new UBNat32(this.block.getAttributesCount() > 0 ? this.block.getAttributeAt(0).getNaturalLong() : 0L);
        result[1] = new UBNat32(this.block.getAttributesCount() > 1 ? this.block.getAttributeAt(1).getNaturalLong() : 0L);
        System.arraycopy(this.block.getAttributes(), 0, result, 2, attributes.length - 2);
        ((XBTEditableBlock)this.block).setAttributes(result);
    }

    public void setAttributeAt(XBAttribute attribute, int attributeIndex) {
        if (!(this.block instanceof XBEditableBlock)) {
            throw new IllegalStateException("Cannot set attribute of read only block");
        }
        ((XBEditableBlock)this.block).setAttributeAt(attribute, attributeIndex + 2);
    }

    public void setAttributesCount(int count) {
        if (!(this.block instanceof XBEditableBlock)) {
            throw new IllegalStateException("Cannot set attribute count of read only block");
        }
        if (count >= 2) {
            ((XBEditableBlock)this.block).setAttributesCount(count - 2);
        } else {
            ((XBEditableBlock)this.block).setAttributesCount(0);
        }
    }

    public void removeAttribute(int attributeIndex) {
        if (!(this.block instanceof XBEditableBlock)) {
            throw new IllegalStateException("Cannot remove attribute count of read only block");
        }
        if (attributeIndex <= 2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        ((XBEditableBlock)this.block).removeAttribute(attributeIndex - 2);
    }

    public void setChildren(XBTBlock[] blocks) {
        if (!(this.block instanceof XBEditableBlock)) {
            throw new IllegalStateException("Cannot set child of read only block");
        }
        XBBlock[] convertedBlocks = new XBBlock[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            XBTBlock child = blocks[i];
            if (child instanceof XBTBlockToXBBlock) continue;
            convertedBlocks[i] = new XBTBlockToXBBlock(child);
        }
        ((XBEditableBlock)this.block).setChildren(convertedBlocks);
    }

    public void setChildAt(XBTBlock child, int childIndex) {
        if (!(child instanceof XBEditableBlock)) {
            throw new IllegalStateException("Cannot set attribute of read only block");
        }
        if (!(child instanceof XBTBlockToXBBlock)) {
            ((XBEditableBlock)this.block).setChildAt((XBBlock)new XBTBlockToXBBlock(child), childIndex);
        }
    }

    public void setChildrenCount(int count) {
        if (!(this.block instanceof XBEditableBlock)) {
            throw new IllegalStateException("Cannot set attribute of read only block");
        }
        ((XBEditableBlock)this.block).setChildrenCount(count);
    }

    public void removeChild(int childIndex) {
        if (!(this.block instanceof XBEditableBlock)) {
            throw new IllegalStateException("Cannot remove child of read only block");
        }
        ((XBEditableBlock)this.block).removeChild(childIndex);
    }

    public void setData(InputStream data) throws IOException {
        if (!(this.block instanceof XBEditableBlock)) {
            throw new IllegalStateException("Cannot set data of read only block");
        }
        ((XBEditableBlock)this.block).setData(data);
    }

    public void setData(BinaryData data) {
        if (!(this.block instanceof XBEditableBlock)) {
            throw new IllegalStateException("Cannot set data of read only block");
        }
        ((XBEditableBlock)this.block).setData(data);
    }

    public void clear() {
        if (!(this.block instanceof XBEditableBlock)) {
            throw new IllegalStateException("Cannot clear data of read only block");
        }
        ((XBEditableBlock)this.block).clear();
    }

    public XBTBlock createNewChild(int childIndex) {
        if (!(this.block instanceof XBEditableBlock)) {
            throw new IllegalStateException("Cannot set attribute of read only block");
        }
        XBBlock childBlock = ((XBEditableBlock)this.block).createNewChild(childIndex);
        return new XBBlockToXBTBlock(childBlock);
    }
}

