/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.parser_tree;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.tree.TreeNode;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBEditableBlock;
import org.exbin.xbup.core.parser.XBParsingException;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.wrapper.FixedDataInputStreamWrapper;
import org.exbin.xbup.core.parser.basic.wrapper.TerminatedDataInputStreamWrapper;
import org.exbin.xbup.core.parser.basic.wrapper.TerminatedDataOutputStreamWrapper;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.convert.XBTokenBuffer;
import org.exbin.xbup.core.stream.FinishableStream;
import org.exbin.xbup.core.type.XBData;
import org.exbin.xbup.core.ubnumber.UBStreamable;
import org.exbin.xbup.core.ubnumber.type.UBENat32;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.core.util.StreamUtils;

public class XBTreeNode
implements XBEditableBlock,
TreeNode,
UBStreamable {
    private XBTreeNode parent;
    private XBBlockTerminationMode terminationMode = XBBlockTerminationMode.SIZE_SPECIFIED;
    private XBBlockDataMode dataMode = XBBlockDataMode.NODE_BLOCK;
    private final List<XBAttribute> attributes = new ArrayList<XBAttribute>();
    private final List<XBBlock> children = new ArrayList<XBBlock>();
    private EditableBinaryData data = null;

    public XBTreeNode() {
        this(null);
    }

    public XBTreeNode(XBTreeNode parent) {
        this.parent = parent;
    }

    public int getSubNodesCount() {
        int result = this.children.size();
        if (result > 0) {
            Iterator<XBBlock> it = this.children.iterator();
            while (it.hasNext()) {
                result += ((XBTreeNode)it.next()).getSubNodesCount();
            }
        }
        return result;
    }

    public int getBlockIndex() {
        if (this.parent != null) {
            int result = this.parent.getBlockIndex() + 1;
            Iterator<XBBlock> it = this.parent.children.iterator();
            XBTreeNode node = (XBTreeNode)it.next();
            while (node != this) {
                result += node.getSubNodesCount() + 1;
                if (!it.hasNext()) {
                    return -1;
                }
                node = (XBTreeNode)it.next();
            }
            return result;
        }
        return 0;
    }

    public int getNodeIndexAfter() {
        if (this.dataMode == XBBlockDataMode.NODE_BLOCK) {
            return this.getBlockIndex() + this.getSubNodesCount() + 1;
        }
        return this.getBlockIndex() + 1;
    }

    public XBTreeNode findNodeByIndex(long index) {
        if (index == 0L) {
            return this;
        }
        --index;
        if (this.getChildrenCount() > 0) {
            ArrayList<Iterator<XBBlock>> iterators = new ArrayList<Iterator<XBBlock>>();
            iterators.add(this.children.iterator());
            int depthLevel = 0;
            XBTreeNode node = (XBTreeNode)((Iterator)iterators.get(depthLevel)).next();
            while (node != null) {
                if (index == 0L) {
                    return node;
                }
                if (node.getChildrenCount() > 0) {
                    iterators.add(node.children.iterator());
                    ++depthLevel;
                }
                while (!((Iterator)iterators.get(depthLevel)).hasNext()) {
                    if (depthLevel == 0) {
                        return null;
                    }
                    iterators.remove(depthLevel);
                    --depthLevel;
                }
                node = (XBTreeNode)((Iterator)iterators.get(depthLevel)).next();
                --index;
            }
        }
        return null;
    }

    public int fromStreamUB(InputStream stream) throws IOException, XBProcessingException {
        return this.fromStreamUB(stream, false);
    }

    public int fromStreamUB(InputStream stream, boolean terminable) throws IOException, XBProcessingException {
        Integer dataPartSizeValue;
        this.clear();
        UBNat32 attributePartSize = new UBNat32();
        int size = attributePartSize.fromStreamUB(stream);
        if (attributePartSize.getLong() == 0L) {
            if (terminable) {
                return 1;
            }
            throw new XBParsingException("Unexpected terminator", XBProcessingExceptionType.UNEXPECTED_TERMINATOR);
        }
        UBENat32 dataPartSize = new UBENat32();
        size += dataPartSize.fromStreamUB(stream);
        this.terminationMode = dataPartSize.isInfinity() ? XBBlockTerminationMode.TERMINATED_BY_ZERO : XBBlockTerminationMode.SIZE_SPECIFIED;
        Integer n = dataPartSizeValue = dataPartSize.isInfinity() ? null : Integer.valueOf(dataPartSize.getInt());
        if (attributePartSize.getInt() == dataPartSize.getSizeUB()) {
            this.dataMode = XBBlockDataMode.DATA_BLOCK;
            this.data = new XBData();
            TerminatedDataInputStreamWrapper dataWrapper = dataPartSizeValue == null ? new TerminatedDataInputStreamWrapper(stream) : new FixedDataInputStreamWrapper(stream, dataPartSizeValue.intValue());
            this.data.loadFromStream((InputStream)dataWrapper);
            size = (int)((long)size + (this.data.getDataSize() + (long)(dataPartSizeValue == null ? 2 : 0)));
        } else {
            if (attributePartSize.getInt() < dataPartSize.getSizeUB()) {
                throw new XBParsingException("Attribute overreached", XBProcessingExceptionType.ATTRIBUTE_OVERFLOW);
            }
            this.dataMode = XBBlockDataMode.NODE_BLOCK;
            attributePartSize.setValue(attributePartSize.getInt() - dataPartSize.getSizeUB());
            int itemSize = 0;
            do {
                UBNat32 attribute = new UBNat32();
                int attributeSize = attribute.fromStreamUB(stream);
                this.attributes.add((XBAttribute)attribute);
                size += attributeSize;
                if ((itemSize += attributeSize) <= attributePartSize.getInt()) continue;
                throw new XBParsingException("Attribute overreached", XBProcessingExceptionType.ATTRIBUTE_OVERFLOW);
            } while (itemSize < attributePartSize.getInt());
            if (dataPartSize.isInfinity() || dataPartSize.getInt() > 0) {
                size += this.childrenFromStreamUB(stream, dataPartSizeValue);
            }
        }
        return size;
    }

    public int childrenFromStreamUB(InputStream stream, Integer maxSize) throws IOException, XBProcessingException {
        int childSize;
        this.children.clear();
        if (maxSize != null && maxSize == 0) {
            return 0;
        }
        int size = 0;
        do {
            XBTreeNode child = new XBTreeNode();
            childSize = child.fromStreamUB(stream, maxSize == null);
            size += childSize;
            if (childSize <= 1) continue;
            if (maxSize != null && size > maxSize) {
                throw new XBParsingException("Block overreached", XBProcessingExceptionType.BLOCK_OVERFLOW);
            }
            this.children.add((XBBlock)child);
        } while (maxSize == null && childSize != 1 || maxSize != null && maxSize > 0 && size < maxSize);
        return size;
    }

    public int toStreamUB(OutputStream stream) throws IOException {
        if (this.dataMode == XBBlockDataMode.NODE_BLOCK) {
            UBENat32 dataPartSize;
            if (this.terminationMode == XBBlockTerminationMode.SIZE_SPECIFIED) {
                dataPartSize = new UBENat32(this.childrenSizeUB());
            } else {
                dataPartSize = new UBENat32();
                dataPartSize.setInfinity();
            }
            UBNat32 attributePartSize = new UBNat32(dataPartSize.getSizeUB() + this.attributesSizeUB());
            int size = attributePartSize.toStreamUB(stream);
            size += dataPartSize.toStreamUB(stream);
            Iterator<XBAttribute> iter = this.attributes.iterator();
            while (iter.hasNext()) {
                size += iter.next().toStreamUB(stream);
            }
            size += this.childrenToStreamUB(stream);
            if (this.terminationMode == XBBlockTerminationMode.TERMINATED_BY_ZERO) {
                stream.write(0);
                ++size;
            }
            return size;
        }
        int size = 0;
        if (this.terminationMode == XBBlockTerminationMode.SIZE_SPECIFIED) {
            UBENat32 dataPartSize = new UBENat32(this.getDataSize());
            UBNat32 attributePartSize = new UBNat32(dataPartSize.getSizeUB());
            size += attributePartSize.toStreamUB(stream);
            size += dataPartSize.toStreamUB(stream);
            this.data.saveToStream(stream);
            size = (int)((long)size + this.getDataSize());
        } else {
            UBNat32 attributePartSize = new UBNat32(1);
            size += attributePartSize.toStreamUB(stream);
            UBENat32 dataPartSize = new UBENat32();
            dataPartSize.setInfinity();
            size += dataPartSize.toStreamUB(stream);
            TerminatedDataOutputStreamWrapper streamWrapper = new TerminatedDataOutputStreamWrapper(stream);
            StreamUtils.copyInputStreamToOutputStream((InputStream)this.data.getDataInputStream(), (OutputStream)streamWrapper);
            int dataSize = (int)((FinishableStream)streamWrapper).finish();
            size += dataSize;
        }
        return size;
    }

    public int childrenToStreamUB(OutputStream stream) throws IOException {
        Iterator<XBBlock> iter = this.children.iterator();
        int size = 0;
        while (iter.hasNext()) {
            size += ((XBTreeNode)iter.next()).toStreamUB(stream);
        }
        return size;
    }

    public int getSizeUB() {
        if (this.dataMode == XBBlockDataMode.NODE_BLOCK) {
            int size = this.childrenSizeUB();
            UBENat32 dataPartSize = new UBENat32();
            if (this.terminationMode == XBBlockTerminationMode.SIZE_SPECIFIED) {
                dataPartSize.setValue(size);
            } else {
                dataPartSize.setInfinity();
            }
            UBNat32 attrPartSize = new UBNat32(dataPartSize.getSizeUB() + this.attributesSizeUB());
            size += attrPartSize.getSizeUB();
            size += attrPartSize.getInt();
            if (this.terminationMode == XBBlockTerminationMode.TERMINATED_BY_ZERO) {
                ++size;
            }
            return size;
        }
        int size = 0;
        if (this.terminationMode == XBBlockTerminationMode.SIZE_SPECIFIED) {
            UBENat32 dataPartSize = new UBENat32(this.getDataSize());
            UBNat32 attrPartSize = new UBNat32(dataPartSize.getSizeUB());
            size += attrPartSize.getSizeUB();
            size += dataPartSize.getSizeUB();
            size = (int)((long)size + this.getDataSize());
        } else {
            try {
                size += 2 + XBTokenBuffer.computeAdjustedSize((InputStream)this.getData());
            }
            catch (IOException ex) {
                Logger.getLogger(XBTreeNode.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return size;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.dataMode != XBBlockDataMode.NODE_BLOCK;
    }

    @Override
    public boolean isLeaf() {
        return this.dataMode == XBBlockDataMode.DATA_BLOCK || this.getChildrenCount() == 0;
    }

    public Enumeration<XBTreeNode> children() {
        return new Enumeration<XBTreeNode>(){
            private final Iterator<XBBlock> i;
            {
                this.i = XBTreeNode.this.children.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i.hasNext();
            }

            @Override
            public XBTreeNode nextElement() {
                return (XBTreeNode)this.i.next();
            }
        };
    }

    public void clear() {
        this.children.clear();
        this.attributes.clear();
        if (this.data != null) {
            this.data = null;
        }
    }

    public int childrenSizeUB() {
        Iterator<XBBlock> iter = this.children.iterator();
        int size = 0;
        while (iter.hasNext()) {
            size += ((XBTreeNode)iter.next()).getSizeUB();
        }
        return size;
    }

    public int attributesSizeUB() {
        Iterator<XBAttribute> iter = this.attributes.iterator();
        int size = 0;
        while (iter.hasNext()) {
            size += iter.next().getSizeUB();
        }
        return size;
    }

    public InputStream getData() {
        if (this.data == null) {
            return null;
        }
        return this.data.getDataInputStream();
    }

    public BinaryData getBlockData() {
        return this.data;
    }

    public long getDataSize() {
        if (this.data == null) {
            return 0L;
        }
        return this.data.getDataSize();
    }

    public void setData(InputStream source) throws IOException {
        if (source == null) {
            this.data = null;
        } else {
            this.data = new XBData();
            this.data.loadFromStream(source);
        }
    }

    public void setData(BinaryData newData) {
        this.data = new XBData();
        this.data.insert(0L, newData);
    }

    public void clearData() {
        this.data = null;
    }

    public XBTreeNode cloneNode(boolean recursive) {
        XBTreeNode node = new XBTreeNode(this.parent);
        node.setDataMode(this.dataMode);
        node.data = (XBData)this.data.copy();
        for (XBAttribute attribute : this.attributes) {
            node.addAttribute((XBAttribute)new UBNat32(attribute.getNaturalLong()));
        }
        ArrayList<XBTreeNode> cloneChildren = new ArrayList<XBTreeNode>();
        for (XBBlock block : this.children) {
            if (recursive) {
                cloneChildren.add(((XBTreeNode)block).cloneNode(true));
                continue;
            }
            cloneChildren.add((XBTreeNode)block);
        }
        node.setChildren(cloneChildren.toArray(new XBBlock[0]));
        return node;
    }

    public XBTreeNode createNewChild(int childIndex) {
        XBTreeNode childNode = new XBTreeNode(this);
        this.setChildAt((XBBlock)childNode, childIndex);
        return childNode;
    }

    public long getBlockSize() {
        return this.getSizeUB();
    }

    @Override
    @Nullable
    public XBTreeNode getParent() {
        return this.parent;
    }

    @Nonnull
    public Optional<XBBlock> getParentBlock() {
        return Optional.ofNullable(this.parent);
    }

    public void setParent(XBBlock parent) {
        if (parent != null && !(parent instanceof XBTreeNode)) {
            throw new IllegalArgumentException("Only XBTreeNode is allowed as parent for XBTreeNode");
        }
        this.parent = (XBTreeNode)parent;
    }

    public XBBlockTerminationMode getTerminationMode() {
        return this.terminationMode;
    }

    public void setTerminationMode(XBBlockTerminationMode terminationMode) {
        if (terminationMode == null) {
            throw new NullPointerException();
        }
        this.terminationMode = terminationMode;
    }

    public XBBlockDataMode getDataMode() {
        return this.dataMode;
    }

    public void setDataMode(XBBlockDataMode dataMode) {
        if (dataMode == null) {
            throw new NullPointerException();
        }
        this.dataMode = dataMode;
    }

    public XBAttribute getAttributeAt(int index) {
        return this.attributes.get(index);
    }

    public void setAttributeAt(XBAttribute attribute, int attributeIndex) {
        while (this.attributes.size() <= attributeIndex) {
            this.attributes.add((XBAttribute)new UBNat32());
        }
        this.attributes.set(attributeIndex, attribute);
    }

    public int getAttributesCount() {
        return this.attributes.size();
    }

    public void setAttributesCount(int count) {
        block3: {
            block2: {
                if (this.attributes.size() >= count) break block2;
                for (int i = this.attributes.size(); i < count; ++i) {
                    this.attributes.add((XBAttribute)new UBNat32());
                }
                break block3;
            }
            if (this.attributes.size() <= count) break block3;
            for (int i = this.attributes.size() - 1; i >= count; --i) {
                this.attributes.remove(i);
            }
        }
    }

    public void addAttribute(XBAttribute attribute) {
        this.attributes.add(attribute);
    }

    public void removeAttribute(int index) {
        this.attributes.remove(index);
    }

    public XBAttribute[] getAttributes() {
        return this.attributes.toArray(new XBAttribute[0]);
    }

    public void setAttributes(XBAttribute[] attributes) {
        this.attributes.clear();
        this.attributes.addAll(Arrays.asList(attributes));
    }

    @Override
    public XBTreeNode getChildAt(int childIndex) {
        return childIndex < this.children.size() ? (XBTreeNode)this.children.get(childIndex) : null;
    }

    public void setChildAt(XBBlock block, int childIndex) {
        while (this.children.size() <= childIndex) {
            this.children.add((XBBlock)new XBTreeNode(this));
        }
        this.children.set(childIndex, block);
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    public void addChild(XBTreeNode child) {
        this.children.add((XBBlock)child);
    }

    public void removeChild(int index) {
        this.children.remove(index);
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    @Override
    public int getChildCount() {
        return this.getChildrenCount();
    }

    public void setChildrenCount(int count) {
        block3: {
            block2: {
                if (this.children.size() >= count) break block2;
                for (int i = this.children.size(); i < count; ++i) {
                    this.children.add((XBBlock)new XBTreeNode(this));
                }
                break block3;
            }
            if (this.children.size() <= count) break block3;
            for (int i = this.children.size() - 1; i >= count; --i) {
                this.children.remove(i);
            }
        }
    }

    public XBBlock[] getChildren() {
        return this.children.toArray(new XBBlock[0]);
    }

    public void setChildren(XBBlock[] children) {
        this.children.clear();
        this.children.addAll(Arrays.asList(children));
    }

    public static XBTreeNode createTreeCopy(XBBlock block) {
        return XBTreeNode.createTreeCopy(block, null);
    }

    public static XBTreeNode createTreeCopy(XBBlock block, XBTreeNode parent) {
        XBTreeNode node = new XBTreeNode();
        node.setParent((XBBlock)parent);
        node.setDataMode(block.getDataMode());
        node.setTerminationMode(block.getTerminationMode());
        if (block.getDataMode() == XBBlockDataMode.NODE_BLOCK) {
            if (block.getAttributesCount() > 0) {
                node.setAttributes(block.getAttributes());
            }
            if (block.getChildrenCount() > 0) {
                for (XBBlock childBlock : block.getChildren()) {
                    XBTreeNode childNode = XBTreeNode.createTreeCopy(childBlock, node);
                    node.addChild(childNode);
                }
            }
        } else {
            XBData data = new XBData();
            data.insert(0L, block.getBlockData());
            node.setData((BinaryData)data);
        }
        return node;
    }
}

